/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.utils;

import android.content.Context;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.os.Build;
import android.util.Range;
import android.util.Rational;
import android.util.Size;
import io.github.thibaultbee.streampack.internal.sources.camera.InternalCameraExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\u001a\u0018\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0010\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0001*\u00020\u0003\u001a\u0012\u0010\b\u001a\u00020\t*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0010\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0001*\u00020\u0003\u001a0\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0001\"\b\b\u0000\u0010\r*\u00020\u000e*\u00020\u00032\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\r0\u00102\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0012\u0010\u0013\u001a\u00020\u0014*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0019\u0010\u0015\u001a\u0004\u0018\u00010\u0002*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0016\u001a\u0010\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0001*\u00020\u0003\u001a\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0012*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0018\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u0012*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0012\u0010\u001b\u001a\u00020\u001c*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0012\u0010\u001d\u001a\u00020\u001c*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001a\u0010\u001e\u001a\u00020\u001c*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0002\u001a\u0012\u0010 \u001a\u00020\u001c*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0012\u0010!\u001a\u00020\u001c*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\""}, d2={"getAutoFocusModes", "", "", "Landroid/content/Context;", "cameraId", "", "getAutoWhiteBalanceModes", "getBackCameraList", "getCameraCharacteristics", "Landroid/hardware/camera2/CameraCharacteristics;", "getCameraList", "getCameraOutputSizes", "Landroid/util/Size;", "T", "", "klass", "Ljava/lang/Class;", "getExposureRange", "Landroid/util/Range;", "getExposureStep", "Landroid/util/Rational;", "getFacingDirection", "(Landroid/content/Context;Ljava/lang/String;)Ljava/lang/Integer;", "getFrontCameraList", "getLensDistanceRange", "", "getZoomRatioRange", "isBackCamera", "", "isFlashAvailable", "isFrameRateSupported", "fps", "isFrontCamera", "isOpticalStabilizationAvailable", "core_release"})
public final class CameraExtensionsKt {
    @NotNull
    public static final CameraCharacteristics getCameraCharacteristics(@NotNull Context $this$getCameraCharacteristics, @NotNull String cameraId2) {
        Intrinsics.checkNotNullParameter((Object)$this$getCameraCharacteristics, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        Object object = $this$getCameraCharacteristics.getSystemService("camera");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.hardware.camera2.CameraManager");
        }
        CameraManager cameraManager = (CameraManager)object;
        CameraCharacteristics cameraCharacteristics = cameraManager.getCameraCharacteristics(cameraId2);
        Intrinsics.checkNotNullExpressionValue((Object)cameraCharacteristics, (String)"cameraManager.getCameraCharacteristics(cameraId)");
        return cameraCharacteristics;
    }

    @NotNull
    public static final List<String> getCameraList(@NotNull Context $this$getCameraList) {
        Intrinsics.checkNotNullParameter((Object)$this$getCameraList, (String)"<this>");
        Object object = $this$getCameraList.getSystemService("camera");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.hardware.camera2.CameraManager");
        }
        CameraManager cameraManager = (CameraManager)object;
        String[] stringArray = cameraManager.getCameraIdList();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"cameraManager.cameraIdList");
        return ArraysKt.toList((Object[])stringArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> getBackCameraList(@NotNull Context $this$getBackCameraList) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getBackCameraList, (String)"<this>");
        Iterable $this$filter$iv = CameraExtensionsKt.getCameraList($this$getBackCameraList);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Integer n = CameraExtensionsKt.getFacingDirection($this$getBackCameraList, it);
            int n2 = 1;
            if (!(n != null && n == n2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> getFrontCameraList(@NotNull Context $this$getFrontCameraList) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getFrontCameraList, (String)"<this>");
        Iterable $this$filter$iv = CameraExtensionsKt.getCameraList($this$getFrontCameraList);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Integer n = CameraExtensionsKt.getFacingDirection($this$getFrontCameraList, it);
            boolean bl2 = false;
            if (!(n != null && n == 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final boolean isBackCamera(@NotNull Context $this$isBackCamera, @NotNull String cameraId2) {
        Intrinsics.checkNotNullParameter((Object)$this$isBackCamera, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        Integer n = CameraExtensionsKt.getFacingDirection($this$isBackCamera, cameraId2);
        int n2 = 1;
        return n != null && n == n2;
    }

    public static final boolean isFrontCamera(@NotNull Context $this$isFrontCamera, @NotNull String cameraId2) {
        Intrinsics.checkNotNullParameter((Object)$this$isFrontCamera, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        Integer n = CameraExtensionsKt.getFacingDirection($this$isFrontCamera, cameraId2);
        boolean bl = false;
        return n != null && n == 0;
    }

    @Nullable
    public static final Integer getFacingDirection(@NotNull Context $this$getFacingDirection, @NotNull String cameraId2) {
        Intrinsics.checkNotNullParameter((Object)$this$getFacingDirection, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        return (Integer)CameraExtensionsKt.getCameraCharacteristics($this$getFacingDirection, cameraId2).get(CameraCharacteristics.LENS_FACING);
    }

    @NotNull
    public static final <T> List<Size> getCameraOutputSizes(@NotNull Context $this$getCameraOutputSizes, @NotNull Class<T> klass, @NotNull String cameraId2) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)$this$getCameraOutputSizes, (String)"<this>");
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)CameraExtensionsKt.getCameraCharacteristics($this$getCameraOutputSizes, cameraId2).get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        List list = streamConfigurationMap == null ? null : ((objectArray = streamConfigurationMap.getOutputSizes(klass)) == null ? null : ArraysKt.toList((Object[])objectArray));
        return list == null ? CollectionsKt.emptyList() : list;
    }

    public static final boolean isFrameRateSupported(@NotNull Context $this$isFrameRateSupported, @NotNull String cameraId2, int fps) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$isFrameRateSupported, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
            Iterable $this$any$iv = InternalCameraExtensionsKt.getCameraFpsList($this$isFrameRateSupported, cameraId2);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Range it = (Range)element$iv;
                    boolean bl2 = false;
                    if (!it.contains((Comparable)Integer.valueOf(fps))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isFlashAvailable(@NotNull Context $this$isFlashAvailable, @NotNull String cameraId2) {
        Intrinsics.checkNotNullParameter((Object)$this$isFlashAvailable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        Boolean bl = (Boolean)CameraExtensionsKt.getCameraCharacteristics($this$isFlashAvailable, cameraId2).get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
        return bl == null ? false : bl;
    }

    @NotNull
    public static final List<Integer> getAutoWhiteBalanceModes(@NotNull Context $this$getAutoWhiteBalanceModes, @NotNull String cameraId2) {
        Intrinsics.checkNotNullParameter((Object)$this$getAutoWhiteBalanceModes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        int[] nArray = (int[])CameraExtensionsKt.getCameraCharacteristics($this$getAutoWhiteBalanceModes, cameraId2).get(CameraCharacteristics.CONTROL_AWB_AVAILABLE_MODES);
        List list = nArray == null ? null : ArraysKt.toList((int[])nArray);
        return list == null ? CollectionsKt.emptyList() : list;
    }

    @NotNull
    public static final Range<Integer> getExposureRange(@NotNull Context $this$getExposureRange, @NotNull String cameraId2) {
        Intrinsics.checkNotNullParameter((Object)$this$getExposureRange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        Range range = (Range)CameraExtensionsKt.getCameraCharacteristics($this$getExposureRange, cameraId2).get(CameraCharacteristics.CONTROL_AE_COMPENSATION_RANGE);
        return range == null ? new Range((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(0)) : range;
    }

    @NotNull
    public static final Rational getExposureStep(@NotNull Context $this$getExposureStep, @NotNull String cameraId2) {
        Intrinsics.checkNotNullParameter((Object)$this$getExposureStep, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        Rational rational = (Rational)CameraExtensionsKt.getCameraCharacteristics($this$getExposureStep, cameraId2).get(CameraCharacteristics.CONTROL_AE_COMPENSATION_STEP);
        return rational == null ? new Rational(1, 1) : rational;
    }

    @NotNull
    public static final Range<Float> getZoomRatioRange(@NotNull Context $this$getZoomRatioRange, @NotNull String cameraId2) {
        Range range;
        Intrinsics.checkNotNullParameter((Object)$this$getZoomRatioRange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        return Build.VERSION.SDK_INT >= 30 ? ((range = (Range)CameraExtensionsKt.getCameraCharacteristics($this$getZoomRatioRange, cameraId2).get(CameraCharacteristics.CONTROL_ZOOM_RATIO_RANGE)) == null ? new Range((Comparable)Float.valueOf(1.0f), (Comparable)Float.valueOf(1.0f)) : range) : new Range((Comparable)Float.valueOf(1.0f), (Comparable)Float.valueOf(1.0f));
    }

    @NotNull
    public static final List<Integer> getAutoFocusModes(@NotNull Context $this$getAutoFocusModes, @NotNull String cameraId2) {
        Intrinsics.checkNotNullParameter((Object)$this$getAutoFocusModes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        int[] nArray = (int[])CameraExtensionsKt.getCameraCharacteristics($this$getAutoFocusModes, cameraId2).get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
        List list = nArray == null ? null : ArraysKt.toList((int[])nArray);
        return list == null ? CollectionsKt.emptyList() : list;
    }

    @NotNull
    public static final Range<Float> getLensDistanceRange(@NotNull Context $this$getLensDistanceRange, @NotNull String cameraId2) {
        Intrinsics.checkNotNullParameter((Object)$this$getLensDistanceRange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        Float f = (Float)CameraExtensionsKt.getCameraCharacteristics($this$getLensDistanceRange, cameraId2).get(CameraCharacteristics.LENS_INFO_MINIMUM_FOCUS_DISTANCE);
        return new Range((Comparable)Float.valueOf(0.0f), (Comparable)(f == null ? Float.valueOf(0.0f) : f));
    }

    public static final boolean isOpticalStabilizationAvailable(@NotNull Context $this$isOpticalStabilizationAvailable, @NotNull String cameraId2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isOpticalStabilizationAvailable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        int[] nArray = (int[])CameraExtensionsKt.getCameraCharacteristics($this$isOpticalStabilizationAvailable, cameraId2).get(CameraCharacteristics.LENS_INFO_AVAILABLE_OPTICAL_STABILIZATION);
        return nArray == null ? false : (bl = ArraysKt.contains((int[])nArray, (int)1));
    }
}

