/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.utils;

import android.content.Context;
import android.hardware.camera2.CaptureRequest;
import io.github.thibaultbee.streampack.internal.sources.camera.CameraController;
import io.github.thibaultbee.streampack.utils.CameraExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\u000fR$\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\n\"\u0004\b\u0012\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lio/github/thibaultbee/streampack/utils/Stabilization;", "", "context", "Landroid/content/Context;", "cameraController", "Lio/github/thibaultbee/streampack/internal/sources/camera/CameraController;", "(Landroid/content/Context;Lio/github/thibaultbee/streampack/internal/sources/camera/CameraController;)V", "availableOptical", "", "getAvailableOptical", "()Z", "value", "enableOptical", "getEnableOptical", "setEnableOptical", "(Z)V", "enableVideo", "getEnableVideo", "setEnableVideo", "core_release"})
public final class Stabilization {
    @NotNull
    private final Context context;
    @NotNull
    private final CameraController cameraController;

    public Stabilization(@NotNull Context context, @NotNull CameraController cameraController) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cameraController, (String)"cameraController");
        this.context = context;
        this.cameraController = cameraController;
    }

    public final boolean getEnableVideo() {
        Integer n = (Integer)this.cameraController.getSetting(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE);
        int n2 = 1;
        return n != null && n == n2;
    }

    public final void setEnableVideo(boolean value) {
        if (value) {
            CaptureRequest.Key key = CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE;
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"CONTROL_VIDEO_STABILIZATION_MODE");
            this.cameraController.setSetting(key, 1);
        } else {
            CaptureRequest.Key key = CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE;
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"CONTROL_VIDEO_STABILIZATION_MODE");
            this.cameraController.setSetting(key, 0);
        }
    }

    public final boolean getAvailableOptical() {
        boolean bl;
        String string = this.cameraController.getCameraId();
        if (string == null) {
            bl = false;
        } else {
            boolean bl2;
            String it = string;
            boolean bl3 = false;
            bl = bl2 = CameraExtensionsKt.isOpticalStabilizationAvailable(this.context, it);
        }
        return bl;
    }

    public final boolean getEnableOptical() {
        Integer n = (Integer)this.cameraController.getSetting(CaptureRequest.LENS_OPTICAL_STABILIZATION_MODE);
        int n2 = 1;
        return n != null && n == n2;
    }

    public final void setEnableOptical(boolean value) {
        if (value) {
            CaptureRequest.Key key = CaptureRequest.LENS_OPTICAL_STABILIZATION_MODE;
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"LENS_OPTICAL_STABILIZATION_MODE");
            this.cameraController.setSetting(key, 1);
        } else {
            CaptureRequest.Key key = CaptureRequest.LENS_OPTICAL_STABILIZATION_MODE;
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"LENS_OPTICAL_STABILIZATION_MODE");
            this.cameraController.setSetting(key, 0);
        }
    }
}

