/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.streamers.bases;

import android.content.Context;
import android.view.Surface;
import androidx.annotation.RequiresPermission;
import io.github.thibaultbee.streampack.data.AudioConfig;
import io.github.thibaultbee.streampack.data.Config;
import io.github.thibaultbee.streampack.data.VideoConfig;
import io.github.thibaultbee.streampack.error.StreamPackError;
import io.github.thibaultbee.streampack.internal.data.Frame;
import io.github.thibaultbee.streampack.internal.data.Packet;
import io.github.thibaultbee.streampack.internal.encoders.AudioMediaCodecEncoder;
import io.github.thibaultbee.streampack.internal.encoders.IEncoderListener;
import io.github.thibaultbee.streampack.internal.encoders.VideoMediaCodecEncoder;
import io.github.thibaultbee.streampack.internal.endpoints.IEndpoint;
import io.github.thibaultbee.streampack.internal.events.EventHandler;
import io.github.thibaultbee.streampack.internal.muxers.IMuxer;
import io.github.thibaultbee.streampack.internal.muxers.IMuxerListener;
import io.github.thibaultbee.streampack.internal.sources.IAudioCapture;
import io.github.thibaultbee.streampack.internal.sources.IVideoCapture;
import io.github.thibaultbee.streampack.listeners.OnErrorListener;
import io.github.thibaultbee.streampack.logger.ILogger;
import io.github.thibaultbee.streampack.logger.StreamPackLogger;
import io.github.thibaultbee.streampack.streamers.bases.BaseStreamer;
import io.github.thibaultbee.streampack.streamers.helpers.StreamerConfigurationHelper;
import io.github.thibaultbee.streampack.streamers.interfaces.IStreamer;
import io.github.thibaultbee.streampack.streamers.settings.BaseStreamerSettings;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0097\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007*\u0003\u001f2N\b&\u0018\u00002\u00020\u00012\u00020\u0002BO\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u0013J\u001c\u0010Q\u001a\u00020R2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010A\u001a\u0004\u0018\u00010BH\u0017J\u0010\u0010S\u001a\u00020R2\u0006\u0010T\u001a\u00020UH\u0002J\b\u0010V\u001a\u00020RH\u0016J\b\u0010W\u001a\u00020RH\u0002J\b\u0010X\u001a\u00020RH\u0002J\b\u0010Y\u001a\u00020RH\u0016J\b\u0010Z\u001a\u00020RH\u0016J\b\u0010[\u001a\u00020RH\u0004R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0010\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010 R\u0012\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010#R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010(R\u0014\u0010+\u001a\u00020,X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0010\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00103R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u00104\u001a\u0004\u0018\u00010\u0012X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u0014\u00109\u001a\u00020\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u00106R\u0014\u0010;\u001a\u00020<X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u0016\u0010\t\u001a\u0004\u0018\u00010\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010@R\u001c\u0010A\u001a\u0004\u0018\u00010BX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010D\"\u0004\bE\u0010FR\u001c\u0010G\u001a\u0004\u0018\u00010HX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010J\"\u0004\bK\u0010LR\u0010\u0010M\u001a\u00020NX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010OR\u0012\u0010P\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010#\u00a8\u0006\\"}, d2={"Lio/github/thibaultbee/streampack/streamers/bases/BaseStreamer;", "Lio/github/thibaultbee/streampack/internal/events/EventHandler;", "Lio/github/thibaultbee/streampack/streamers/interfaces/IStreamer;", "context", "Landroid/content/Context;", "logger", "Lio/github/thibaultbee/streampack/logger/ILogger;", "audioCapture", "Lio/github/thibaultbee/streampack/internal/sources/IAudioCapture;", "videoCapture", "Lio/github/thibaultbee/streampack/internal/sources/IVideoCapture;", "manageVideoOrientation", "", "muxer", "Lio/github/thibaultbee/streampack/internal/muxers/IMuxer;", "endpoint", "Lio/github/thibaultbee/streampack/internal/endpoints/IEndpoint;", "initialOnErrorListener", "Lio/github/thibaultbee/streampack/listeners/OnErrorListener;", "(Landroid/content/Context;Lio/github/thibaultbee/streampack/logger/ILogger;Lio/github/thibaultbee/streampack/internal/sources/IAudioCapture;Lio/github/thibaultbee/streampack/internal/sources/IVideoCapture;ZLio/github/thibaultbee/streampack/internal/muxers/IMuxer;Lio/github/thibaultbee/streampack/internal/endpoints/IEndpoint;Lio/github/thibaultbee/streampack/listeners/OnErrorListener;)V", "getAudioCapture", "()Lio/github/thibaultbee/streampack/internal/sources/IAudioCapture;", "audioConfig", "Lio/github/thibaultbee/streampack/data/AudioConfig;", "audioEncoder", "Lio/github/thibaultbee/streampack/internal/encoders/AudioMediaCodecEncoder;", "getAudioEncoder", "()Lio/github/thibaultbee/streampack/internal/encoders/AudioMediaCodecEncoder;", "setAudioEncoder", "(Lio/github/thibaultbee/streampack/internal/encoders/AudioMediaCodecEncoder;)V", "audioEncoderListener", "io/github/thibaultbee/streampack/streamers/bases/BaseStreamer$audioEncoderListener$1", "Lio/github/thibaultbee/streampack/streamers/bases/BaseStreamer$audioEncoderListener$1;", "audioTsStreamId", "", "Ljava/lang/Integer;", "getEndpoint", "()Lio/github/thibaultbee/streampack/internal/endpoints/IEndpoint;", "hasAudio", "getHasAudio", "()Z", "hasVideo", "getHasVideo", "helper", "Lio/github/thibaultbee/streampack/streamers/helpers/StreamerConfigurationHelper;", "getHelper", "()Lio/github/thibaultbee/streampack/streamers/helpers/StreamerConfigurationHelper;", "getLogger", "()Lio/github/thibaultbee/streampack/logger/ILogger;", "muxListener", "io/github/thibaultbee/streampack/streamers/bases/BaseStreamer$muxListener$1", "Lio/github/thibaultbee/streampack/streamers/bases/BaseStreamer$muxListener$1;", "onErrorListener", "getOnErrorListener", "()Lio/github/thibaultbee/streampack/listeners/OnErrorListener;", "setOnErrorListener", "(Lio/github/thibaultbee/streampack/listeners/OnErrorListener;)V", "onInternalErrorListener", "getOnInternalErrorListener", "settings", "Lio/github/thibaultbee/streampack/streamers/settings/BaseStreamerSettings;", "getSettings", "()Lio/github/thibaultbee/streampack/streamers/settings/BaseStreamerSettings;", "getVideoCapture", "()Lio/github/thibaultbee/streampack/internal/sources/IVideoCapture;", "videoConfig", "Lio/github/thibaultbee/streampack/data/VideoConfig;", "getVideoConfig", "()Lio/github/thibaultbee/streampack/data/VideoConfig;", "setVideoConfig", "(Lio/github/thibaultbee/streampack/data/VideoConfig;)V", "videoEncoder", "Lio/github/thibaultbee/streampack/internal/encoders/VideoMediaCodecEncoder;", "getVideoEncoder", "()Lio/github/thibaultbee/streampack/internal/encoders/VideoMediaCodecEncoder;", "setVideoEncoder", "(Lio/github/thibaultbee/streampack/internal/encoders/VideoMediaCodecEncoder;)V", "videoEncoderListener", "io/github/thibaultbee/streampack/streamers/bases/BaseStreamer$videoEncoderListener$1", "Lio/github/thibaultbee/streampack/streamers/bases/BaseStreamer$videoEncoderListener$1;", "videoTsStreamId", "configure", "", "onStreamError", "error", "Lio/github/thibaultbee/streampack/error/StreamPackError;", "release", "resetAudio", "resetVideo", "startStream", "stopStream", "stopStreamImpl", "core_release"})
public abstract class BaseStreamer
extends EventHandler
implements IStreamer {
    @NotNull
    private final Context context;
    @NotNull
    private final ILogger logger;
    @Nullable
    private final IAudioCapture audioCapture;
    @Nullable
    private final IVideoCapture videoCapture;
    @NotNull
    private final IMuxer muxer;
    @NotNull
    private final IEndpoint endpoint;
    @Nullable
    private OnErrorListener onErrorListener;
    @NotNull
    private final StreamerConfigurationHelper helper;
    @Nullable
    private Integer audioTsStreamId;
    @Nullable
    private Integer videoTsStreamId;
    @Nullable
    private VideoConfig videoConfig;
    @Nullable
    private AudioConfig audioConfig;
    @NotNull
    private final OnErrorListener onInternalErrorListener;
    @NotNull
    private final audioEncoderListener.1 audioEncoderListener;
    @NotNull
    private final videoEncoderListener.1 videoEncoderListener;
    @NotNull
    private final muxListener.1 muxListener;
    @Nullable
    private AudioMediaCodecEncoder audioEncoder;
    @Nullable
    private VideoMediaCodecEncoder videoEncoder;
    @NotNull
    private final BaseStreamerSettings settings;

    public BaseStreamer(@NotNull Context context, @NotNull ILogger logger, @Nullable IAudioCapture audioCapture, @Nullable IVideoCapture videoCapture, boolean manageVideoOrientation, @NotNull IMuxer muxer, @NotNull IEndpoint endpoint, @Nullable OnErrorListener initialOnErrorListener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)muxer, (String)"muxer");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        this.context = context;
        this.logger = logger;
        this.audioCapture = audioCapture;
        this.videoCapture = videoCapture;
        this.muxer = muxer;
        this.endpoint = endpoint;
        this.onErrorListener = initialOnErrorListener;
        this.helper = new StreamerConfigurationHelper(this.muxer.getHelper());
        this.onInternalErrorListener = new OnErrorListener(this){
            final /* synthetic */ BaseStreamer this$0;
            {
                this.this$0 = $receiver;
            }

            public void onError(@NotNull StreamPackError error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                BaseStreamer.access$onStreamError(this.this$0, error);
            }
        };
        this.audioEncoderListener = new IEncoderListener(this){
            final /* synthetic */ BaseStreamer this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public Frame onInputFrame(@NotNull ByteBuffer buffer) {
                Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
                IAudioCapture iAudioCapture = this.this$0.getAudioCapture();
                Intrinsics.checkNotNull((Object)iAudioCapture);
                return iAudioCapture.getFrame(buffer);
            }

            public void onOutputFrame(@NotNull Frame frame) {
                Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
                Integer n = BaseStreamer.access$getAudioTsStreamId$p(this.this$0);
                if (n != null) {
                    Integer n2 = n;
                    BaseStreamer baseStreamer = this.this$0;
                    int it = ((Number)n2).intValue();
                    boolean bl = false;
                    try {
                        BaseStreamer.access$getMuxer$p(baseStreamer).encode(frame, it);
                    }
                    catch (Exception e) {
                        throw new StreamPackError(e);
                    }
                }
            }
        };
        this.videoEncoderListener = new IEncoderListener(this){
            final /* synthetic */ BaseStreamer this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public Frame onInputFrame(@NotNull ByteBuffer buffer) {
                Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
                IVideoCapture iVideoCapture = this.this$0.getVideoCapture();
                Intrinsics.checkNotNull((Object)iVideoCapture);
                return iVideoCapture.getFrame(buffer);
            }

            public void onOutputFrame(@NotNull Frame frame) {
                Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
                Integer n = BaseStreamer.access$getVideoTsStreamId$p(this.this$0);
                if (n != null) {
                    Integer n2 = n;
                    BaseStreamer baseStreamer = this.this$0;
                    int it = ((Number)n2).intValue();
                    boolean bl = false;
                    try {
                        Long l;
                        long l2 = frame.getPts();
                        IVideoCapture iVideoCapture = baseStreamer.getVideoCapture();
                        Intrinsics.checkNotNull((Object)iVideoCapture);
                        frame.setPts(l2 + iVideoCapture.getTimestampOffset());
                        if (frame.getDts() != null) {
                            Long l3 = frame.getDts();
                            Intrinsics.checkNotNull((Object)l3);
                            l = l3 + baseStreamer.getVideoCapture().getTimestampOffset();
                        } else {
                            l = null;
                        }
                        frame.setDts(l);
                        BaseStreamer.access$getMuxer$p(baseStreamer).encode(frame, it);
                    }
                    catch (Exception e) {
                        throw new StreamPackError(e);
                    }
                }
            }
        };
        this.muxListener = new IMuxerListener(this){
            final /* synthetic */ BaseStreamer this$0;
            {
                this.this$0 = $receiver;
            }

            public void onOutputFrame(@NotNull Packet packet) {
                Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
                try {
                    this.this$0.getEndpoint().write(packet);
                }
                catch (Exception e) {
                    throw new StreamPackError(e);
                }
            }
        };
        this.audioEncoder = this.audioCapture != null ? new AudioMediaCodecEncoder(this.audioEncoderListener, this.onInternalErrorListener, this.logger) : (AudioMediaCodecEncoder)null;
        this.videoEncoder = this.videoCapture != null ? new VideoMediaCodecEncoder(this.videoEncoderListener, this.onInternalErrorListener, this.context, this.videoCapture.getHasSurface(), manageVideoOrientation, this.logger) : (VideoMediaCodecEncoder)null;
        this.settings = new BaseStreamerSettings(this.audioCapture, this.audioEncoder, this.videoEncoder);
        this.muxer.setManageVideoOrientation(manageVideoOrientation);
        this.muxer.setListener(this.muxListener);
    }

    public /* synthetic */ BaseStreamer(Context context, ILogger iLogger, IAudioCapture iAudioCapture, IVideoCapture iVideoCapture, boolean bl, IMuxer iMuxer, IEndpoint iEndpoint, OnErrorListener onErrorListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            iLogger = new StreamPackLogger();
        }
        if ((n & 0x80) != 0) {
            onErrorListener = null;
        }
        this(context, iLogger, iAudioCapture, iVideoCapture, bl, iMuxer, iEndpoint, onErrorListener);
    }

    @NotNull
    protected final ILogger getLogger() {
        return this.logger;
    }

    @Nullable
    protected final IAudioCapture getAudioCapture() {
        return this.audioCapture;
    }

    @Nullable
    protected final IVideoCapture getVideoCapture() {
        return this.videoCapture;
    }

    @NotNull
    protected final IEndpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    @Nullable
    public OnErrorListener getOnErrorListener() {
        return this.onErrorListener;
    }

    @Override
    public void setOnErrorListener(@Nullable OnErrorListener onErrorListener) {
        this.onErrorListener = onErrorListener;
    }

    @Override
    @NotNull
    public StreamerConfigurationHelper getHelper() {
        return this.helper;
    }

    @Nullable
    protected final VideoConfig getVideoConfig() {
        return this.videoConfig;
    }

    protected final void setVideoConfig(@Nullable VideoConfig videoConfig) {
        this.videoConfig = videoConfig;
    }

    @Override
    @NotNull
    protected final OnErrorListener getOnInternalErrorListener() {
        return this.onInternalErrorListener;
    }

    private final void onStreamError(StreamPackError error) {
        try {
            this.stopStream();
            OnErrorListener onErrorListener = this.getOnErrorListener();
            if (onErrorListener != null) {
                onErrorListener.onError(error);
            }
        }
        catch (Exception e) {
            ILogger.DefaultImpls.e$default(this.logger, this, "onStreamError: Can't stop stream", null, 4, null);
        }
    }

    @Nullable
    protected final AudioMediaCodecEncoder getAudioEncoder() {
        return this.audioEncoder;
    }

    protected final void setAudioEncoder(@Nullable AudioMediaCodecEncoder audioMediaCodecEncoder) {
        this.audioEncoder = audioMediaCodecEncoder;
    }

    @Nullable
    protected final VideoMediaCodecEncoder getVideoEncoder() {
        return this.videoEncoder;
    }

    protected final void setVideoEncoder(@Nullable VideoMediaCodecEncoder videoMediaCodecEncoder) {
        this.videoEncoder = videoMediaCodecEncoder;
    }

    @Override
    @NotNull
    public BaseStreamerSettings getSettings() {
        return this.settings;
    }

    private final boolean getHasAudio() {
        return this.audioCapture != null;
    }

    private final boolean getHasVideo() {
        return this.videoCapture != null;
    }

    @Override
    @RequiresPermission(value="android.permission.RECORD_AUDIO")
    public void configure(@Nullable AudioConfig audioConfig, @Nullable VideoConfig videoConfig) {
        if (this.getHasAudio() && !(audioConfig != null)) {
            boolean $i$a$-require-BaseStreamer$configure$32 = false;
            String $i$a$-require-BaseStreamer$configure$32 = "Requires audio config";
            throw new IllegalArgumentException($i$a$-require-BaseStreamer$configure$32.toString());
        }
        if (this.getHasVideo() && !(videoConfig != null)) {
            boolean bl = false;
            String string = "Requires video config";
            throw new IllegalArgumentException(string.toString());
        }
        this.videoConfig = videoConfig;
        this.audioConfig = audioConfig;
        try {
            int n;
            Config it;
            AudioConfig audioConfig2 = audioConfig;
            if (audioConfig2 != null) {
                it = audioConfig2;
                boolean bl = false;
                IAudioCapture iAudioCapture = this.getAudioCapture();
                if (iAudioCapture != null) {
                    iAudioCapture.configure(it);
                }
                AudioMediaCodecEncoder audioMediaCodecEncoder = this.getAudioEncoder();
                if (audioMediaCodecEncoder != null) {
                    audioMediaCodecEncoder.configure((AudioConfig)it);
                }
            }
            VideoConfig videoConfig2 = videoConfig;
            if (videoConfig2 != null) {
                it = videoConfig2;
                boolean bl = false;
                IVideoCapture iVideoCapture = this.getVideoCapture();
                if (iVideoCapture != null) {
                    iVideoCapture.configure(it);
                }
                VideoMediaCodecEncoder videoMediaCodecEncoder = this.getVideoEncoder();
                if (videoMediaCodecEncoder != null) {
                    videoMediaCodecEncoder.configure((VideoConfig)it);
                }
            }
            VideoConfig videoConfig3 = videoConfig;
            AudioConfig audioConfig3 = audioConfig;
            this.endpoint.configure((videoConfig3 == null ? 0 : (n = videoConfig3.getStartBitrate())) + (audioConfig3 == null ? 0 : (n = audioConfig3.getStartBitrate())));
        }
        catch (Exception e) {
            this.release();
            throw new StreamPackError(e);
        }
    }

    @Override
    public void startStream() {
        try {
            Config it;
            this.endpoint.startStream();
            List streams = new ArrayList();
            if (this.getHasVideo()) {
                VideoConfig videoConfig = this.videoConfig;
                Intrinsics.checkNotNull((Object)videoConfig);
                streams.add(videoConfig);
            }
            if (this.getHasAudio()) {
                AudioConfig audioConfig = this.audioConfig;
                Intrinsics.checkNotNull((Object)audioConfig);
                streams.add(audioConfig);
            }
            Map<Config, Integer> streamsIdMap = this.muxer.addStreams(streams);
            VideoConfig videoConfig = this.videoConfig;
            if (videoConfig != null) {
                it = videoConfig;
                boolean bl = false;
                VideoConfig videoConfig2 = this.getVideoConfig();
                if (videoConfig2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type io.github.thibaultbee.streampack.data.Config");
                }
                this.videoTsStreamId = streamsIdMap.get(videoConfig2);
            }
            AudioConfig audioConfig = this.audioConfig;
            if (audioConfig != null) {
                it = audioConfig;
                boolean bl = false;
                AudioConfig audioConfig2 = this.audioConfig;
                if (audioConfig2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type io.github.thibaultbee.streampack.data.Config");
                }
                this.audioTsStreamId = streamsIdMap.get(audioConfig2);
            }
            this.muxer.startStream();
            IAudioCapture iAudioCapture = this.audioCapture;
            if (iAudioCapture != null) {
                iAudioCapture.startStream();
            }
            AudioMediaCodecEncoder audioMediaCodecEncoder = this.audioEncoder;
            if (audioMediaCodecEncoder != null) {
                audioMediaCodecEncoder.startStream();
            }
            IVideoCapture iVideoCapture = this.videoCapture;
            if (iVideoCapture != null) {
                iVideoCapture.startStream();
            }
            VideoMediaCodecEncoder videoMediaCodecEncoder = this.videoEncoder;
            if (videoMediaCodecEncoder != null) {
                videoMediaCodecEncoder.startStream();
            }
        }
        catch (Exception e) {
            this.stopStream();
            throw new StreamPackError(e);
        }
    }

    @Override
    public void stopStream() {
        this.stopStreamImpl();
        this.resetAudio();
        this.resetVideo();
    }

    protected final void stopStreamImpl() {
        IVideoCapture iVideoCapture = this.videoCapture;
        if (iVideoCapture != null) {
            iVideoCapture.stopStream();
        }
        VideoMediaCodecEncoder videoMediaCodecEncoder = this.videoEncoder;
        if (videoMediaCodecEncoder != null) {
            videoMediaCodecEncoder.stopStream();
        }
        AudioMediaCodecEncoder audioMediaCodecEncoder = this.audioEncoder;
        if (audioMediaCodecEncoder != null) {
            audioMediaCodecEncoder.stopStream();
        }
        IAudioCapture iAudioCapture = this.audioCapture;
        if (iAudioCapture != null) {
            iAudioCapture.stopStream();
        }
        this.muxer.stopStream();
        this.endpoint.stopStream();
    }

    private final void resetAudio() {
        AudioMediaCodecEncoder audioMediaCodecEncoder = this.audioEncoder;
        if (audioMediaCodecEncoder != null) {
            audioMediaCodecEncoder.release();
        }
        AudioConfig audioConfig = this.audioConfig;
        if (audioConfig != null) {
            AudioConfig it = audioConfig;
            boolean bl = false;
            AudioMediaCodecEncoder audioMediaCodecEncoder2 = this.getAudioEncoder();
            if (audioMediaCodecEncoder2 != null) {
                audioMediaCodecEncoder2.configure(it);
            }
        }
    }

    private final void resetVideo() {
        VideoMediaCodecEncoder videoMediaCodecEncoder = this.videoEncoder;
        if (videoMediaCodecEncoder != null) {
            videoMediaCodecEncoder.release();
        }
        VideoConfig videoConfig = this.videoConfig;
        if (videoConfig != null) {
            VideoConfig it = videoConfig;
            boolean bl = false;
            VideoMediaCodecEncoder videoMediaCodecEncoder2 = this.getVideoEncoder();
            if (videoMediaCodecEncoder2 != null) {
                videoMediaCodecEncoder2.configure(it);
            }
        }
        IVideoCapture iVideoCapture = this.videoCapture;
        if (iVideoCapture != null) {
            VideoMediaCodecEncoder videoMediaCodecEncoder3 = this.videoEncoder;
            iVideoCapture.setEncoderSurface((Surface)(videoMediaCodecEncoder3 == null ? null : videoMediaCodecEncoder3.getInputSurface()));
        }
    }

    @Override
    public void release() {
        AudioMediaCodecEncoder audioMediaCodecEncoder = this.audioEncoder;
        if (audioMediaCodecEncoder != null) {
            audioMediaCodecEncoder.release();
        }
        VideoMediaCodecEncoder videoMediaCodecEncoder = this.videoEncoder;
        if (videoMediaCodecEncoder != null) {
            VideoMediaCodecEncoder.CodecSurface codecSurface = videoMediaCodecEncoder.getCodecSurface();
            if (codecSurface != null) {
                codecSurface.dispose();
            }
        }
        VideoMediaCodecEncoder videoMediaCodecEncoder2 = this.videoEncoder;
        if (videoMediaCodecEncoder2 != null) {
            videoMediaCodecEncoder2.release();
        }
        IAudioCapture iAudioCapture = this.audioCapture;
        if (iAudioCapture != null) {
            iAudioCapture.release();
        }
        IVideoCapture iVideoCapture = this.videoCapture;
        if (iVideoCapture != null) {
            iVideoCapture.release();
        }
        this.muxer.release();
        this.endpoint.release();
    }

    public static final /* synthetic */ void access$onStreamError(BaseStreamer $this, StreamPackError error) {
        $this.onStreamError(error);
    }

    public static final /* synthetic */ Integer access$getAudioTsStreamId$p(BaseStreamer $this) {
        return $this.audioTsStreamId;
    }

    public static final /* synthetic */ IMuxer access$getMuxer$p(BaseStreamer $this) {
        return $this.muxer;
    }

    public static final /* synthetic */ Integer access$getVideoTsStreamId$p(BaseStreamer $this) {
        return $this.videoTsStreamId;
    }
}

