/*
 * Decompiled with CFR 0.152.
 */
package com.github.thibaultbee.streampack.views;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceView;
import android.view.View;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0014J\u0016\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/github/thibaultbee/streampack/views/AutoFitSurfaceView;", "Landroid/view/SurfaceView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "aspectRatio", "", "onMeasure", "", "widthMeasureSpec", "heightMeasureSpec", "setAspectRatio", "width", "height", "Companion", "sdk_release"})
public final class AutoFitSurfaceView
extends SurfaceView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private float aspectRatio;
    private static final String TAG = AutoFitSurfaceView.class.getSimpleName();

    @JvmOverloads
    public AutoFitSurfaceView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyle);
    }

    public /* synthetic */ AutoFitSurfaceView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final void setAspectRatio(int width, int height) {
        if (!(width > 0 && height > 0)) {
            boolean bl = false;
            String string = "Size cannot be negative";
            throw new IllegalArgumentException(string.toString());
        }
        this.aspectRatio = (float)width / (float)height;
        this.getHolder().setFixedSize(width, height);
        this.requestLayout();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (this.aspectRatio == 0.0f) {
            this.setMeasuredDimension(width, height);
        } else {
            float actualRatio;
            int newWidth = 0;
            int newHeight = 0;
            float f = actualRatio = width > height ? this.aspectRatio : 1.0f / this.aspectRatio;
            if ((float)width < (float)height * actualRatio) {
                newHeight = height;
                newWidth = MathKt.roundToInt((float)((float)height * actualRatio));
            } else {
                newWidth = width;
                newHeight = MathKt.roundToInt((float)((float)width / actualRatio));
            }
            Log.d((String)TAG, (String)("Measured dimensions set: " + newWidth + " x " + newHeight));
            this.setMeasuredDimension(newWidth, newHeight);
        }
    }

    @JvmOverloads
    public AutoFitSurfaceView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public AutoFitSurfaceView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/github/thibaultbee/streampack/views/AutoFitSurfaceView$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

