/*
 * Decompiled with CFR 0.152.
 */
package com.github.thibaultbee.streampack.utils;

import android.content.Context;
import android.hardware.camera2.CaptureRequest;
import com.github.thibaultbee.streampack.internal.sources.camera.CameraController;
import com.github.thibaultbee.streampack.utils.CameraExtensionsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R$\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/github/thibaultbee/streampack/utils/WhiteBalance;", "", "context", "Landroid/content/Context;", "cameraController", "Lcom/github/thibaultbee/streampack/internal/sources/camera/CameraController;", "(Landroid/content/Context;Lcom/github/thibaultbee/streampack/internal/sources/camera/CameraController;)V", "value", "", "autoMode", "getAutoMode", "()I", "setAutoMode", "(I)V", "availableAutoModes", "", "getAvailableAutoModes", "()Ljava/util/List;", "sdk_release"})
public final class WhiteBalance {
    @NotNull
    private final Context context;
    @NotNull
    private final CameraController cameraController;

    public WhiteBalance(@NotNull Context context, @NotNull CameraController cameraController) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cameraController, (String)"cameraController");
        this.context = context;
        this.cameraController = cameraController;
    }

    @NotNull
    public final List<Integer> getAvailableAutoModes() {
        List<Integer> list;
        String string = this.cameraController.getCameraId();
        if (string == null) {
            list = null;
        } else {
            String it = string;
            boolean bl = false;
            list = CameraExtensionsKt.getAutoWhiteBalanceModes(this.context, it);
        }
        List<Integer> list2 = list;
        return list2 == null ? CollectionsKt.emptyList() : list2;
    }

    public final int getAutoMode() {
        Integer n = (Integer)this.cameraController.getSetting(CaptureRequest.CONTROL_AWB_MODE);
        return n == null ? 0 : n;
    }

    public final void setAutoMode(int value) {
        CaptureRequest.Key key = CaptureRequest.CONTROL_AWB_MODE;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"CONTROL_AWB_MODE");
        this.cameraController.setSetting(key, value);
    }
}

