/*
 * Decompiled with CFR 0.152.
 */
package com.github.thibaultbee.streampack.streamers.bases;

import android.content.Context;
import android.view.Surface;
import androidx.annotation.RequiresPermission;
import com.github.thibaultbee.streampack.data.AudioConfig;
import com.github.thibaultbee.streampack.data.VideoConfig;
import com.github.thibaultbee.streampack.error.StreamPackError;
import com.github.thibaultbee.streampack.internal.data.Frame;
import com.github.thibaultbee.streampack.internal.data.Packet;
import com.github.thibaultbee.streampack.internal.encoders.AudioMediaCodecEncoder;
import com.github.thibaultbee.streampack.internal.encoders.IEncoderListener;
import com.github.thibaultbee.streampack.internal.encoders.VideoMediaCodecEncoder;
import com.github.thibaultbee.streampack.internal.endpoints.IEndpoint;
import com.github.thibaultbee.streampack.internal.events.EventHandler;
import com.github.thibaultbee.streampack.internal.muxers.IMuxerListener;
import com.github.thibaultbee.streampack.internal.muxers.ts.TSMuxer;
import com.github.thibaultbee.streampack.internal.muxers.ts.data.ServiceInfo;
import com.github.thibaultbee.streampack.internal.sources.IAudioCapture;
import com.github.thibaultbee.streampack.internal.sources.ISurfaceCapture;
import com.github.thibaultbee.streampack.listeners.OnErrorListener;
import com.github.thibaultbee.streampack.logger.ILogger;
import com.github.thibaultbee.streampack.streamers.bases.BaseStreamer;
import com.github.thibaultbee.streampack.streamers.interfaces.IStreamer;
import com.github.thibaultbee.streampack.streamers.interfaces.settings.IAudioSettings;
import com.github.thibaultbee.streampack.streamers.interfaces.settings.IBaseStreamerSettings;
import com.github.thibaultbee.streampack.streamers.interfaces.settings.IVideoSettings;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0093\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b*\u0003\u001a$B\b&\u0018\u00002\u00020\u00012\u00020\u0002:\u0001PBG\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u001c\u0010E\u001a\u00020F2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u00106\u001a\u0004\u0018\u00010\tH\u0017J\u0010\u0010G\u001a\u00020F2\u0006\u0010H\u001a\u00020IH\u0002J\b\u0010J\u001a\u00020FH\u0016J\b\u0010K\u001a\u00020FH\u0002J\b\u0010L\u001a\u00020FH\u0002J\b\u0010M\u001a\u00020FH\u0016J\b\u0010N\u001a\u00020FH\u0016J\b\u0010O\u001a\u00020FH\u0004R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010\u0010\u001a\u00020\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0010\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010%R\u001c\u0010&\u001a\u0004\u0018\u00010'X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u0014\u0010,\u001a\u00020'X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010)R\u0018\u0010.\u001a\u00060/R\u00020\u0000X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u000e\u00102\u001a\u000203X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u001c\u00106\u001a\u0004\u0018\u00010\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u001c\u0010;\u001a\u0004\u0018\u00010<X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u0010\u0010A\u001a\u00020BX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010CR\u0012\u0010D\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001e\u00a8\u0006Q"}, d2={"Lcom/github/thibaultbee/streampack/streamers/bases/BaseStreamer;", "Lcom/github/thibaultbee/streampack/internal/events/EventHandler;", "Lcom/github/thibaultbee/streampack/streamers/interfaces/IStreamer;", "context", "Landroid/content/Context;", "tsServiceInfo", "Lcom/github/thibaultbee/streampack/internal/muxers/ts/data/ServiceInfo;", "videoCapture", "Lcom/github/thibaultbee/streampack/internal/sources/ISurfaceCapture;", "Lcom/github/thibaultbee/streampack/data/VideoConfig;", "audioCapture", "Lcom/github/thibaultbee/streampack/internal/sources/IAudioCapture;", "manageVideoOrientation", "", "endpoint", "Lcom/github/thibaultbee/streampack/internal/endpoints/IEndpoint;", "logger", "Lcom/github/thibaultbee/streampack/logger/ILogger;", "(Landroid/content/Context;Lcom/github/thibaultbee/streampack/internal/muxers/ts/data/ServiceInfo;Lcom/github/thibaultbee/streampack/internal/sources/ISurfaceCapture;Lcom/github/thibaultbee/streampack/internal/sources/IAudioCapture;ZLcom/github/thibaultbee/streampack/internal/endpoints/IEndpoint;Lcom/github/thibaultbee/streampack/logger/ILogger;)V", "getAudioCapture", "()Lcom/github/thibaultbee/streampack/internal/sources/IAudioCapture;", "audioConfig", "Lcom/github/thibaultbee/streampack/data/AudioConfig;", "audioEncoder", "Lcom/github/thibaultbee/streampack/internal/encoders/AudioMediaCodecEncoder;", "audioEncoderListener", "com/github/thibaultbee/streampack/streamers/bases/BaseStreamer$audioEncoderListener$1", "Lcom/github/thibaultbee/streampack/streamers/bases/BaseStreamer$audioEncoderListener$1;", "audioTsStreamId", "", "Ljava/lang/Short;", "getEndpoint", "()Lcom/github/thibaultbee/streampack/internal/endpoints/IEndpoint;", "getLogger", "()Lcom/github/thibaultbee/streampack/logger/ILogger;", "muxListener", "com/github/thibaultbee/streampack/streamers/bases/BaseStreamer$muxListener$1", "Lcom/github/thibaultbee/streampack/streamers/bases/BaseStreamer$muxListener$1;", "onErrorListener", "Lcom/github/thibaultbee/streampack/listeners/OnErrorListener;", "getOnErrorListener", "()Lcom/github/thibaultbee/streampack/listeners/OnErrorListener;", "setOnErrorListener", "(Lcom/github/thibaultbee/streampack/listeners/OnErrorListener;)V", "onInternalErrorListener", "getOnInternalErrorListener", "settings", "Lcom/github/thibaultbee/streampack/streamers/bases/BaseStreamer$Settings;", "getSettings", "()Lcom/github/thibaultbee/streampack/streamers/bases/BaseStreamer$Settings;", "tsMux", "Lcom/github/thibaultbee/streampack/internal/muxers/ts/TSMuxer;", "getVideoCapture", "()Lcom/github/thibaultbee/streampack/internal/sources/ISurfaceCapture;", "videoConfig", "getVideoConfig", "()Lcom/github/thibaultbee/streampack/data/VideoConfig;", "setVideoConfig", "(Lcom/github/thibaultbee/streampack/data/VideoConfig;)V", "videoEncoder", "Lcom/github/thibaultbee/streampack/internal/encoders/VideoMediaCodecEncoder;", "getVideoEncoder", "()Lcom/github/thibaultbee/streampack/internal/encoders/VideoMediaCodecEncoder;", "setVideoEncoder", "(Lcom/github/thibaultbee/streampack/internal/encoders/VideoMediaCodecEncoder;)V", "videoEncoderListener", "com/github/thibaultbee/streampack/streamers/bases/BaseStreamer$videoEncoderListener$1", "Lcom/github/thibaultbee/streampack/streamers/bases/BaseStreamer$videoEncoderListener$1;", "videoTsStreamId", "configure", "", "onStreamError", "error", "Lcom/github/thibaultbee/streampack/error/StreamPackError;", "release", "resetAudio", "resetVideo", "startStream", "stopStream", "stopStreamImpl", "Settings", "sdk_release"})
public abstract class BaseStreamer
extends EventHandler
implements IStreamer {
    @NotNull
    private final Context context;
    @NotNull
    private final ServiceInfo tsServiceInfo;
    @Nullable
    private final ISurfaceCapture<VideoConfig> videoCapture;
    @Nullable
    private final IAudioCapture audioCapture;
    @NotNull
    private final IEndpoint endpoint;
    @NotNull
    private final ILogger logger;
    @Nullable
    private OnErrorListener onErrorListener;
    @NotNull
    private final Settings settings;
    @Nullable
    private Short audioTsStreamId;
    @Nullable
    private Short videoTsStreamId;
    @Nullable
    private VideoConfig videoConfig;
    @Nullable
    private AudioConfig audioConfig;
    @NotNull
    private final OnErrorListener onInternalErrorListener;
    @NotNull
    private final audioEncoderListener.1 audioEncoderListener;
    @NotNull
    private final videoEncoderListener.1 videoEncoderListener;
    @NotNull
    private final muxListener.1 muxListener;
    @Nullable
    private AudioMediaCodecEncoder audioEncoder;
    @Nullable
    private VideoMediaCodecEncoder videoEncoder;
    @NotNull
    private final TSMuxer tsMux;

    public BaseStreamer(@NotNull Context context, @NotNull ServiceInfo tsServiceInfo, @Nullable ISurfaceCapture<VideoConfig> videoCapture, @Nullable IAudioCapture audioCapture, boolean manageVideoOrientation, @NotNull IEndpoint endpoint, @NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)tsServiceInfo, (String)"tsServiceInfo");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.context = context;
        this.tsServiceInfo = tsServiceInfo;
        this.videoCapture = videoCapture;
        this.audioCapture = audioCapture;
        this.endpoint = endpoint;
        this.logger = logger;
        this.settings = new Settings();
        this.onInternalErrorListener = new OnErrorListener(this){
            final /* synthetic */ BaseStreamer this$0;
            {
                this.this$0 = $receiver;
            }

            public void onError(@NotNull StreamPackError error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                BaseStreamer.access$onStreamError(this.this$0, error);
            }
        };
        this.audioEncoderListener = new IEncoderListener(this){
            final /* synthetic */ BaseStreamer this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public Frame onInputFrame(@NotNull ByteBuffer buffer) {
                Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
                IAudioCapture iAudioCapture = this.this$0.getAudioCapture();
                Intrinsics.checkNotNull((Object)iAudioCapture);
                return iAudioCapture.getFrame(buffer);
            }

            public void onOutputFrame(@NotNull Frame frame) {
                Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
                Short s = BaseStreamer.access$getAudioTsStreamId$p(this.this$0);
                if (s != null) {
                    Short s2 = s;
                    BaseStreamer baseStreamer = this.this$0;
                    short it = ((Number)s2).shortValue();
                    boolean bl = false;
                    try {
                        BaseStreamer.access$getTsMux$p(baseStreamer).encode(frame, it);
                    }
                    catch (Exception e) {
                        throw new StreamPackError(e);
                    }
                }
            }
        };
        this.videoEncoderListener = new IEncoderListener(this){
            final /* synthetic */ BaseStreamer this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public Frame onInputFrame(@NotNull ByteBuffer buffer) {
                Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
                throw new StreamPackError(new RuntimeException("No video input on VideoEncoder"));
            }

            public void onOutputFrame(@NotNull Frame frame) {
                Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
                Short s = BaseStreamer.access$getVideoTsStreamId$p(this.this$0);
                if (s != null) {
                    Short s2 = s;
                    BaseStreamer baseStreamer = this.this$0;
                    short it = ((Number)s2).shortValue();
                    boolean bl = false;
                    try {
                        Long l;
                        long l2 = frame.getPts();
                        ISurfaceCapture<VideoConfig> iSurfaceCapture = baseStreamer.getVideoCapture();
                        Intrinsics.checkNotNull(iSurfaceCapture);
                        frame.setPts(l2 + iSurfaceCapture.getTimestampOffset());
                        if (frame.getDts() != null) {
                            Long l3 = frame.getDts();
                            Intrinsics.checkNotNull((Object)l3);
                            l = l3 + baseStreamer.getVideoCapture().getTimestampOffset();
                        } else {
                            l = null;
                        }
                        frame.setDts(l);
                        BaseStreamer.access$getTsMux$p(baseStreamer).encode(frame, it);
                    }
                    catch (Exception e) {
                        throw new StreamPackError(e);
                    }
                }
            }
        };
        this.muxListener = new IMuxerListener(this){
            final /* synthetic */ BaseStreamer this$0;
            {
                this.this$0 = $receiver;
            }

            public void onOutputFrame(@NotNull Packet packet) {
                Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
                try {
                    this.this$0.getEndpoint().write(packet);
                }
                catch (Exception e) {
                    throw new StreamPackError(e);
                }
            }
        };
        this.audioEncoder = this.audioCapture != null ? new AudioMediaCodecEncoder(this.audioEncoderListener, this.onInternalErrorListener, this.logger) : (AudioMediaCodecEncoder)null;
        this.videoEncoder = this.videoCapture != null ? new VideoMediaCodecEncoder(this.videoEncoderListener, this.onInternalErrorListener, this.context, manageVideoOrientation, this.logger) : (VideoMediaCodecEncoder)null;
        this.tsMux = new TSMuxer(this.muxListener, null, null, 6, null);
    }

    @Nullable
    protected final ISurfaceCapture<VideoConfig> getVideoCapture() {
        return this.videoCapture;
    }

    @Nullable
    protected final IAudioCapture getAudioCapture() {
        return this.audioCapture;
    }

    @NotNull
    protected final IEndpoint getEndpoint() {
        return this.endpoint;
    }

    @NotNull
    protected final ILogger getLogger() {
        return this.logger;
    }

    @Override
    @Nullable
    public OnErrorListener getOnErrorListener() {
        return this.onErrorListener;
    }

    @Override
    public void setOnErrorListener(@Nullable OnErrorListener onErrorListener) {
        this.onErrorListener = onErrorListener;
    }

    @Override
    @NotNull
    public Settings getSettings() {
        return this.settings;
    }

    @Nullable
    protected final VideoConfig getVideoConfig() {
        return this.videoConfig;
    }

    protected final void setVideoConfig(@Nullable VideoConfig videoConfig) {
        this.videoConfig = videoConfig;
    }

    @Override
    @NotNull
    protected final OnErrorListener getOnInternalErrorListener() {
        return this.onInternalErrorListener;
    }

    private final void onStreamError(StreamPackError error) {
        try {
            this.stopStream();
            OnErrorListener onErrorListener = this.getOnErrorListener();
            if (onErrorListener != null) {
                onErrorListener.onError(error);
            }
        }
        catch (Exception e) {
            ILogger.DefaultImpls.e$default(this.logger, this, "onStreamError: Can't stop stream", null, 4, null);
        }
    }

    @Nullable
    protected final VideoMediaCodecEncoder getVideoEncoder() {
        return this.videoEncoder;
    }

    protected final void setVideoEncoder(@Nullable VideoMediaCodecEncoder videoMediaCodecEncoder) {
        this.videoEncoder = videoMediaCodecEncoder;
    }

    @Override
    @RequiresPermission(value="android.permission.RECORD_AUDIO")
    public void configure(@Nullable AudioConfig audioConfig, @Nullable VideoConfig videoConfig) {
        this.videoConfig = videoConfig;
        this.audioConfig = audioConfig;
        try {
            int n;
            Object it;
            AudioConfig audioConfig2 = audioConfig;
            if (audioConfig2 != null) {
                it = audioConfig2;
                boolean bl = false;
                IAudioCapture iAudioCapture = this.getAudioCapture();
                if (iAudioCapture != null) {
                    iAudioCapture.configure(it);
                }
                AudioMediaCodecEncoder audioMediaCodecEncoder = this.audioEncoder;
                if (audioMediaCodecEncoder != null) {
                    audioMediaCodecEncoder.configure((AudioConfig)it);
                }
            }
            VideoConfig videoConfig2 = videoConfig;
            if (videoConfig2 != null) {
                it = videoConfig2;
                boolean bl = false;
                ISurfaceCapture<VideoConfig> iSurfaceCapture = this.getVideoCapture();
                if (iSurfaceCapture != null) {
                    iSurfaceCapture.configure((VideoConfig)it);
                }
                VideoMediaCodecEncoder videoMediaCodecEncoder = this.getVideoEncoder();
                if (videoMediaCodecEncoder != null) {
                    videoMediaCodecEncoder.configure((VideoConfig)it);
                }
            }
            VideoConfig videoConfig3 = videoConfig;
            AudioConfig audioConfig3 = audioConfig;
            this.endpoint.configure((videoConfig3 == null ? 0 : (n = videoConfig3.getStartBitrate())) + (audioConfig3 == null ? 0 : (n = audioConfig3.getStartBitrate())));
        }
        catch (Exception e) {
            this.release();
            throw new StreamPackError(e);
        }
    }

    @Override
    public void startStream() {
        try {
            String it;
            this.endpoint.startStream();
            List streams = new ArrayList();
            VideoMediaCodecEncoder videoMediaCodecEncoder = this.videoEncoder;
            if (videoMediaCodecEncoder != null) {
                String string = videoMediaCodecEncoder.getMimeType();
                if (string != null) {
                    it = string;
                    boolean bl = false;
                    streams.add(it);
                }
            }
            AudioMediaCodecEncoder audioMediaCodecEncoder = this.audioEncoder;
            if (audioMediaCodecEncoder != null) {
                String string = audioMediaCodecEncoder.getMimeType();
                if (string != null) {
                    it = string;
                    boolean bl = false;
                    streams.add(it);
                }
            }
            this.tsMux.addService(this.tsServiceInfo);
            this.tsMux.addStreams(this.tsServiceInfo, (List<String>)streams);
            VideoMediaCodecEncoder videoMediaCodecEncoder2 = this.videoEncoder;
            if (videoMediaCodecEncoder2 != null) {
                String string = videoMediaCodecEncoder2.getMimeType();
                if (string != null) {
                    it = string;
                    boolean bl = false;
                    this.videoTsStreamId = this.tsMux.getStreams(it).get(0).getPid();
                }
            }
            AudioMediaCodecEncoder audioMediaCodecEncoder2 = this.audioEncoder;
            if (audioMediaCodecEncoder2 != null) {
                String string = audioMediaCodecEncoder2.getMimeType();
                if (string != null) {
                    it = string;
                    boolean bl = false;
                    this.audioTsStreamId = this.tsMux.getStreams(it).get(0).getPid();
                }
            }
            IAudioCapture iAudioCapture = this.audioCapture;
            if (iAudioCapture != null) {
                iAudioCapture.startStream();
            }
            AudioMediaCodecEncoder audioMediaCodecEncoder3 = this.audioEncoder;
            if (audioMediaCodecEncoder3 != null) {
                audioMediaCodecEncoder3.startStream();
            }
            ISurfaceCapture<VideoConfig> iSurfaceCapture = this.videoCapture;
            if (iSurfaceCapture != null) {
                iSurfaceCapture.startStream();
            }
            VideoMediaCodecEncoder videoMediaCodecEncoder3 = this.videoEncoder;
            if (videoMediaCodecEncoder3 != null) {
                videoMediaCodecEncoder3.startStream();
            }
        }
        catch (Exception e) {
            this.stopStream();
            throw new StreamPackError(e);
        }
    }

    @Override
    public void stopStream() {
        this.stopStreamImpl();
        this.resetAudio();
        this.resetVideo();
    }

    protected final void stopStreamImpl() {
        ISurfaceCapture<VideoConfig> iSurfaceCapture = this.videoCapture;
        if (iSurfaceCapture != null) {
            iSurfaceCapture.stopStream();
        }
        VideoMediaCodecEncoder videoMediaCodecEncoder = this.videoEncoder;
        if (videoMediaCodecEncoder != null) {
            videoMediaCodecEncoder.stopStream();
        }
        AudioMediaCodecEncoder audioMediaCodecEncoder = this.audioEncoder;
        if (audioMediaCodecEncoder != null) {
            audioMediaCodecEncoder.stopStream();
        }
        IAudioCapture iAudioCapture = this.audioCapture;
        if (iAudioCapture != null) {
            iAudioCapture.stopStream();
        }
        this.tsMux.stop();
        this.endpoint.stopStream();
    }

    private final void resetAudio() {
        AudioMediaCodecEncoder audioMediaCodecEncoder = this.audioEncoder;
        if (audioMediaCodecEncoder != null) {
            audioMediaCodecEncoder.release();
        }
        AudioConfig audioConfig = this.audioConfig;
        if (audioConfig != null) {
            AudioConfig it = audioConfig;
            boolean bl = false;
            AudioMediaCodecEncoder audioMediaCodecEncoder2 = this.audioEncoder;
            if (audioMediaCodecEncoder2 != null) {
                audioMediaCodecEncoder2.configure(it);
            }
        }
    }

    private final void resetVideo() {
        VideoMediaCodecEncoder videoMediaCodecEncoder = this.videoEncoder;
        if (videoMediaCodecEncoder != null) {
            videoMediaCodecEncoder.release();
        }
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ BaseStreamer this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        VideoConfig videoConfig = this.this$0.getVideoConfig();
                        if (videoConfig != null) {
                            VideoConfig videoConfig2 = videoConfig;
                            BaseStreamer baseStreamer = this.this$0;
                            VideoConfig it = videoConfig2;
                            boolean bl = false;
                            VideoMediaCodecEncoder videoMediaCodecEncoder = baseStreamer.getVideoEncoder();
                            if (videoMediaCodecEncoder != null) {
                                videoMediaCodecEncoder.configure(it);
                            }
                        }
                        ISurfaceCapture<VideoConfig> iSurfaceCapture = this.this$0.getVideoCapture();
                        if (iSurfaceCapture != null) {
                            VideoMediaCodecEncoder videoMediaCodecEncoder = this.this$0.getVideoEncoder();
                            iSurfaceCapture.setEncoderSurface((Surface)(videoMediaCodecEncoder == null ? null : videoMediaCodecEncoder.getInputSurface()));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    @Override
    public void release() {
        AudioMediaCodecEncoder audioMediaCodecEncoder = this.audioEncoder;
        if (audioMediaCodecEncoder != null) {
            audioMediaCodecEncoder.release();
        }
        VideoMediaCodecEncoder videoMediaCodecEncoder = this.videoEncoder;
        if (videoMediaCodecEncoder != null) {
            VideoMediaCodecEncoder.CodecSurface codecSurface = videoMediaCodecEncoder.getCodecSurface();
            if (codecSurface != null) {
                codecSurface.dispose();
            }
        }
        VideoMediaCodecEncoder videoMediaCodecEncoder2 = this.videoEncoder;
        if (videoMediaCodecEncoder2 != null) {
            videoMediaCodecEncoder2.release();
        }
        IAudioCapture iAudioCapture = this.audioCapture;
        if (iAudioCapture != null) {
            iAudioCapture.release();
        }
        ISurfaceCapture<VideoConfig> iSurfaceCapture = this.videoCapture;
        if (iSurfaceCapture != null) {
            iSurfaceCapture.release();
        }
        this.endpoint.release();
    }

    public static final /* synthetic */ void access$onStreamError(BaseStreamer $this, StreamPackError error) {
        $this.onStreamError(error);
    }

    public static final /* synthetic */ Short access$getAudioTsStreamId$p(BaseStreamer $this) {
        return $this.audioTsStreamId;
    }

    public static final /* synthetic */ TSMuxer access$getTsMux$p(BaseStreamer $this) {
        return $this.tsMux;
    }

    public static final /* synthetic */ Short access$getVideoTsStreamId$p(BaseStreamer $this) {
        return $this.videoTsStreamId;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0096\u0004\u0018\u00002\u00020\u0001:\u0002\f\rB\u0005\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\n0\u0004R\u00060\u0000R\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\n0\tR\u00060\u0000R\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/github/thibaultbee/streampack/streamers/bases/BaseStreamer$Settings;", "Lcom/github/thibaultbee/streampack/streamers/interfaces/settings/IBaseStreamerSettings;", "(Lcom/github/thibaultbee/streampack/streamers/bases/BaseStreamer;)V", "audio", "Lcom/github/thibaultbee/streampack/streamers/bases/BaseStreamer$Settings$Audio;", "Lcom/github/thibaultbee/streampack/streamers/bases/BaseStreamer;", "getAudio", "()Lcom/github/thibaultbee/streampack/streamers/bases/BaseStreamer$Settings$Audio;", "video", "Lcom/github/thibaultbee/streampack/streamers/bases/BaseStreamer$Settings$Video;", "getVideo", "()Lcom/github/thibaultbee/streampack/streamers/bases/BaseStreamer$Settings$Video;", "Audio", "Video", "sdk_release"})
    public class Settings
    implements IBaseStreamerSettings {
        @NotNull
        private final Video video;
        @NotNull
        private final Audio audio;

        public Settings() {
            Intrinsics.checkNotNullParameter((Object)BaseStreamer.this, (String)"this$0");
            this.video = new Video();
            this.audio = new Audio();
        }

        @Override
        @NotNull
        public Video getVideo() {
            return this.video;
        }

        @Override
        @NotNull
        public Audio getAudio() {
            return this.audio;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/github/thibaultbee/streampack/streamers/bases/BaseStreamer$Settings$Video;", "Lcom/github/thibaultbee/streampack/streamers/interfaces/settings/IVideoSettings;", "(Lcom/github/thibaultbee/streampack/streamers/bases/BaseStreamer$Settings;)V", "value", "", "bitrate", "getBitrate", "()I", "setBitrate", "(I)V", "sdk_release"})
        public final class Video
        implements IVideoSettings {
            public Video() {
                Intrinsics.checkNotNullParameter((Object)Settings.this, (String)"this$0");
            }

            @Override
            public int getBitrate() {
                int n;
                VideoMediaCodecEncoder videoMediaCodecEncoder = BaseStreamer.this.getVideoEncoder();
                return videoMediaCodecEncoder == null ? 0 : (n = videoMediaCodecEncoder.getBitrate());
            }

            @Override
            public void setBitrate(int value) {
                VideoMediaCodecEncoder videoMediaCodecEncoder = BaseStreamer.this.getVideoEncoder();
                if (videoMediaCodecEncoder != null) {
                    VideoMediaCodecEncoder it = videoMediaCodecEncoder;
                    boolean bl = false;
                    it.setBitrate(value);
                }
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR$\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\n8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/github/thibaultbee/streampack/streamers/bases/BaseStreamer$Settings$Audio;", "Lcom/github/thibaultbee/streampack/streamers/interfaces/settings/IAudioSettings;", "(Lcom/github/thibaultbee/streampack/streamers/bases/BaseStreamer$Settings;)V", "value", "", "bitrate", "getBitrate", "()I", "setBitrate", "(I)V", "", "isMuted", "()Z", "setMuted", "(Z)V", "sdk_release"})
        public final class Audio
        implements IAudioSettings {
            public Audio() {
                Intrinsics.checkNotNullParameter((Object)Settings.this, (String)"this$0");
            }

            @Override
            public int getBitrate() {
                int n;
                AudioMediaCodecEncoder audioMediaCodecEncoder = BaseStreamer.this.audioEncoder;
                return audioMediaCodecEncoder == null ? 0 : (n = audioMediaCodecEncoder.getBitrate());
            }

            @Override
            public void setBitrate(int value) {
                AudioMediaCodecEncoder audioMediaCodecEncoder = BaseStreamer.this.audioEncoder;
                if (audioMediaCodecEncoder != null) {
                    AudioMediaCodecEncoder it = audioMediaCodecEncoder;
                    boolean bl = false;
                    it.setBitrate(value);
                }
            }

            @Override
            public boolean isMuted() {
                boolean bl;
                IAudioCapture iAudioCapture = BaseStreamer.this.getAudioCapture();
                return iAudioCapture == null ? true : (bl = iAudioCapture.isMuted());
            }

            @Override
            public void setMuted(boolean value) {
                IAudioCapture iAudioCapture = BaseStreamer.this.getAudioCapture();
                if (iAudioCapture != null) {
                    iAudioCapture.setMuted(value);
                }
            }
        }
    }
}

