/*
 * Decompiled with CFR 0.152.
 */
package com.github.thibaultbee.streampack.streamers.bases;

import android.content.Context;
import android.view.Surface;
import androidx.annotation.RequiresPermission;
import com.github.thibaultbee.streampack.data.VideoConfig;
import com.github.thibaultbee.streampack.error.StreamPackError;
import com.github.thibaultbee.streampack.internal.encoders.VideoMediaCodecEncoder;
import com.github.thibaultbee.streampack.internal.endpoints.IEndpoint;
import com.github.thibaultbee.streampack.internal.muxers.ts.data.ServiceInfo;
import com.github.thibaultbee.streampack.internal.sources.AudioCapture;
import com.github.thibaultbee.streampack.internal.sources.ISurfaceCapture;
import com.github.thibaultbee.streampack.internal.sources.camera.CameraCapture;
import com.github.thibaultbee.streampack.logger.ILogger;
import com.github.thibaultbee.streampack.streamers.bases.BaseStreamer;
import com.github.thibaultbee.streampack.streamers.interfaces.ICameraStreamer;
import com.github.thibaultbee.streampack.streamers.interfaces.settings.IBaseCameraStreamerSettings;
import com.github.thibaultbee.streampack.utils.CameraSettings;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002:\u0001$B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u000fH\u0017J\b\u0010#\u001a\u00020\u001eH\u0016R$\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f8V@WX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u00060\u0018R\u00020\u0000X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006%"}, d2={"Lcom/github/thibaultbee/streampack/streamers/bases/BaseCameraStreamer;", "Lcom/github/thibaultbee/streampack/streamers/bases/BaseStreamer;", "Lcom/github/thibaultbee/streampack/streamers/interfaces/ICameraStreamer;", "context", "Landroid/content/Context;", "tsServiceInfo", "Lcom/github/thibaultbee/streampack/internal/muxers/ts/data/ServiceInfo;", "endpoint", "Lcom/github/thibaultbee/streampack/internal/endpoints/IEndpoint;", "logger", "Lcom/github/thibaultbee/streampack/logger/ILogger;", "enableAudio", "", "(Landroid/content/Context;Lcom/github/thibaultbee/streampack/internal/muxers/ts/data/ServiceInfo;Lcom/github/thibaultbee/streampack/internal/endpoints/IEndpoint;Lcom/github/thibaultbee/streampack/logger/ILogger;Z)V", "value", "", "camera", "getCamera", "()Ljava/lang/String;", "setCamera", "(Ljava/lang/String;)V", "cameraCapture", "Lcom/github/thibaultbee/streampack/internal/sources/camera/CameraCapture;", "settings", "Lcom/github/thibaultbee/streampack/streamers/bases/BaseCameraStreamer$Settings;", "getSettings", "()Lcom/github/thibaultbee/streampack/streamers/bases/BaseCameraStreamer$Settings;", "setSettings", "(Lcom/github/thibaultbee/streampack/streamers/bases/BaseCameraStreamer$Settings;)V", "release", "", "startPreview", "previewSurface", "Landroid/view/Surface;", "cameraId", "stopPreview", "Settings", "sdk_release"})
public class BaseCameraStreamer
extends BaseStreamer
implements ICameraStreamer {
    @NotNull
    private final Context context;
    @NotNull
    private final CameraCapture cameraCapture;
    @NotNull
    private Settings settings;

    public BaseCameraStreamer(@NotNull Context context, @NotNull ServiceInfo tsServiceInfo, @NotNull IEndpoint endpoint, @NotNull ILogger logger, boolean enableAudio) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)tsServiceInfo, (String)"tsServiceInfo");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        super(context, tsServiceInfo, new CameraCapture(context, logger), enableAudio ? new AudioCapture(logger) : null, true, endpoint, logger);
        this.context = context;
        ISurfaceCapture<VideoConfig> iSurfaceCapture = this.getVideoCapture();
        if (iSurfaceCapture == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.github.thibaultbee.streampack.internal.sources.camera.CameraCapture");
        }
        this.cameraCapture = (CameraCapture)iSurfaceCapture;
        this.settings = new Settings();
    }

    @Override
    @NotNull
    public String getCamera() {
        return this.cameraCapture.getCameraId();
    }

    @Override
    @RequiresPermission(value="android.permission.CAMERA")
    public void setCamera(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.cameraCapture.setCameraId(value);
    }

    @Override
    @NotNull
    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"<set-?>");
        this.settings = settings;
    }

    @Override
    @RequiresPermission(allOf={"android.permission.CAMERA"})
    public void startPreview(@NotNull Surface previewSurface, @NotNull String cameraId2) {
        Intrinsics.checkNotNullParameter((Object)previewSurface, (String)"previewSurface");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        if (!(this.getVideoConfig() != null)) {
            boolean bl = false;
            String string = "Video has not been configured!";
            throw new IllegalArgumentException(string.toString());
        }
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, previewSurface, cameraId2, null){
            int label;
            final /* synthetic */ BaseCameraStreamer this$0;
            final /* synthetic */ Surface $previewSurface;
            final /* synthetic */ String $cameraId;
            {
                this.this$0 = $receiver;
                this.$previewSurface = $previewSurface;
                this.$cameraId = $cameraId;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        BaseCameraStreamer.access$getCameraCapture$p(this.this$0).setPreviewSurface(this.$previewSurface);
                        VideoMediaCodecEncoder videoMediaCodecEncoder = this.this$0.getVideoEncoder();
                        BaseCameraStreamer.access$getCameraCapture$p(this.this$0).setEncoderSurface((Surface)(videoMediaCodecEncoder == null ? null : videoMediaCodecEncoder.getInputSurface()));
                        this.label = 1;
                        Object object3 = CameraCapture.startPreview$default(BaseCameraStreamer.access$getCameraCapture$p(this.this$0), this.$cameraId, false, (Continuation)this, 2, null);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        Object object3;
                        try {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            object3 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (Exception e) {
                            this.this$0.stopPreview();
                            throw new StreamPackError(e);
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    @Override
    public void stopPreview() {
        this.stopStreamImpl();
        this.cameraCapture.stopPreview();
    }

    @Override
    public void release() {
        this.stopPreview();
        super.release();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/github/thibaultbee/streampack/streamers/bases/BaseCameraStreamer$Settings;", "Lcom/github/thibaultbee/streampack/streamers/bases/BaseStreamer$Settings;", "Lcom/github/thibaultbee/streampack/streamers/bases/BaseStreamer;", "Lcom/github/thibaultbee/streampack/streamers/interfaces/settings/IBaseCameraStreamerSettings;", "(Lcom/github/thibaultbee/streampack/streamers/bases/BaseCameraStreamer;)V", "camera", "Lcom/github/thibaultbee/streampack/utils/CameraSettings;", "getCamera", "()Lcom/github/thibaultbee/streampack/utils/CameraSettings;", "sdk_release"})
    public final class Settings
    extends BaseStreamer.Settings
    implements IBaseCameraStreamerSettings {
        public Settings() {
            Intrinsics.checkNotNullParameter((Object)BaseCameraStreamer.this, (String)"this$0");
            super(BaseCameraStreamer.this);
        }

        @Override
        @NotNull
        public CameraSettings getCamera() {
            return BaseCameraStreamer.this.cameraCapture.getSettings();
        }
    }
}

