/*
 * Decompiled with CFR 0.152.
 */
package com.github.thibaultbee.streampack.internal.utils;

import android.content.Context;
import android.hardware.display.DisplayManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0005\u001a\n\u0010\u0006\u001a\u00020\u0004*\u00020\u0002\u001a\n\u0010\u0007\u001a\u00020\u0004*\u00020\u0005\u00a8\u0006\b"}, d2={"getOrientation", "", "Landroid/content/Context;", "isAudio", "", "", "isPortrait", "isVideo", "sdk_release"})
public final class AVExtensionsKt {
    public static final boolean isVideo(@NotNull String $this$isVideo) {
        Intrinsics.checkNotNullParameter((Object)$this$isVideo, (String)"<this>");
        return StringsKt.startsWith$default((String)$this$isVideo, (String)"video", (boolean)false, (int)2, null);
    }

    public static final boolean isAudio(@NotNull String $this$isAudio) {
        Intrinsics.checkNotNullParameter((Object)$this$isAudio, (String)"<this>");
        return StringsKt.startsWith$default((String)$this$isAudio, (String)"audio", (boolean)false, (int)2, null);
    }

    public static final int getOrientation(@NotNull Context $this$getOrientation) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$getOrientation, (String)"<this>");
        Object object = $this$getOrientation.getSystemService("display");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.hardware.display.DisplayManager");
        }
        DisplayManager displayManager = (DisplayManager)object;
        int displayRotation = displayManager.getDisplay(0).getRotation();
        switch (displayRotation) {
            case 0: {
                n = 90;
                break;
            }
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 270;
                break;
            }
            case 3: {
                n = 180;
                break;
            }
            default: {
                throw new UnsupportedOperationException(Intrinsics.stringPlus((String)"Unsupported display rotation: ", (Object)displayRotation));
            }
        }
        return n;
    }

    public static final boolean isPortrait(@NotNull Context $this$isPortrait) {
        Intrinsics.checkNotNullParameter((Object)$this$isPortrait, (String)"<this>");
        int orientation = AVExtensionsKt.getOrientation($this$isPortrait);
        return orientation == 90 || orientation == 270;
    }
}

