/*
 * Decompiled with CFR 0.152.
 */
package com.github.thibaultbee.streampack.internal.muxers.ts.packets;

import com.github.thibaultbee.streampack.internal.data.Packet;
import com.github.thibaultbee.streampack.internal.muxers.IMuxerListener;
import com.github.thibaultbee.streampack.internal.muxers.ts.utils.ExtensionsKt;
import com.github.thibaultbee.streampack.internal.muxers.ts.utils.TSOutputCallback;
import java.nio.ByteBuffer;
import java.security.InvalidParameterException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ@\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010\u0015\u001a\u00020\u00072\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0004R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/github/thibaultbee/streampack/internal/muxers/ts/packets/TS;", "Lcom/github/thibaultbee/streampack/internal/muxers/ts/utils/TSOutputCallback;", "muxerListener", "Lcom/github/thibaultbee/streampack/internal/muxers/IMuxerListener;", "pid", "", "transportErrorIndicator", "", "transportPriority", "transportScramblingControl", "", "continuityCounter", "(Lcom/github/thibaultbee/streampack/internal/muxers/IMuxerListener;SZZBB)V", "getPid", "()S", "write", "", "payload", "Ljava/nio/ByteBuffer;", "adaptationField", "specificHeader", "stuffingForLastPacket", "timestamp", "", "Companion", "sdk_release"})
public class TS
extends TSOutputCallback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final short pid;
    private final boolean transportErrorIndicator;
    private final boolean transportPriority;
    private final byte transportScramblingControl;
    private byte continuityCounter;
    public static final byte SYNC_BYTE = 71;
    public static final int PACKET_SIZE = 188;

    public TS(@NotNull IMuxerListener muxerListener, short pid, boolean transportErrorIndicator, boolean transportPriority, byte transportScramblingControl, byte continuityCounter) {
        Intrinsics.checkNotNullParameter((Object)muxerListener, (String)"muxerListener");
        super(muxerListener);
        this.pid = pid;
        this.transportErrorIndicator = transportErrorIndicator;
        this.transportPriority = transportPriority;
        this.transportScramblingControl = transportScramblingControl;
        this.continuityCounter = continuityCounter;
    }

    public /* synthetic */ TS(IMuxerListener iMuxerListener, short s, boolean bl, boolean bl2, byte by, byte by2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        if ((n & 0x10) != 0) {
            by = 0;
        }
        if ((n & 0x20) != 0) {
            by2 = 0;
        }
        this(iMuxerListener, s, bl, bl2, by, by2);
    }

    public final short getPid() {
        return this.pid;
    }

    protected final void write(@Nullable ByteBuffer payload, @Nullable ByteBuffer adaptationField, @Nullable ByteBuffer specificHeader, boolean stuffingForLastPacket, long timestamp) {
        int n;
        ByteBuffer byteBuffer = payload;
        int payloadLimit = byteBuffer == null ? 0 : (n = byteBuffer.limit());
        boolean payloadUnitStartIndicator = true;
        boolean adaptationFieldIndicator = adaptationField != null;
        boolean payloadIndicator = payload != null;
        int packetIndicator = 0;
        ByteBuffer buffer = ByteBuffer.allocateDirect(1316);
        while (true) {
            boolean isLastPacket;
            boolean bl;
            ByteBuffer it;
            int n2;
            ByteBuffer byteBuffer2 = payload;
            if (!(byteBuffer2 == null ? false : byteBuffer2.hasRemaining()) && !adaptationFieldIndicator) break;
            buffer.limit(buffer.position() + 188);
            buffer.put((byte)71);
            int n3 = 0;
            n3 = ExtensionsKt.toInt(this.transportErrorIndicator) << 7 | ExtensionsKt.toInt(payloadUnitStartIndicator) << 6 | ExtensionsKt.toInt(this.transportPriority) << 5 | this.pid >> 8;
            buffer.put((byte)n3);
            payloadUnitStartIndicator = false;
            buffer.put((byte)this.pid);
            if (adaptationFieldIndicator & payloadIndicator) {
                n2 = 48;
            } else if (adaptationFieldIndicator) {
                n2 = 32;
            } else if (payloadIndicator) {
                n2 = 16;
            } else {
                throw new InvalidParameterException("TS must have either a payload either an adaption field");
            }
            n3 = this.transportScramblingControl << 6 | this.continuityCounter & 0xF | n2;
            buffer.put((byte)n3);
            this.continuityCounter = (byte)(this.continuityCounter + 1 & 0xF);
            if (adaptationFieldIndicator) {
                ByteBuffer byteBuffer3 = adaptationField;
                Intrinsics.checkNotNull((Object)byteBuffer3);
                buffer.put(byteBuffer3);
                adaptationFieldIndicator = false;
            }
            if (specificHeader != null) {
                boolean bl2 = false;
                buffer.put(it);
            }
            if (payload != null) {
                boolean bl3 = false;
                if (stuffingForLastPacket && buffer.remaining() > it.remaining()) {
                    int headerSize = buffer.position() % 188;
                    int currentPacketFirstPosition = buffer.position() / 188 * 188;
                    n3 = buffer.get(currentPacketFirstPosition + 3);
                    buffer.position(currentPacketFirstPosition + 3);
                    buffer.put((byte)(n3 |= 0x20));
                    buffer.position(currentPacketFirstPosition + 4);
                    int stuffingLength = 188 - it.remaining() - headerSize - 1;
                    buffer.put((byte)stuffingLength);
                    if (stuffingLength >= 1) {
                        buffer.put((byte)0);
                        int n4 = 0;
                        int n5 = stuffingLength - 2;
                        if (n4 <= n5) {
                            int i;
                            do {
                                i = n4++;
                                buffer.put((byte)-1);
                            } while (i != n5);
                        }
                    }
                }
                it.limit(it.position() + RangesKt.coerceAtMost((int)buffer.remaining(), (int)it.remaining()));
                buffer.put(it);
                it.limit(payloadLimit);
            }
            while (buffer.hasRemaining()) {
                buffer.put((byte)-1);
            }
            if (payload == null) {
                bl = true;
            } else {
                ByteBuffer it2;
                boolean bl4;
                boolean bl5 = false;
                bl = isLastPacket = (bl4 = !it2.hasRemaining());
            }
            if (buffer.limit() == buffer.capacity() || isLastPacket) {
                Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"buffer");
                this.writePacket(new Packet(buffer, packetIndicator == 0, isLastPacket, timestamp));
                buffer.rewind();
            }
            int n6 = packetIndicator;
            packetIndicator = n6 + 1;
        }
    }

    public static /* synthetic */ void write$default(TS tS, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, ByteBuffer byteBuffer3, boolean bl, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: write");
        }
        if ((n & 1) != 0) {
            byteBuffer = null;
        }
        if ((n & 2) != 0) {
            byteBuffer2 = null;
        }
        if ((n & 4) != 0) {
            byteBuffer3 = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            l = 0L;
        }
        tS.write(byteBuffer, byteBuffer2, byteBuffer3, bl, l);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/github/thibaultbee/streampack/internal/muxers/ts/packets/TS$Companion;", "", "()V", "PACKET_SIZE", "", "SYNC_BYTE", "", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

