/*
 * Decompiled with CFR 0.152.
 */
package com.github.thibaultbee.streampack.internal.muxers.ts.packets;

import com.github.thibaultbee.streampack.internal.data.Frame;
import com.github.thibaultbee.streampack.internal.muxers.IMuxerListener;
import com.github.thibaultbee.streampack.internal.muxers.ts.data.Stream;
import com.github.thibaultbee.streampack.internal.muxers.ts.descriptors.AdaptationField;
import com.github.thibaultbee.streampack.internal.muxers.ts.packets.PesHeader;
import com.github.thibaultbee.streampack.internal.muxers.ts.packets.TS;
import com.github.thibaultbee.streampack.internal.utils.AVExtensionsKt;
import com.github.thibaultbee.streampack.internal.utils.TimeUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/github/thibaultbee/streampack/internal/muxers/ts/packets/Pes;", "Lcom/github/thibaultbee/streampack/internal/muxers/ts/packets/TS;", "muxerListener", "Lcom/github/thibaultbee/streampack/internal/muxers/IMuxerListener;", "stream", "Lcom/github/thibaultbee/streampack/internal/muxers/ts/data/Stream;", "hasPcr", "", "(Lcom/github/thibaultbee/streampack/internal/muxers/IMuxerListener;Lcom/github/thibaultbee/streampack/internal/muxers/ts/data/Stream;Z)V", "getStream", "()Lcom/github/thibaultbee/streampack/internal/muxers/ts/data/Stream;", "write", "", "frame", "Lcom/github/thibaultbee/streampack/internal/data/Frame;", "StreamId", "sdk_release"})
public final class Pes
extends TS {
    @NotNull
    private final Stream stream;
    private final boolean hasPcr;

    public Pes(@NotNull IMuxerListener muxerListener, @NotNull Stream stream, boolean hasPcr) {
        Intrinsics.checkNotNullParameter((Object)muxerListener, (String)"muxerListener");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        super(muxerListener, stream.getPid(), false, false, (byte)0, (byte)0, 60, null);
        this.stream = stream;
        this.hasPcr = hasPcr;
    }

    @NotNull
    public final Stream getStream() {
        return this.stream;
    }

    public final void write(@NotNull Frame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Long programClockReference = this.hasPcr ? Long.valueOf(TimeUtils.INSTANCE.currentTime()) : (Long)null;
        AdaptationField adaptationField = new AdaptationField(this.stream.getDiscontinuity(), frame.isKeyFrame(), false, programClockReference, null, null, null, null, 244, null);
        PesHeader header = new PesHeader(StreamId.Companion.fromMimeType(this.stream.getMimeType()).getValue(), (short)frame.getBuffer().remaining(), 0, false, false, false, false, frame.getPts(), frame.getDts(), null, null, null, null, null, 15996, null);
        this.write(frame.getBuffer(), adaptationField.toByteBuffer(), header.toByteBuffer(), true, frame.getPts());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\n\n\u0002\b\n\b\u0086\u0001\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\fB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\r"}, d2={"Lcom/github/thibaultbee/streampack/internal/muxers/ts/packets/Pes$StreamId;", "", "value", "", "(Ljava/lang/String;IS)V", "getValue", "()S", "PRIVATE_STREAM_1", "AUDIO_STREAM_0", "VIDEO_STREAM_0", "METADATA_STREAM", "EXTENDED_STREAM", "Companion", "sdk_release"})
    public static final class StreamId
    extends Enum<StreamId> {
        @NotNull
        public static final Companion Companion;
        private final short value;
        public static final /* enum */ StreamId PRIVATE_STREAM_1;
        public static final /* enum */ StreamId AUDIO_STREAM_0;
        public static final /* enum */ StreamId VIDEO_STREAM_0;
        public static final /* enum */ StreamId METADATA_STREAM;
        public static final /* enum */ StreamId EXTENDED_STREAM;
        private static final /* synthetic */ StreamId[] $VALUES;

        private StreamId(short value) {
            this.value = value;
        }

        public final short getValue() {
            return this.value;
        }

        public static StreamId[] values() {
            return (StreamId[])$VALUES.clone();
        }

        public static StreamId valueOf(String value) {
            return Enum.valueOf(StreamId.class, value);
        }

        static {
            PRIVATE_STREAM_1 = new StreamId(189);
            AUDIO_STREAM_0 = new StreamId(192);
            VIDEO_STREAM_0 = new StreamId(224);
            METADATA_STREAM = new StreamId(252);
            EXTENDED_STREAM = new StreamId(253);
            $VALUES = streamIdArray = new StreamId[]{StreamId.PRIVATE_STREAM_1, StreamId.AUDIO_STREAM_0, StreamId.VIDEO_STREAM_0, StreamId.METADATA_STREAM, StreamId.EXTENDED_STREAM};
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/github/thibaultbee/streampack/internal/muxers/ts/packets/Pes$StreamId$Companion;", "", "()V", "fromMimeType", "Lcom/github/thibaultbee/streampack/internal/muxers/ts/packets/Pes$StreamId;", "mimeType", "", "sdk_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final StreamId fromMimeType(@NotNull String mimeType) {
                Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
                return AVExtensionsKt.isVideo(mimeType) ? VIDEO_STREAM_0 : (AVExtensionsKt.isAudio(mimeType) ? AUDIO_STREAM_0 : METADATA_STREAM);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

