/*
 * Decompiled with CFR 0.152.
 */
package com.github.thibaultbee.streampack.internal.muxers.ts.descriptors;

import com.github.thibaultbee.streampack.internal.muxers.ts.data.ITSElement;
import com.github.thibaultbee.streampack.internal.muxers.ts.utils.ExtensionsKt;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B_\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\b\u0010\u001c\u001a\u00020\u0010H\u0002J\b\u0010\u001d\u001a\u00020\fH\u0016R\u0010\u0010\r\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u0012\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/github/thibaultbee/streampack/internal/muxers/ts/descriptors/AdaptationField;", "Lcom/github/thibaultbee/streampack/internal/muxers/ts/data/ITSElement;", "discontinuityIndicator", "", "randomAccessIndicator", "elementaryStreamPriorityIndicator", "programClockReference", "", "originalProgramClockReference", "spliceCountdown", "", "transportPrivateData", "Ljava/nio/ByteBuffer;", "adaptationFieldExtension", "(ZZZLjava/lang/Long;Ljava/lang/Long;Ljava/lang/Byte;Ljava/nio/ByteBuffer;Ljava/nio/ByteBuffer;)V", "adaptationFieldLength", "", "bitSize", "getBitSize", "()I", "Ljava/lang/Long;", "size", "getSize", "Ljava/lang/Byte;", "addClockReference", "", "buffer", "timestamp", "computeBitSize", "toByteBuffer", "sdk_release"})
public final class AdaptationField
implements ITSElement {
    private final boolean discontinuityIndicator;
    private final boolean randomAccessIndicator;
    private final boolean elementaryStreamPriorityIndicator;
    @Nullable
    private final Long programClockReference;
    @Nullable
    private final Long originalProgramClockReference;
    @Nullable
    private final Byte spliceCountdown;
    @Nullable
    private final ByteBuffer transportPrivateData;
    @Nullable
    private final ByteBuffer adaptationFieldExtension;
    private final int bitSize;
    private final int size;
    private final int adaptationFieldLength;

    public AdaptationField(boolean discontinuityIndicator, boolean randomAccessIndicator, boolean elementaryStreamPriorityIndicator, @Nullable Long programClockReference, @Nullable Long originalProgramClockReference, @Nullable Byte spliceCountdown, @Nullable ByteBuffer transportPrivateData, @Nullable ByteBuffer adaptationFieldExtension) {
        this.discontinuityIndicator = discontinuityIndicator;
        this.randomAccessIndicator = randomAccessIndicator;
        this.elementaryStreamPriorityIndicator = elementaryStreamPriorityIndicator;
        this.programClockReference = programClockReference;
        this.originalProgramClockReference = originalProgramClockReference;
        this.spliceCountdown = spliceCountdown;
        this.transportPrivateData = transportPrivateData;
        this.adaptationFieldExtension = adaptationFieldExtension;
        this.bitSize = this.computeBitSize();
        this.size = this.getBitSize() / 8;
        this.adaptationFieldLength = this.getSize() - 1;
    }

    public /* synthetic */ AdaptationField(boolean bl, boolean bl2, boolean bl3, Long l, Long l2, Byte by, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            bl3 = false;
        }
        if ((n & 8) != 0) {
            l = null;
        }
        if ((n & 0x10) != 0) {
            l2 = null;
        }
        if ((n & 0x20) != 0) {
            by = null;
        }
        if ((n & 0x40) != 0) {
            byteBuffer = null;
        }
        if ((n & 0x80) != 0) {
            byteBuffer2 = null;
        }
        this(bl, bl2, bl3, l, l2, by, byteBuffer, byteBuffer2);
    }

    @Override
    public int getBitSize() {
        return this.bitSize;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    private final int computeBitSize() {
        long it;
        int nBits = 0;
        nBits = 16;
        Long l = this.programClockReference;
        if (l != null) {
            it = ((Number)l).longValue();
            boolean bl = false;
            nBits += 48;
        }
        Long l2 = this.originalProgramClockReference;
        if (l2 != null) {
            it = ((Number)l2).longValue();
            boolean bl = false;
            nBits += 48;
        }
        Byte by = this.spliceCountdown;
        if (by != null) {
            byte it2 = ((Number)by).byteValue();
            boolean bl = false;
            nBits += 8;
        }
        ByteBuffer byteBuffer = this.transportPrivateData;
        if (byteBuffer != null) {
            ByteBuffer it3 = byteBuffer;
            boolean bl = false;
            nBits += this.transportPrivateData.remaining();
        }
        ByteBuffer byteBuffer2 = this.adaptationFieldExtension;
        if (byteBuffer2 != null) {
            ByteBuffer it4 = byteBuffer2;
            boolean bl = false;
            nBits += this.adaptationFieldExtension.remaining();
        }
        return nBits;
    }

    @Override
    @NotNull
    public ByteBuffer toByteBuffer() {
        NotImplementedError notImplementedError;
        NotImplementedError notImplementedError2;
        NotImplementedError notImplementedError3;
        long it;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        ByteBuffer byteBuffer;
        int n7;
        int n8;
        ByteBuffer buffer = ByteBuffer.allocate(this.getSize());
        Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"buffer");
        ExtensionsKt.put(buffer, this.adaptationFieldLength);
        ByteBuffer byteBuffer2 = buffer;
        int n9 = ExtensionsKt.shl(this.discontinuityIndicator, 7) | ExtensionsKt.shl(this.randomAccessIndicator, 6) | ExtensionsKt.shl(this.elementaryStreamPriorityIndicator, 5);
        Long l = this.programClockReference;
        if (l == null) {
            n8 = 0;
        } else {
            long l2 = ((Number)l).longValue();
            n7 = n9;
            byteBuffer = byteBuffer2;
            boolean bl = false;
            n6 = 1;
            byteBuffer2 = byteBuffer;
            n9 = n7;
            n8 = n5 = n6;
        }
        int n10 = n9 | n8 << 4;
        Long l3 = this.originalProgramClockReference;
        if (l3 == null) {
            n4 = 0;
        } else {
            long it2 = ((Number)l3).longValue();
            n7 = n10;
            byteBuffer = byteBuffer2;
            boolean bl = false;
            n6 = 1;
            byteBuffer2 = byteBuffer;
            n10 = n7;
            n4 = n5 = n6;
        }
        int n11 = n10 | n4 << 3;
        Byte by = this.spliceCountdown;
        if (by == null) {
            n3 = 0;
        } else {
            byte it3 = ((Number)by).byteValue();
            n7 = n11;
            byteBuffer = byteBuffer2;
            boolean bl = false;
            n6 = 1;
            byteBuffer2 = byteBuffer;
            n11 = n7;
            n3 = n5 = n6;
        }
        int n12 = n11 | n3 << 2;
        ByteBuffer byteBuffer3 = this.transportPrivateData;
        if (byteBuffer3 == null) {
            n2 = 0;
        } else {
            ByteBuffer it4 = byteBuffer3;
            n7 = n12;
            byteBuffer = byteBuffer2;
            boolean bl = false;
            n6 = 1;
            byteBuffer2 = byteBuffer;
            n12 = n7;
            n2 = n5 = n6;
        }
        int n13 = n12 | n2 << 1;
        ByteBuffer byteBuffer4 = this.adaptationFieldExtension;
        if (byteBuffer4 == null) {
            n = 0;
        } else {
            ByteBuffer it5 = byteBuffer4;
            n7 = n13;
            byteBuffer = byteBuffer2;
            boolean bl = false;
            n6 = 1;
            byteBuffer2 = byteBuffer;
            n13 = n7;
            n = n5 = n6;
        }
        ExtensionsKt.put(byteBuffer2, n13 | n);
        Long l4 = this.programClockReference;
        if (l4 != null) {
            it = ((Number)l4).longValue();
            boolean bl = false;
            this.addClockReference(buffer, it);
        }
        Long l5 = this.originalProgramClockReference;
        if (l5 != null) {
            it = ((Number)l5).longValue();
            boolean bl = false;
            this.addClockReference(buffer, it);
        }
        Byte by2 = this.spliceCountdown;
        if (by2 == null) {
            notImplementedError3 = null;
        } else {
            byte it6 = ((Number)by2).byteValue();
            boolean bl = false;
            buffer.put(this.spliceCountdown);
            notImplementedError3 = new NotImplementedError("spliceCountdown not implemented yet");
        }
        ByteBuffer byteBuffer5 = this.transportPrivateData;
        if (byteBuffer5 == null) {
            notImplementedError2 = null;
        } else {
            ByteBuffer it7 = byteBuffer5;
            boolean bl = false;
            buffer.put((byte)it7.remaining());
            buffer.put(this.transportPrivateData);
            notImplementedError2 = new NotImplementedError("transportPrivateData not implemented yet");
        }
        ByteBuffer byteBuffer6 = this.adaptationFieldExtension;
        if (byteBuffer6 == null) {
            notImplementedError = null;
        } else {
            ByteBuffer it8 = byteBuffer6;
            boolean bl = false;
            notImplementedError = new NotImplementedError("adaptationFieldExtension not implemented yet");
        }
        buffer.rewind();
        return buffer;
    }

    private final void addClockReference(ByteBuffer buffer, long timestamp) {
        long pcrBase = (long)27000000 * timestamp / (long)1000000 / (long)300 % (long)Math.pow(2.0, 33);
        long pcrExt = (long)27000000 * timestamp / (long)1000000 % (long)300;
        buffer.putInt((int)(pcrBase >> 1));
        ExtensionsKt.putShort(buffer, (pcrBase & 1L) << 15 | 0x7E00L | pcrExt & 0x1FFL);
    }

    public AdaptationField() {
        this(false, false, false, null, null, null, null, null, 255, null);
    }
}

