/*
 * Decompiled with CFR 0.152.
 */
package com.github.thibaultbee.streampack.internal.muxers.ts;

import com.github.thibaultbee.streampack.internal.data.Frame;
import com.github.thibaultbee.streampack.internal.muxers.IMuxerListener;
import com.github.thibaultbee.streampack.internal.muxers.ts.data.Service;
import com.github.thibaultbee.streampack.internal.muxers.ts.data.ServiceInfo;
import com.github.thibaultbee.streampack.internal.muxers.ts.data.Stream;
import com.github.thibaultbee.streampack.internal.muxers.ts.packets.Pat;
import com.github.thibaultbee.streampack.internal.muxers.ts.packets.Pes;
import com.github.thibaultbee.streampack.internal.muxers.ts.packets.Pmt;
import com.github.thibaultbee.streampack.internal.muxers.ts.packets.Psi;
import com.github.thibaultbee.streampack.internal.muxers.ts.packets.Sdt;
import com.github.thibaultbee.streampack.internal.utils.AVExtensionsKt;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.MissingFormatArgumentException;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005J$\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00072\u0006\u0010\u0019\u001a\u00020\u00142\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\"\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00072\u0006\u0010\u0017\u001a\u00020\u00052\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0016\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000fJ\u0018\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u0012H\u0002J\b\u0010!\u001a\u00020\u000fH\u0002J\u0010\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u000fH\u0002J\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007J\u0010\u0010$\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010#\u001a\u00020\u000fH\u0002J\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020&0\u00072\u0006\u0010(\u001a\u00020\bJ\u0010\u0010)\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0014H\u0002J\u000e\u0010)\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005J\u001e\u0010*\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00142\f\u0010+\u001a\b\u0012\u0004\u0012\u00020&0\u0007H\u0002J\u001c\u0010*\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00052\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0007J\u0010\u0010-\u001a\u00020\u00162\u0006\u0010.\u001a\u00020/H\u0002J\b\u00100\u001a\u00020\u0016H\u0002J\u0010\u00101\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0014H\u0002J\b\u00102\u001a\u00020\u0016H\u0002J\b\u00103\u001a\u00020\u0016H\u0002J\u0006\u00104\u001a\u00020\u0016J\b\u00105\u001a\u00020\u0016H\u0002J\b\u00106\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/github/thibaultbee/streampack/internal/muxers/ts/TSMuxer;", "", "muxerListener", "Lcom/github/thibaultbee/streampack/internal/muxers/IMuxerListener;", "firstServiceInfo", "Lcom/github/thibaultbee/streampack/internal/muxers/ts/data/ServiceInfo;", "initialStreams", "", "", "(Lcom/github/thibaultbee/streampack/internal/muxers/IMuxerListener;Lcom/github/thibaultbee/streampack/internal/muxers/ts/data/ServiceInfo;Ljava/util/List;)V", "pat", "Lcom/github/thibaultbee/streampack/internal/muxers/ts/packets/Pat;", "sdt", "Lcom/github/thibaultbee/streampack/internal/muxers/ts/packets/Sdt;", "tsId", "", "tsPes", "", "Lcom/github/thibaultbee/streampack/internal/muxers/ts/packets/Pes;", "tsServices", "Lcom/github/thibaultbee/streampack/internal/muxers/ts/data/Service;", "addService", "", "serviceInfo", "addStreams", "service", "streamsMimeType", "encode", "frame", "Lcom/github/thibaultbee/streampack/internal/data/Frame;", "streamPid", "generateStreams", "pes", "getNewPid", "getPes", "pid", "getService", "getStream", "Lcom/github/thibaultbee/streampack/internal/muxers/ts/data/Stream;", "getStreams", "mimeType", "removeService", "removeStreams", "streams", "streamsPid", "retransmitPsi", "forcePat", "", "sendPat", "sendPmt", "sendPmts", "sendSdt", "stop", "upgradePat", "upgradeSdt", "sdk_release"})
public final class TSMuxer {
    @NotNull
    private final IMuxerListener muxerListener;
    @NotNull
    private final List<Service> tsServices;
    @NotNull
    private final List<Pes> tsPes;
    private final short tsId;
    @NotNull
    private Pat pat;
    @NotNull
    private Sdt sdt;

    public TSMuxer(@NotNull IMuxerListener muxerListener, @Nullable ServiceInfo firstServiceInfo, @Nullable List<String> initialStreams) {
        Object it;
        Intrinsics.checkNotNullParameter((Object)muxerListener, (String)"muxerListener");
        this.muxerListener = muxerListener;
        this.tsServices = new ArrayList();
        this.tsPes = new ArrayList();
        this.tsId = (short)Random.Default.nextInt(-128, 127);
        this.pat = new Pat(this.muxerListener, this.tsServices, this.tsId, 0, 0, 8, null);
        this.sdt = new Sdt(this.muxerListener, this.tsServices, this.tsId, 0, 0, 0, 24, null);
        if (initialStreams != null && !(firstServiceInfo != null)) {
            boolean bl = false;
            String string = "If streams are specified, a service info must be specified too";
            throw new IllegalArgumentException(string.toString());
        }
        ServiceInfo serviceInfo = firstServiceInfo;
        if (serviceInfo != null) {
            it = serviceInfo;
            boolean bl = false;
            this.addService((ServiceInfo)it);
        }
        List<String> list = initialStreams;
        if (list != null) {
            it = list;
            boolean bl = false;
            this.addStreams(this.tsServices.get(0), (List<String>)it);
        }
    }

    public /* synthetic */ TSMuxer(IMuxerListener iMuxerListener, ServiceInfo serviceInfo, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            serviceInfo = null;
        }
        if ((n & 4) != 0) {
            list = null;
        }
        this(iMuxerListener, serviceInfo, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void encode(@NotNull Frame frame, short streamPid) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        switch (frame.getMimeType()) {
            case "video/avc": {
                if (!frame.isKeyFrame()) break;
                if (frame.getExtra() == null) {
                    throw new MissingFormatArgumentException("Missing extra for AVC");
                }
                ByteBuffer buffer = ByteBuffer.allocate(6 + frame.getExtra().limit() + frame.getBuffer().limit());
                buffer.putInt(1);
                buffer.put((byte)9);
                buffer.put((byte)-16);
                buffer.put(frame.getExtra());
                buffer.put(frame.getBuffer());
                buffer.rewind();
                Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"buffer");
                frame.setBuffer(buffer);
                break;
            }
            case "video/hevc": {
                if (!frame.isKeyFrame()) break;
                if (frame.getExtra() == null) {
                    throw new MissingFormatArgumentException("Missing extra for HEVC");
                }
                ByteBuffer buffer = ByteBuffer.allocate(7 + frame.getExtra().limit() + frame.getBuffer().limit());
                buffer.putInt(1);
                buffer.put((byte)70);
                buffer.put((byte)1);
                buffer.put((byte)80);
                buffer.put(frame.getExtra());
                buffer.put(frame.getBuffer());
                buffer.rewind();
                Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"buffer");
                frame.setBuffer(buffer);
                break;
            }
            case "audio/mp4a-latm": {
                if (frame.getExtra() == null) {
                    throw new MissingFormatArgumentException("Missing extra ADTS for AAC");
                }
                ByteBuffer buffer = ByteBuffer.allocate(frame.getBuffer().limit() + frame.getExtra().limit());
                ByteBuffer it = frame.getExtra();
                boolean bl = false;
                buffer.put(it);
                buffer.put(frame.getBuffer());
                buffer.rewind();
                Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"buffer");
                frame.setBuffer(buffer);
                break;
            }
            default: {
                throw new NotImplementedError(Intrinsics.stringPlus((String)"An operation is not implemented: ", (Object)"Format not yet implemented"));
            }
        }
        synchronized (this) {
            boolean bl = false;
            this.generateStreams(frame, this.getPes(streamPid));
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void generateStreams(Frame frame, Pes pes) {
        this.retransmitPsi(AVExtensionsKt.isVideo(frame.getMimeType()) & frame.isKeyFrame());
        pes.write(frame);
    }

    private final void retransmitPsi(boolean forcePat) {
        boolean sendSdt = false;
        boolean sendPat = false;
        Psi psi = this.sdt;
        ((Sdt)psi).setPacketCount(((Sdt)psi).getPacketCount() + 1);
        if (this.sdt.getPacketCount() == 200) {
            this.sdt.setPacketCount(0);
            sendSdt = true;
        }
        psi = this.pat;
        ((Pat)psi).setPacketCount(((Pat)psi).getPacketCount() + 1);
        if (this.pat.getPacketCount() == 40 || forcePat) {
            this.pat.setPacketCount(0);
            sendPat = true;
        }
        if (sendSdt) {
            this.sendSdt();
        }
        if (sendPat) {
            this.sendPat();
            this.sendPmts();
        }
    }

    private final void upgradePat() {
        this.pat.setVersionNumber((byte)(this.pat.getVersionNumber() + 1));
        this.sendPat();
    }

    private final void sendPat() {
        this.pat.write();
    }

    private final void sendPmt(Service service) {
        Unit unit;
        Pmt pmt = service.getPmt();
        if (pmt == null) {
            unit = null;
        } else {
            pmt.write();
            unit = Unit.INSTANCE;
        }
        if (unit == null) {
            throw new UnsupportedOperationException("PMT must not be null");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void sendPmts() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.tsServices;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Service it = (Service)element$iv$iv;
            boolean bl = false;
            if (!(it.getPmt() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Unit unit;
            Service it = (Service)element$iv;
            boolean bl = false;
            Pmt pmt = it.getPmt();
            if (pmt == null) {
                unit = null;
            } else {
                pmt.write();
                unit = Unit.INSTANCE;
            }
            if (unit != null) continue;
            throw new UnsupportedOperationException("PMT must not be null");
        }
    }

    private final void upgradeSdt() {
        this.sdt.setVersionNumber((byte)(this.sdt.getVersionNumber() + 1));
        this.sendSdt();
    }

    private final void sendSdt() {
        this.sdt.write();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ServiceInfo> getService() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.tsServices;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Service service = (Service)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getInfo());
        }
        return (List)destination$iv$iv;
    }

    public final void addService(@NotNull ServiceInfo serviceInfo) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)serviceInfo, (String)"serviceInfo");
            Iterable $this$none$iv = this.tsServices;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Service it = (Service)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getInfo(), (Object)serviceInfo)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (!bl) {
            boolean bl3 = false;
            String string = "Service already exists";
            throw new IllegalArgumentException(string.toString());
        }
        this.tsServices.add(new Service(serviceInfo, null, null, null, 14, null));
    }

    public final void removeService(@NotNull ServiceInfo serviceInfo) {
        Intrinsics.checkNotNullParameter((Object)serviceInfo, (String)"serviceInfo");
        this.removeService(this.getService(serviceInfo));
    }

    private final void removeService(Service service) {
        if (!this.tsServices.contains(service)) {
            boolean bl = false;
            String string = "Unknown service";
            throw new IllegalArgumentException(string.toString());
        }
        this.tsServices.remove(service);
        if (!((Collection)service.getStreams()).isEmpty()) {
            this.removeStreams(service, service.getStreams());
        }
        this.upgradeSdt();
        this.upgradePat();
    }

    @NotNull
    public final List<Short> addStreams(@NotNull ServiceInfo serviceInfo, @NotNull List<String> streamsMimeType) {
        Intrinsics.checkNotNullParameter((Object)serviceInfo, (String)"serviceInfo");
        Intrinsics.checkNotNullParameter(streamsMimeType, (String)"streamsMimeType");
        return this.addStreams(this.getService(serviceInfo), streamsMimeType);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Short> addStreams(Service service, List<String> streamsMimeType) {
        void $this$mapTo$iv$iv;
        Object $this$addStreams_u24lambda_u2d16_u24lambda_u2d15;
        Iterator iterator;
        Service service2;
        Object object;
        Short $this$first$iv;
        Object it;
        Object element$iv2;
        if (!this.tsServices.contains(service)) {
            boolean $i$a$-require-TSMuxer$addStreams$22 = false;
            String $i$a$-require-TSMuxer$addStreams$22 = "Unknown service";
            throw new IllegalArgumentException($i$a$-require-TSMuxer$addStreams$22.toString());
        }
        boolean isNewService = service.getPmt() == null;
        List newStreams = new ArrayList();
        Iterable $this$forEach$iv = streamsMimeType;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            it = (String)element$iv2;
            boolean bl = false;
            Stream stream = new Stream((String)it, this.getNewPid(), false, 4, null);
            newStreams.add(stream);
            service.getStreams().add(stream);
        }
        Object object2 = service;
        try {
            Service service3;
            block10: {
                $this$forEach$iv = service.getStreams();
                service3 = object2;
                boolean $i$f$first = false;
                object = $this$first$iv.iterator();
                while (object.hasNext()) {
                    element$iv2 = object.next();
                    it = (Stream)element$iv2;
                    boolean bl = false;
                    if (!AVExtensionsKt.isVideo(((Stream)it).getMimeType())) continue;
                    break block10;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            service2 = service3;
            $this$first$iv = ((Stream)element$iv2).getPid();
        }
        catch (NoSuchElementException $i$f$first) {
            service2 = object2;
            $this$first$iv = service.getStreams().get(0).getPid();
        }
        service2.setPcrPid($this$first$iv);
        Service service4 = service;
        Pmt pmt = service.getPmt();
        if (pmt == null) {
            iterator = null;
        } else {
            void $this$addStreams_u24lambda_u2d14;
            object = pmt;
            element$iv2 = object;
            object2 = service4;
            boolean bl = false;
            $this$addStreams_u24lambda_u2d14.setVersionNumber((byte)($this$addStreams_u24lambda_u2d14.getVersionNumber() + 1));
            $this$addStreams_u24lambda_u2d14.setStreams(service.getStreams());
            service4 = object2;
            iterator = object;
        }
        $this$first$iv = iterator;
        service4.setPmt((Pmt)($this$first$iv == null ? new Pmt(this.muxerListener, service, service.getStreams(), this.getNewPid(), 0, 16, null) : $this$first$iv));
        $this$forEach$iv = newStreams;
        $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            Stream it2 = (Stream)element$iv2;
            boolean bl = false;
            Short s = service.getPcrPid();
            $this$addStreams_u24lambda_u2d16_u24lambda_u2d15 = new Pes(this.muxerListener, it2, s == null ? false : s.shortValue() == it2.getPid());
            boolean bl2 = false;
            this.tsPes.add((Pes)$this$addStreams_u24lambda_u2d16_u24lambda_u2d15);
        }
        this.sendPmt(service);
        if (isNewService) {
            this.upgradeSdt();
            this.upgradePat();
        }
        Iterable $this$map$iv = newStreams;
        boolean $i$f$map = false;
        object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it3;
            $this$addStreams_u24lambda_u2d16_u24lambda_u2d15 = (Stream)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            object2.add(it3.getPid());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public final void removeStreams(@NotNull ServiceInfo serviceInfo, @NotNull List<Short> streamsPid) {
        Collection<Stream> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)serviceInfo, (String)"serviceInfo");
        Intrinsics.checkNotNullParameter(streamsPid, (String)"streamsPid");
        Iterable iterable = streamsPid;
        Service service = this.getService(serviceInfo);
        TSMuxer tSMuxer = this;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            short s = ((Number)item$iv$iv).shortValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getStream((short)it));
        }
        collection = (List)destination$iv$iv;
        tSMuxer.removeStreams(service, (List<Stream>)collection);
    }

    private final void removeStreams(Service service, List<Stream> streams) {
        Iterable $this$forEach$iv = service.getStreams();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Stream it = (Stream)element$iv;
            boolean bl = false;
            this.tsPes.remove(this.getPes(it.getPid()));
        }
        service.getStreams().removeAll((Collection)streams);
        Pmt pmt = service.getPmt();
        if (pmt != null) {
            Pmt it = pmt;
            boolean bl = false;
            it.setVersionNumber((byte)(it.getVersionNumber() + 1));
            it.setStreams(service.getStreams());
        }
        this.sendPmt(service);
    }

    public final void stop() {
        this.tsPes.clear();
        this.tsServices.clear();
    }

    /*
     * WARNING - void declaration
     */
    private final short getNewPid() {
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Collection collection;
        void $this$mapTo$iv$iv;
        Object list$iv$iv;
        Service it;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.tsServices;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Service)element$iv$iv;
            boolean bl = false;
            list$iv$iv = it.getStreams();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (Stream)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Stream)((Object)it)).getPid());
        }
        $this$map$iv = this.tsServices;
        collection = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Service)element$iv$iv;
            boolean bl = false;
            if (!(it.getPmt() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Service)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Pmt pmt = it.getPmt();
            collection2.add(pmt == null ? null : Short.valueOf(pmt.getPid()));
        }
        List currentPids = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
        int n = 32;
        while (n < 8186) {
            int i;
            if (currentPids.contains((short)(i = n++))) continue;
            return (short)i;
        }
        throw new IndexOutOfBoundsException("No empty PID left");
    }

    private final Pes getPes(short pid) {
        Object element$iv2;
        block1: {
            Iterable $this$first$iv = this.tsPes;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                Pes it = (Pes)element$iv2;
                boolean bl = false;
                if (!(it.getStream().getPid() == pid)) continue;
                break block1;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return (Pes)element$iv2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Stream> getStreams(@NotNull String mimeType) {
        void $this$filterTo$iv$iv;
        Object it;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Iterable $this$flatMap$iv = this.tsServices;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Service)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = ((Service)it).getStreams();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Stream)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)((Stream)it).getMimeType(), (Object)mimeType)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Stream getStream(short pid) {
        Object element$iv2;
        block2: {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = this.tsServices;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Service it = (Service)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getStreams();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$first$iv = (List)destination$iv$iv;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                Stream it = (Stream)element$iv2;
                boolean bl = false;
                if (!(it.getPid() == pid)) continue;
                break block2;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return (Stream)element$iv2;
    }

    private final Service getService(ServiceInfo serviceInfo) {
        Object element$iv2;
        block1: {
            Iterable $this$first$iv = this.tsServices;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                Service it = (Service)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getInfo(), (Object)serviceInfo)) continue;
                break block1;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return (Service)element$iv2;
    }
}

