/*
 * Decompiled with CFR 0.152.
 */
package com.github.thibaultbee.streampack.internal.endpoints;

import com.github.thibaultbee.srtdroid.Srt;
import com.github.thibaultbee.srtdroid.enums.Boundary;
import com.github.thibaultbee.srtdroid.enums.ErrorType;
import com.github.thibaultbee.srtdroid.enums.SockOpt;
import com.github.thibaultbee.srtdroid.enums.Transtype;
import com.github.thibaultbee.srtdroid.listeners.SocketListener;
import com.github.thibaultbee.srtdroid.models.MsgCtrl;
import com.github.thibaultbee.srtdroid.models.Socket;
import com.github.thibaultbee.srtdroid.models.Stats;
import com.github.thibaultbee.streampack.internal.data.Packet;
import com.github.thibaultbee.streampack.internal.endpoints.IEndpoint;
import com.github.thibaultbee.streampack.listeners.OnConnectionListener;
import com.github.thibaultbee.streampack.logger.ILogger;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 02\u00020\u0001:\u00010B\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J#\u0010%\u001a\u0004\u0018\u00010\"2\u0006\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020$H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010(J\u0006\u0010)\u001a\u00020\"J\b\u0010*\u001a\u00020\"H\u0016J\b\u0010+\u001a\u00020\"H\u0016J\b\u0010,\u001a\u00020\"H\u0016J\u0010\u0010-\u001a\u00020\"2\u0006\u0010.\u001a\u00020/H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R$\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00128F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR$\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00128F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010\u0015\"\u0004\b \u0010\u0017\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00061"}, d2={"Lcom/github/thibaultbee/streampack/internal/endpoints/SrtProducer;", "Lcom/github/thibaultbee/streampack/internal/endpoints/IEndpoint;", "coroutineDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "logger", "Lcom/github/thibaultbee/streampack/logger/ILogger;", "(Lkotlinx/coroutines/CoroutineDispatcher;Lcom/github/thibaultbee/streampack/logger/ILogger;)V", "bitrate", "", "getLogger", "()Lcom/github/thibaultbee/streampack/logger/ILogger;", "onConnectionListener", "Lcom/github/thibaultbee/streampack/listeners/OnConnectionListener;", "getOnConnectionListener", "()Lcom/github/thibaultbee/streampack/listeners/OnConnectionListener;", "setOnConnectionListener", "(Lcom/github/thibaultbee/streampack/listeners/OnConnectionListener;)V", "value", "", "passPhrase", "getPassPhrase", "()Ljava/lang/String;", "setPassPhrase", "(Ljava/lang/String;)V", "socket", "Lcom/github/thibaultbee/srtdroid/models/Socket;", "stats", "Lcom/github/thibaultbee/srtdroid/models/Stats;", "getStats", "()Lcom/github/thibaultbee/srtdroid/models/Stats;", "streamId", "getStreamId", "setStreamId", "configure", "", "startBitrate", "", "connect", "ip", "port", "(Ljava/lang/String;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "disconnect", "release", "startStream", "stopStream", "write", "packet", "Lcom/github/thibaultbee/streampack/internal/data/Packet;", "Companion", "sdk_release"})
public final class SrtProducer
implements IEndpoint {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineDispatcher coroutineDispatcher;
    @NotNull
    private final ILogger logger;
    @Nullable
    private OnConnectionListener onConnectionListener;
    @NotNull
    private Socket socket;
    private long bitrate;
    private static final int PAYLOAD_SIZE = 1316;

    public SrtProducer(@NotNull CoroutineDispatcher coroutineDispatcher, @NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)coroutineDispatcher, (String)"coroutineDispatcher");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.coroutineDispatcher = coroutineDispatcher;
        this.logger = logger;
        this.socket = new Socket();
    }

    public /* synthetic */ SrtProducer(CoroutineDispatcher coroutineDispatcher, ILogger iLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            coroutineDispatcher = Dispatchers.getIO();
        }
        this(coroutineDispatcher, iLogger);
    }

    @NotNull
    public final ILogger getLogger() {
        return this.logger;
    }

    @Nullable
    public final OnConnectionListener getOnConnectionListener() {
        return this.onConnectionListener;
    }

    public final void setOnConnectionListener(@Nullable OnConnectionListener onConnectionListener) {
        this.onConnectionListener = onConnectionListener;
    }

    @NotNull
    public final String getStreamId() {
        return (String)this.socket.getSockFlag(SockOpt.STREAMID);
    }

    public final void setStreamId(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.socket.setSockFlag(SockOpt.STREAMID, (Object)value);
    }

    @NotNull
    public final String getPassPhrase() {
        return (String)this.socket.getSockFlag(SockOpt.PASSPHRASE);
    }

    public final void setPassPhrase(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.socket.setSockFlag(SockOpt.PASSPHRASE, (Object)value);
    }

    @NotNull
    public final Stats getStats() {
        return this.socket.bistats(true, true);
    }

    @Override
    public void configure(int startBitrate) {
        this.bitrate = startBitrate;
    }

    @Nullable
    public final Object connect(@NotNull String ip, int port, @NotNull Continuation<? super Unit> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)this.coroutineDispatcher), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, ip, port, null){
            int label;
            final /* synthetic */ SrtProducer this$0;
            final /* synthetic */ String $ip;
            final /* synthetic */ int $port;
            {
                this.this$0 = $receiver;
                this.$ip = $ip;
                this.$port = $port;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Unit unit;
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            Unit unit2;
                            SrtProducer.access$getSocket$p(this.this$0).setListener(new SocketListener(this.this$0){
                                final /* synthetic */ SrtProducer this$0;
                                {
                                    this.this$0 = $receiver;
                                }

                                public void onConnectionLost(@NotNull Socket ns, @NotNull ErrorType error, @NotNull InetSocketAddress peerAddress, int token) {
                                    Intrinsics.checkNotNullParameter((Object)ns, (String)"ns");
                                    Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                                    Intrinsics.checkNotNullParameter((Object)peerAddress, (String)"peerAddress");
                                    SrtProducer.access$setSocket$p(this.this$0, new Socket());
                                    OnConnectionListener onConnectionListener = this.this$0.getOnConnectionListener();
                                    if (onConnectionListener != null) {
                                        onConnectionListener.onLost(error.toString());
                                    }
                                }

                                public int onListen(@NotNull Socket ns, int hsVersion, @NotNull InetSocketAddress peerAddress, @NotNull String streamId) {
                                    Intrinsics.checkNotNullParameter((Object)ns, (String)"ns");
                                    Intrinsics.checkNotNullParameter((Object)peerAddress, (String)"peerAddress");
                                    Intrinsics.checkNotNullParameter((Object)streamId, (String)"streamId");
                                    return 0;
                                }
                            });
                            SrtProducer.access$getSocket$p(this.this$0).setSockFlag(SockOpt.PAYLOADSIZE, (Object)Boxing.boxInt((int)1316));
                            SrtProducer.access$getSocket$p(this.this$0).setSockFlag(SockOpt.TRANSTYPE, (Object)Transtype.LIVE);
                            SrtProducer.access$getSocket$p(this.this$0).connect(this.$ip, this.$port);
                            OnConnectionListener onConnectionListener = this.this$0.getOnConnectionListener();
                            if (onConnectionListener == null) {
                                unit2 = null;
                            } else {
                                onConnectionListener.onSuccess();
                                unit2 = Unit.INSTANCE;
                            }
                            unit = unit2;
                        }
                        catch (Exception e) {
                            SrtProducer.access$setSocket$p(this.this$0, new Socket());
                            OnConnectionListener onConnectionListener = this.this$0.getOnConnectionListener();
                            if (onConnectionListener != null) {
                                String string = e.getMessage();
                                if (string == null) {
                                    string = "Unknown error";
                                }
                                onConnectionListener.onFailed(string);
                            }
                            throw e;
                        }
                        return unit;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    public final void disconnect() {
        this.socket.close();
        this.socket = new Socket();
    }

    @Override
    public void write(@NotNull Packet packet) {
        MsgCtrl msgCtrl;
        Boundary boundary;
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Boundary boundary2 = packet.isFirstPacketFrame() && packet.isLastPacketFrame() ? Boundary.SOLO : (packet.isFirstPacketFrame() ? Boundary.FIRST : (boundary = packet.isLastPacketFrame() ? Boundary.LAST : Boundary.SUBSEQUENT));
        if (packet.getTs() == 0L) {
            msgCtrl = new MsgCtrl(0, 0, false, boundary, 0L, 0, 0, 119, null);
        } else {
            long l = packet.getTs();
            msgCtrl = new MsgCtrl(0, 500, false, boundary, l, 0, 0, 101, null);
        }
        MsgCtrl msgCtrl2 = msgCtrl;
        this.socket.send(packet.getBuffer(), msgCtrl2);
    }

    @Override
    public void startStream() {
        if (!this.socket.isConnected()) {
            throw new ConnectException("SrtEndpoint should be connected at this point");
        }
        this.socket.setSockFlag(SockOpt.MAXBW, (Object)0L);
        this.socket.setSockFlag(SockOpt.INPUTBW, (Object)this.bitrate);
    }

    @Override
    public void stopStream() {
    }

    @Override
    public void release() {
        Srt.INSTANCE.cleanUp();
    }

    public static final /* synthetic */ Socket access$getSocket$p(SrtProducer $this) {
        return $this.socket;
    }

    public static final /* synthetic */ void access$setSocket$p(SrtProducer $this, Socket socket) {
        $this.socket = socket;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/github/thibaultbee/streampack/internal/endpoints/SrtProducer$Companion;", "", "()V", "PAYLOAD_SIZE", "", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

