/*
 * Decompiled with CFR 0.152.
 */
package com.github.thibaultbee.streampack.internal.encoders;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.util.Range;
import com.github.thibaultbee.streampack.internal.utils.AVExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0005"}, d2={"Lcom/github/thibaultbee/streampack/internal/encoders/MediaCodecHelper;", "", "()V", "Audio", "Video", "sdk_release"})
public final class MediaCodecHelper {
    @NotNull
    public static final MediaCodecHelper INSTANCE = new MediaCodecHelper();

    private MediaCodecHelper() {
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0005J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0005R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/github/thibaultbee/streampack/internal/encoders/MediaCodecHelper$Video;", "", "()V", "supportedEncoders", "", "", "getSupportedEncoders", "()Ljava/util/List;", "getBitrateRange", "Landroid/util/Range;", "", "mimeType", "getCapabilities", "Landroid/media/MediaCodecInfo$VideoCapabilities;", "getFramerateRange", "getSupportedHeights", "getSupportedMediaCodecEncoders", "getSupportedWidths", "sdk_release"})
    public static final class Video {
        @NotNull
        public static final Video INSTANCE = new Video();
        @NotNull
        private static final List<String> supportedEncoders = INSTANCE.getSupportedMediaCodecEncoders();

        private Video() {
        }

        @NotNull
        public final List<String> getSupportedEncoders() {
            return supportedEncoders;
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> getSupportedMediaCodecEncoders() {
            Object $this$flatMapTo$iv$iv;
            void var8_11;
            Iterable $this$filterTo$iv$iv;
            List encoders = new ArrayList();
            MediaCodecInfo[] mediaCodecInfoArray = new MediaCodecList(0).getCodecInfos();
            Intrinsics.checkNotNullExpressionValue((Object)mediaCodecInfoArray, (String)"MediaCodecList(MediaCode\u2026EGULAR_CODECS).codecInfos");
            Object $this$filter$iv = mediaCodecInfoArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv;
            boolean bl = false;
            int n = ((void)iterator).length;
            while (var8_11 < n) {
                void element$iv$iv = iterator[var8_11];
                ++var8_11;
                MediaCodecInfo it = (MediaCodecInfo)element$iv$iv;
                boolean bl2 = false;
                if (!it.isEncoder()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$flatMap = false;
            $this$filterTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object t : $this$flatMapTo$iv$iv) {
                MediaCodecInfo it = (MediaCodecInfo)t;
                boolean bl3 = false;
                String[] stringArray = it.getSupportedTypes();
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"it.supportedTypes");
                Iterable list$iv$iv = ArraysKt.toList((Object[])stringArray);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$flatMapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object t : $this$filterTo$iv$iv) {
                String it = (String)t;
                boolean bl4 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (!AVExtensionsKt.isVideo(it)) continue;
                destination$iv$iv.add(t);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl5 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                encoders.add(it);
            }
            return encoders;
        }

        private final MediaCodecInfo.VideoCapabilities getCapabilities(String mimeType) {
            MediaFormat $i$a$-require-MediaCodecHelper$Video$getCapabilities$222;
            if (!AVExtensionsKt.isVideo(mimeType)) {
                boolean $i$a$-require-MediaCodecHelper$Video$getCapabilities$222 = false;
                String $i$a$-require-MediaCodecHelper$Video$getCapabilities$222 = "Mime Type must be video";
                throw new IllegalArgumentException($i$a$-require-MediaCodecHelper$Video$getCapabilities$222.toString());
            }
            MediaFormat $this$getCapabilities_u24lambda_u2d5 = $i$a$-require-MediaCodecHelper$Video$getCapabilities$222 = new MediaFormat();
            boolean bl = false;
            $this$getCapabilities_u24lambda_u2d5.setString("mime", mimeType);
            MediaFormat format = $i$a$-require-MediaCodecHelper$Video$getCapabilities$222;
            MediaCodecList mediaCodecList = new MediaCodecList(0);
            String encoderName = mediaCodecList.findEncoderForFormat(format);
            MediaCodec mediaCodec = MediaCodec.createByCodecName((String)encoderName);
            Intrinsics.checkNotNullExpressionValue((Object)mediaCodec, (String)"createByCodecName(encoderName)");
            MediaCodec mediaCodec2 = mediaCodec;
            MediaCodecInfo.VideoCapabilities videoCapabilities = mediaCodec2.getCodecInfo().getCapabilitiesForType(mimeType).getVideoCapabilities();
            mediaCodec2.release();
            Intrinsics.checkNotNullExpressionValue((Object)videoCapabilities, (String)"videoCapabilities");
            return videoCapabilities;
        }

        @NotNull
        public final Range<Integer> getSupportedHeights(@NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            Range range = this.getCapabilities(mimeType).getSupportedHeights();
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getCapabilities(mimeType).supportedHeights");
            return range;
        }

        @NotNull
        public final Range<Integer> getSupportedWidths(@NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            Range range = this.getCapabilities(mimeType).getSupportedHeights();
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getCapabilities(mimeType).supportedHeights");
            return range;
        }

        @NotNull
        public final Range<Integer> getFramerateRange(@NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            Range range = this.getCapabilities(mimeType).getSupportedFrameRates();
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getCapabilities(mimeType).supportedFrameRates");
            return range;
        }

        @NotNull
        public final Range<Integer> getBitrateRange(@NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            Range range = this.getCapabilities(mimeType).getBitrateRange();
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getCapabilities(mimeType).bitrateRange");
            return range;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u001c\u0010\u000e\u001a\u0010\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\n0\n0\t2\u0006\u0010\u000b\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u0005R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/github/thibaultbee/streampack/internal/encoders/MediaCodecHelper$Audio;", "", "()V", "supportedEncoders", "", "", "getSupportedEncoders", "()Ljava/util/List;", "getBitrateRange", "Landroid/util/Range;", "", "mimeType", "getCapabilities", "Landroid/media/MediaCodecInfo$AudioCapabilities;", "getInputChannelRange", "kotlin.jvm.PlatformType", "getSupportedMediaCodecEncoders", "getSupportedSampleRates", "", "sdk_release"})
    public static final class Audio {
        @NotNull
        public static final Audio INSTANCE = new Audio();
        @NotNull
        private static final List<String> supportedEncoders = INSTANCE.getSupportedMediaCodecEncoders();

        private Audio() {
        }

        @NotNull
        public final List<String> getSupportedEncoders() {
            return supportedEncoders;
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> getSupportedMediaCodecEncoders() {
            Object $this$flatMapTo$iv$iv;
            void var8_11;
            Iterable $this$filterTo$iv$iv;
            List encoders = new ArrayList();
            MediaCodecInfo[] mediaCodecInfoArray = new MediaCodecList(0).getCodecInfos();
            Intrinsics.checkNotNullExpressionValue((Object)mediaCodecInfoArray, (String)"MediaCodecList(MediaCode\u2026EGULAR_CODECS).codecInfos");
            Object $this$filter$iv = mediaCodecInfoArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv;
            boolean bl = false;
            int n = ((void)iterator).length;
            while (var8_11 < n) {
                void element$iv$iv = iterator[var8_11];
                ++var8_11;
                MediaCodecInfo it = (MediaCodecInfo)element$iv$iv;
                boolean bl2 = false;
                if (!it.isEncoder()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$flatMap = false;
            $this$filterTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object t : $this$flatMapTo$iv$iv) {
                MediaCodecInfo it = (MediaCodecInfo)t;
                boolean bl3 = false;
                String[] stringArray = it.getSupportedTypes();
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"it.supportedTypes");
                Iterable list$iv$iv = ArraysKt.toList((Object[])stringArray);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$flatMapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object t : $this$filterTo$iv$iv) {
                String it = (String)t;
                boolean bl4 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (!AVExtensionsKt.isAudio(it)) continue;
                destination$iv$iv.add(t);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl5 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                encoders.add(it);
            }
            return encoders;
        }

        private final MediaCodecInfo.AudioCapabilities getCapabilities(String mimeType) {
            MediaFormat $i$a$-require-MediaCodecHelper$Audio$getCapabilities$222;
            if (!AVExtensionsKt.isAudio(mimeType)) {
                boolean $i$a$-require-MediaCodecHelper$Audio$getCapabilities$222 = false;
                String $i$a$-require-MediaCodecHelper$Audio$getCapabilities$222 = "Mime Type must be audio";
                throw new IllegalArgumentException($i$a$-require-MediaCodecHelper$Audio$getCapabilities$222.toString());
            }
            MediaFormat $this$getCapabilities_u24lambda_u2d5 = $i$a$-require-MediaCodecHelper$Audio$getCapabilities$222 = new MediaFormat();
            boolean bl = false;
            $this$getCapabilities_u24lambda_u2d5.setString("mime", mimeType);
            MediaFormat format = $i$a$-require-MediaCodecHelper$Audio$getCapabilities$222;
            MediaCodecList mediaCodecList = new MediaCodecList(0);
            String encoderName = mediaCodecList.findEncoderForFormat(format);
            MediaCodec mediaCodec = MediaCodec.createByCodecName((String)encoderName);
            Intrinsics.checkNotNullExpressionValue((Object)mediaCodec, (String)"createByCodecName(encoderName)");
            MediaCodec mediaCodec2 = mediaCodec;
            MediaCodecInfo.AudioCapabilities audioCapabilities = mediaCodec2.getCodecInfo().getCapabilitiesForType(mimeType).getAudioCapabilities();
            mediaCodec2.release();
            Intrinsics.checkNotNullExpressionValue((Object)audioCapabilities, (String)"audioCapabilities");
            return audioCapabilities;
        }

        @NotNull
        public final Range<Integer> getInputChannelRange(@NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            return new Range((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(this.getCapabilities(mimeType).getMaxInputChannelCount()));
        }

        @NotNull
        public final Range<Integer> getBitrateRange(@NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            Range range = this.getCapabilities(mimeType).getBitrateRange();
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getCapabilities(mimeType).bitrateRange");
            return range;
        }

        @NotNull
        public final int[] getSupportedSampleRates(@NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            int[] nArray = this.getCapabilities(mimeType).getSupportedSampleRates();
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getCapabilities(mimeType).supportedSampleRates");
            return nArray;
        }
    }
}

