/*
 * Decompiled with CFR 0.152.
 */
package com.github.thibaultbee.streampack.internal.encoders;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import com.github.thibaultbee.streampack.data.AudioConfig;
import com.github.thibaultbee.streampack.internal.encoders.IEncoderListener;
import com.github.thibaultbee.streampack.internal.encoders.MediaCodecEncoder;
import com.github.thibaultbee.streampack.internal.encoders.format.aac.Adts;
import com.github.thibaultbee.streampack.listeners.OnErrorListener;
import com.github.thibaultbee.streampack.logger.ILogger;
import java.nio.ByteBuffer;
import java.security.InvalidParameterException;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/github/thibaultbee/streampack/internal/encoders/AudioMediaCodecEncoder;", "Lcom/github/thibaultbee/streampack/internal/encoders/MediaCodecEncoder;", "Lcom/github/thibaultbee/streampack/data/AudioConfig;", "encoderListener", "Lcom/github/thibaultbee/streampack/internal/encoders/IEncoderListener;", "onInternalErrorListener", "Lcom/github/thibaultbee/streampack/listeners/OnErrorListener;", "logger", "Lcom/github/thibaultbee/streampack/logger/ILogger;", "(Lcom/github/thibaultbee/streampack/internal/encoders/IEncoderListener;Lcom/github/thibaultbee/streampack/listeners/OnErrorListener;Lcom/github/thibaultbee/streampack/logger/ILogger;)V", "getOnInternalErrorListener", "()Lcom/github/thibaultbee/streampack/listeners/OnErrorListener;", "configure", "", "config", "createAudioCodec", "Landroid/media/MediaCodec;", "audioConfig", "onGenerateExtra", "Ljava/nio/ByteBuffer;", "buffer", "format", "Landroid/media/MediaFormat;", "sdk_release"})
public final class AudioMediaCodecEncoder
extends MediaCodecEncoder<AudioConfig> {
    @NotNull
    private final OnErrorListener onInternalErrorListener;

    public AudioMediaCodecEncoder(@NotNull IEncoderListener encoderListener, @NotNull OnErrorListener onInternalErrorListener2, @NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)encoderListener, (String)"encoderListener");
        Intrinsics.checkNotNullParameter((Object)onInternalErrorListener2, (String)"onInternalErrorListener");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        super(encoderListener, logger);
        this.onInternalErrorListener = onInternalErrorListener2;
    }

    @Override
    @NotNull
    protected OnErrorListener getOnInternalErrorListener() {
        return this.onInternalErrorListener;
    }

    @Override
    public void configure(@NotNull AudioConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.setMediaCodec(this.createAudioCodec(config));
    }

    private final MediaCodec createAudioCodec(AudioConfig audioConfig) {
        MediaFormat mediaFormat = MediaFormat.createAudioFormat((String)audioConfig.getMimeType(), (int)audioConfig.getSampleRate(), (int)AudioConfig.Companion.getNumberOfChannels(audioConfig.getChannelConfig()));
        Intrinsics.checkNotNullExpressionValue((Object)mediaFormat, (String)"createAudioFormat(\n     \u2026.channelConfig)\n        )");
        MediaFormat audioFormat = mediaFormat;
        MediaCodec codec = this.createCodec(audioFormat);
        if (Build.VERSION.SDK_INT >= 24) {
            audioFormat.setInteger("pcm-encoding", audioConfig.getByteFormat());
        }
        audioFormat.setInteger("bitrate", audioConfig.getStartBitrate());
        this.set_bitrate(audioConfig.getStartBitrate());
        if (Intrinsics.areEqual((Object)audioConfig.getMimeType(), (Object)"audio/mp4a-latm")) {
            audioFormat.setInteger("aac-profile", 2);
        }
        audioFormat.setInteger("max-input-size", 0);
        this.configureCodec(codec, audioFormat, "AMediaCodecThread");
        return codec;
    }

    @Override
    @NotNull
    public ByteBuffer onGenerateExtra(@NotNull ByteBuffer buffer, @NotNull MediaFormat format) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        String mimeType = format.getString("mime");
        if (Intrinsics.areEqual((Object)mimeType, (Object)"audio/mp4a-latm")) {
            return new Adts(format, buffer.limit()).toByteBuffer();
        }
        if (Intrinsics.areEqual((Object)mimeType, (Object)"audio/opus")) {
            throw new NotImplementedError(Intrinsics.stringPlus((String)"An operation is not implemented: ", (Object)"Not yet implemented"));
        }
        throw new InvalidParameterException(Intrinsics.stringPlus((String)"Format is not supported: ", (Object)mimeType));
    }
}

