/*
 * Decompiled with CFR 0.152.
 */
package com.github.thibaultbee.streampack.utils;

import android.util.Range;
import com.github.thibaultbee.streampack.internal.encoders.MediaCodecHelper;
import com.github.thibaultbee.streampack.internal.muxers.ts.TSMuxerHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0005"}, d2={"Lcom/github/thibaultbee/streampack/utils/StreamerConfigurationHelper;", "", "()V", "Audio", "Video", "sdk_release"})
public final class StreamerConfigurationHelper {
    @NotNull
    public static final StreamerConfigurationHelper INSTANCE = new StreamerConfigurationHelper();

    private StreamerConfigurationHelper() {
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0005J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0005J&\u0010\r\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u000e2\u0006\u0010\u000b\u001a\u00020\u0005R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/github/thibaultbee/streampack/utils/StreamerConfigurationHelper$Video;", "", "()V", "supportedEncoders", "", "", "getSupportedEncoders", "()Ljava/util/List;", "getSupportedBitrates", "Landroid/util/Range;", "", "mimeType", "getSupportedFramerate", "getSupportedResolutions", "Lkotlin/Pair;", "sdk_release"})
    public static final class Video {
        @NotNull
        public static final Video INSTANCE;
        @NotNull
        private static final List<String> supportedEncoders;

        private Video() {
        }

        @NotNull
        public final List<String> getSupportedEncoders() {
            return supportedEncoders;
        }

        @NotNull
        public final Pair<Range<Integer>, Range<Integer>> getSupportedResolutions(@NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            Range<Integer> codecSupportedWidths = MediaCodecHelper.Video.INSTANCE.getSupportedWidths(mimeType);
            Range<Integer> codecSupportedHeights = MediaCodecHelper.Video.INSTANCE.getSupportedHeights(mimeType);
            return new Pair(codecSupportedWidths, codecSupportedHeights);
        }

        @NotNull
        public final Range<Integer> getSupportedFramerate(@NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            return MediaCodecHelper.Video.INSTANCE.getFramerateRange(mimeType);
        }

        @NotNull
        public final Range<Integer> getSupportedBitrates(@NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            return MediaCodecHelper.Video.INSTANCE.getBitrateRange(mimeType);
        }

        /*
         * WARNING - void declaration
         */
        static {
            void var3_3;
            void $this$filterTo$iv$iv;
            INSTANCE = new Video();
            Iterable $this$filter$iv = TSMuxerHelper.Video.INSTANCE.getSupportedEncoders();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!MediaCodecHelper.Video.INSTANCE.getSupportedEncoders().contains(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            supportedEncoders = (List)var3_3;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0005J\u001c\u0010\f\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\n0\n0\t2\u0006\u0010\u000b\u001a\u00020\u0005J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0005R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/github/thibaultbee/streampack/utils/StreamerConfigurationHelper$Audio;", "", "()V", "supportedEncoders", "", "", "getSupportedEncoders", "()Ljava/util/List;", "getSupportedBitrates", "Landroid/util/Range;", "", "mimeType", "getSupportedInputChannelRange", "kotlin.jvm.PlatformType", "getSupportedSampleRates", "", "sdk_release"})
    public static final class Audio {
        @NotNull
        public static final Audio INSTANCE;
        @NotNull
        private static final List<String> supportedEncoders;

        private Audio() {
        }

        @NotNull
        public final List<String> getSupportedEncoders() {
            return supportedEncoders;
        }

        @NotNull
        public final Range<Integer> getSupportedInputChannelRange(@NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            return MediaCodecHelper.Audio.INSTANCE.getInputChannelRange(mimeType);
        }

        @NotNull
        public final Range<Integer> getSupportedBitrates(@NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            return MediaCodecHelper.Audio.INSTANCE.getBitrateRange(mimeType);
        }

        @NotNull
        public final int[] getSupportedSampleRates(@NotNull String mimeType) {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            return MediaCodecHelper.Audio.INSTANCE.getSupportedSampleRates(mimeType);
        }

        /*
         * WARNING - void declaration
         */
        static {
            void var3_3;
            void $this$filterTo$iv$iv;
            INSTANCE = new Audio();
            Iterable $this$filter$iv = TSMuxerHelper.Audio.INSTANCE.getSupportedEncoders();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!MediaCodecHelper.Audio.INSTANCE.getSupportedEncoders().contains(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            supportedEncoders = (List)var3_3;
        }
    }
}

