/*
 * Decompiled with CFR 0.152.
 */
package com.github.thibaultbee.streampack.utils;

import android.content.Context;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.util.Range;
import android.util.Size;
import com.github.thibaultbee.streampack.internal.sources.camera.InternalCameraExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\u0010\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0003\u001a\u0010\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0003\u001a0\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001\"\b\b\u0000\u0010\u0007*\u00020\b*\u00020\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\n2\u0006\u0010\u000b\u001a\u00020\u0002\u001a\u0019\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u000e\u001a\u0010\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0003\u001a\u0012\u0010\u0010\u001a\u00020\u0011*\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0002\u001a\u001a\u0010\u0012\u001a\u00020\u0011*\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\r\u001a\u0012\u0010\u0014\u001a\u00020\u0011*\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0002\u00a8\u0006\u0015"}, d2={"getBackCameraList", "", "", "Landroid/content/Context;", "getCameraList", "getCameraOutputSizes", "Landroid/util/Size;", "T", "", "klass", "Ljava/lang/Class;", "cameraId", "getFacingDirection", "", "(Landroid/content/Context;Ljava/lang/String;)Ljava/lang/Integer;", "getFrontCameraList", "isBackCamera", "", "isFrameRateSupported", "fps", "isFrontCamera", "sdk_release"})
public final class CameraExtensionsKt {
    @NotNull
    public static final List<String> getCameraList(@NotNull Context $this$getCameraList) {
        Intrinsics.checkNotNullParameter((Object)$this$getCameraList, (String)"<this>");
        String[] stringArray = $this$getCameraList.getSystemService("camera");
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.hardware.camera2.CameraManager");
        }
        CameraManager cameraManager = (CameraManager)stringArray;
        stringArray = cameraManager.getCameraIdList();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"cameraManager.cameraIdList");
        return ArraysKt.toList((Object[])stringArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> getBackCameraList(@NotNull Context $this$getBackCameraList) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getBackCameraList, (String)"<this>");
        Iterable $this$filter$iv = CameraExtensionsKt.getCameraList($this$getBackCameraList);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Integer n = CameraExtensionsKt.getFacingDirection($this$getBackCameraList, it);
            int n2 = 1;
            if (!(n != null && n == n2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> getFrontCameraList(@NotNull Context $this$getFrontCameraList) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getFrontCameraList, (String)"<this>");
        Iterable $this$filter$iv = CameraExtensionsKt.getCameraList($this$getFrontCameraList);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Integer n = CameraExtensionsKt.getFacingDirection($this$getFrontCameraList, it);
            boolean bl2 = false;
            if (!(n != null && n == 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final boolean isBackCamera(@NotNull Context $this$isBackCamera, @NotNull String cameraId2) {
        Intrinsics.checkNotNullParameter((Object)$this$isBackCamera, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        Integer n = CameraExtensionsKt.getFacingDirection($this$isBackCamera, cameraId2);
        int n2 = 1;
        return n != null && n == n2;
    }

    public static final boolean isFrontCamera(@NotNull Context $this$isFrontCamera, @NotNull String cameraId2) {
        Intrinsics.checkNotNullParameter((Object)$this$isFrontCamera, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        Integer n = CameraExtensionsKt.getFacingDirection($this$isFrontCamera, cameraId2);
        boolean bl = false;
        return n != null && n == 0;
    }

    @Nullable
    public static final Integer getFacingDirection(@NotNull Context $this$getFacingDirection, @NotNull String cameraId2) {
        Intrinsics.checkNotNullParameter((Object)$this$getFacingDirection, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        return (Integer)InternalCameraExtensionsKt.getCameraCharacteristics($this$getFacingDirection, cameraId2).get(CameraCharacteristics.LENS_FACING);
    }

    @NotNull
    public static final <T> List<Size> getCameraOutputSizes(@NotNull Context $this$getCameraOutputSizes, @NotNull Class<T> klass, @NotNull String cameraId2) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)$this$getCameraOutputSizes, (String)"<this>");
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)InternalCameraExtensionsKt.getCameraCharacteristics($this$getCameraOutputSizes, cameraId2).get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        List list = streamConfigurationMap == null ? null : ((objectArray = streamConfigurationMap.getOutputSizes(klass)) == null ? null : ArraysKt.toList((Object[])objectArray));
        return list == null ? CollectionsKt.emptyList() : list;
    }

    public static final boolean isFrameRateSupported(@NotNull Context $this$isFrameRateSupported, @NotNull String cameraId2, int fps) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$isFrameRateSupported, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
            Iterable $this$any$iv = InternalCameraExtensionsKt.getCameraFpsList($this$isFrameRateSupported, cameraId2);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Range it = (Range)element$iv;
                    boolean bl2 = false;
                    if (!it.contains((Comparable)Integer.valueOf(fps))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

