/*
 * Decompiled with CFR 0.152.
 */
package com.github.thibaultbee.streampack.streamers.bases;

import android.content.Context;
import androidx.annotation.RequiresPermission;
import com.github.thibaultbee.streampack.data.AudioConfig;
import com.github.thibaultbee.streampack.data.VideoConfig;
import com.github.thibaultbee.streampack.error.StreamPackError;
import com.github.thibaultbee.streampack.internal.data.Frame;
import com.github.thibaultbee.streampack.internal.data.Packet;
import com.github.thibaultbee.streampack.internal.encoders.AudioMediaCodecEncoder;
import com.github.thibaultbee.streampack.internal.encoders.IEncoderListener;
import com.github.thibaultbee.streampack.internal.encoders.MediaCodecEncoder;
import com.github.thibaultbee.streampack.internal.encoders.VideoMediaCodecEncoder;
import com.github.thibaultbee.streampack.internal.endpoints.IEndpoint;
import com.github.thibaultbee.streampack.internal.events.EventHandler;
import com.github.thibaultbee.streampack.internal.interfaces.Streamable;
import com.github.thibaultbee.streampack.internal.muxers.IMuxerListener;
import com.github.thibaultbee.streampack.internal.muxers.ts.TSMuxer;
import com.github.thibaultbee.streampack.internal.muxers.ts.data.ServiceInfo;
import com.github.thibaultbee.streampack.internal.sources.IFrameCapture;
import com.github.thibaultbee.streampack.internal.sources.ISurfaceCapture;
import com.github.thibaultbee.streampack.listeners.OnErrorListener;
import com.github.thibaultbee.streampack.logger.ILogger;
import com.github.thibaultbee.streampack.streamers.bases.BaseStreamer;
import com.github.thibaultbee.streampack.streamers.interfaces.IStreamer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0093\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007*\u0003\u001f)F\b&\u0018\u00002\u00020\u00012\u00020\u0002BE\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u0012\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0011\u0010I\u001a\u00020JH\u00a4@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010KJ\u001c\u0010L\u001a\u00020J2\b\u0010\u001b\u001a\u0004\u0018\u00010\f2\b\u0010:\u001a\u0004\u0018\u00010\tH\u0017J\b\u0010M\u001a\u00020NH$J\u0010\u0010O\u001a\u00020J2\u0006\u0010P\u001a\u00020QH\u0002J\b\u0010R\u001a\u00020JH\u0016J\b\u0010S\u001a\u00020JH\u0002J\b\u0010T\u001a\u00020JH\u0002J\b\u0010U\u001a\u00020JH\u0016J\b\u0010V\u001a\u00020JH\u0016J\b\u0010W\u001a\u00020JH\u0004R$\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00138D@DX\u0084\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0010\u0010\u001b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010 R\u0012\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010#R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010\u000f\u001a\u00020\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0010\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010*R\u001c\u0010+\u001a\u0004\u0018\u00010,X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u0014\u00101\u001a\u00020,X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010.R\u000e\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u00105\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00138D@DX\u0084\u000e\u00a2\u0006\f\u001a\u0004\b6\u0010\u0016\"\u0004\b7\u0010\u0018R\u001c\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u001c\u0010:\u001a\u0004\u0018\u00010\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R\u001c\u0010?\u001a\u0004\u0018\u00010@X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR\u0010\u0010E\u001a\u00020FX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010GR\u0012\u0010H\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010#\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006X"}, d2={"Lcom/github/thibaultbee/streampack/streamers/bases/BaseStreamer;", "Lcom/github/thibaultbee/streampack/internal/events/EventHandler;", "Lcom/github/thibaultbee/streampack/streamers/interfaces/IStreamer;", "context", "Landroid/content/Context;", "tsServiceInfo", "Lcom/github/thibaultbee/streampack/internal/muxers/ts/data/ServiceInfo;", "videoCapture", "Lcom/github/thibaultbee/streampack/internal/sources/ISurfaceCapture;", "Lcom/github/thibaultbee/streampack/data/VideoConfig;", "audioCapture", "Lcom/github/thibaultbee/streampack/internal/sources/IFrameCapture;", "Lcom/github/thibaultbee/streampack/data/AudioConfig;", "endpoint", "Lcom/github/thibaultbee/streampack/internal/endpoints/IEndpoint;", "logger", "Lcom/github/thibaultbee/streampack/logger/ILogger;", "(Landroid/content/Context;Lcom/github/thibaultbee/streampack/internal/muxers/ts/data/ServiceInfo;Lcom/github/thibaultbee/streampack/internal/sources/ISurfaceCapture;Lcom/github/thibaultbee/streampack/internal/sources/IFrameCapture;Lcom/github/thibaultbee/streampack/internal/endpoints/IEndpoint;Lcom/github/thibaultbee/streampack/logger/ILogger;)V", "value", "", "audioBitrate", "getAudioBitrate", "()I", "setAudioBitrate", "(I)V", "getAudioCapture", "()Lcom/github/thibaultbee/streampack/internal/sources/IFrameCapture;", "audioConfig", "audioEncoder", "Lcom/github/thibaultbee/streampack/internal/encoders/AudioMediaCodecEncoder;", "audioEncoderListener", "com/github/thibaultbee/streampack/streamers/bases/BaseStreamer$audioEncoderListener$1", "Lcom/github/thibaultbee/streampack/streamers/bases/BaseStreamer$audioEncoderListener$1;", "audioTsStreamId", "", "Ljava/lang/Short;", "getEndpoint", "()Lcom/github/thibaultbee/streampack/internal/endpoints/IEndpoint;", "getLogger", "()Lcom/github/thibaultbee/streampack/logger/ILogger;", "muxListener", "com/github/thibaultbee/streampack/streamers/bases/BaseStreamer$muxListener$1", "Lcom/github/thibaultbee/streampack/streamers/bases/BaseStreamer$muxListener$1;", "onErrorListener", "Lcom/github/thibaultbee/streampack/listeners/OnErrorListener;", "getOnErrorListener", "()Lcom/github/thibaultbee/streampack/listeners/OnErrorListener;", "setOnErrorListener", "(Lcom/github/thibaultbee/streampack/listeners/OnErrorListener;)V", "onInternalErrorListener", "getOnInternalErrorListener", "tsMux", "Lcom/github/thibaultbee/streampack/internal/muxers/ts/TSMuxer;", "videoBitrate", "getVideoBitrate", "setVideoBitrate", "getVideoCapture", "()Lcom/github/thibaultbee/streampack/internal/sources/ISurfaceCapture;", "videoConfig", "getVideoConfig", "()Lcom/github/thibaultbee/streampack/data/VideoConfig;", "setVideoConfig", "(Lcom/github/thibaultbee/streampack/data/VideoConfig;)V", "videoEncoder", "Lcom/github/thibaultbee/streampack/internal/encoders/VideoMediaCodecEncoder;", "getVideoEncoder", "()Lcom/github/thibaultbee/streampack/internal/encoders/VideoMediaCodecEncoder;", "setVideoEncoder", "(Lcom/github/thibaultbee/streampack/internal/encoders/VideoMediaCodecEncoder;)V", "videoEncoderListener", "com/github/thibaultbee/streampack/streamers/bases/BaseStreamer$videoEncoderListener$1", "Lcom/github/thibaultbee/streampack/streamers/bases/BaseStreamer$videoEncoderListener$1;", "videoTsStreamId", "afterResetVideo", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "configure", "onResetVideo", "", "onStreamError", "error", "Lcom/github/thibaultbee/streampack/error/StreamPackError;", "release", "resetAudio", "resetVideo", "startStream", "stopStream", "stopStreamImpl", "sdk_release"})
public abstract class BaseStreamer
extends EventHandler
implements IStreamer {
    @NotNull
    private final Context context;
    @NotNull
    private final ServiceInfo tsServiceInfo;
    @Nullable
    private final ISurfaceCapture<VideoConfig> videoCapture;
    @Nullable
    private final IFrameCapture<AudioConfig> audioCapture;
    @NotNull
    private final IEndpoint endpoint;
    @NotNull
    private final ILogger logger;
    @Nullable
    private OnErrorListener onErrorListener;
    @Nullable
    private Short audioTsStreamId;
    @Nullable
    private Short videoTsStreamId;
    @Nullable
    private VideoConfig videoConfig;
    @Nullable
    private AudioConfig audioConfig;
    @NotNull
    private final OnErrorListener onInternalErrorListener;
    @NotNull
    private final audioEncoderListener.1 audioEncoderListener;
    @NotNull
    private final videoEncoderListener.1 videoEncoderListener;
    @NotNull
    private final muxListener.1 muxListener;
    @Nullable
    private AudioMediaCodecEncoder audioEncoder;
    @Nullable
    private VideoMediaCodecEncoder videoEncoder;
    @NotNull
    private final TSMuxer tsMux;

    public BaseStreamer(@NotNull Context context, @NotNull ServiceInfo tsServiceInfo, @Nullable ISurfaceCapture<VideoConfig> videoCapture, @Nullable IFrameCapture<AudioConfig> audioCapture, @NotNull IEndpoint endpoint, @NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)tsServiceInfo, (String)"tsServiceInfo");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.context = context;
        this.tsServiceInfo = tsServiceInfo;
        this.videoCapture = videoCapture;
        this.audioCapture = audioCapture;
        this.endpoint = endpoint;
        this.logger = logger;
        this.onInternalErrorListener = new OnErrorListener(this){
            final /* synthetic */ BaseStreamer this$0;
            {
                this.this$0 = $receiver;
            }

            public void onError(@NotNull StreamPackError error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                BaseStreamer.access$onStreamError(this.this$0, error);
            }
        };
        this.audioEncoderListener = new IEncoderListener(this){
            final /* synthetic */ BaseStreamer this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public Frame onInputFrame(@NotNull ByteBuffer buffer) {
                Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
                IFrameCapture<AudioConfig> iFrameCapture = this.this$0.getAudioCapture();
                Intrinsics.checkNotNull(iFrameCapture);
                return iFrameCapture.getFrame(buffer);
            }

            public void onOutputFrame(@NotNull Frame frame) {
                Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
                Short s = BaseStreamer.access$getAudioTsStreamId$p(this.this$0);
                if (s != null) {
                    Short s2 = s;
                    BaseStreamer baseStreamer = this.this$0;
                    boolean bl = false;
                    boolean bl2 = false;
                    short it = ((Number)s2).shortValue();
                    boolean bl3 = false;
                    try {
                        BaseStreamer.access$getTsMux$p(baseStreamer).encode(frame, it);
                    }
                    catch (Exception e) {
                        throw new StreamPackError(e);
                    }
                }
            }
        };
        this.videoEncoderListener = new IEncoderListener(this){
            final /* synthetic */ BaseStreamer this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public Frame onInputFrame(@NotNull ByteBuffer buffer) {
                Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
                throw new StreamPackError(new RuntimeException("No video input on VideoEncoder"));
            }

            public void onOutputFrame(@NotNull Frame frame) {
                Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
                Short s = BaseStreamer.access$getVideoTsStreamId$p(this.this$0);
                if (s != null) {
                    Short s2 = s;
                    BaseStreamer baseStreamer = this.this$0;
                    boolean bl = false;
                    boolean bl2 = false;
                    short it = ((Number)s2).shortValue();
                    boolean bl3 = false;
                    try {
                        Long l;
                        Frame frame2 = frame;
                        long l2 = frame2.getPts();
                        ISurfaceCapture<VideoConfig> iSurfaceCapture = baseStreamer.getVideoCapture();
                        Intrinsics.checkNotNull(iSurfaceCapture);
                        frame2.setPts(l2 + iSurfaceCapture.getTimestampOffset());
                        if (frame.getDts() != null) {
                            Long l3 = frame.getDts();
                            Intrinsics.checkNotNull((Object)l3);
                            l = l3 + baseStreamer.getVideoCapture().getTimestampOffset();
                        } else {
                            l = null;
                        }
                        frame.setDts(l);
                        BaseStreamer.access$getTsMux$p(baseStreamer).encode(frame, it);
                    }
                    catch (Exception e) {
                        throw new StreamPackError(e);
                    }
                }
            }
        };
        this.muxListener = new IMuxerListener(this){
            final /* synthetic */ BaseStreamer this$0;
            {
                this.this$0 = $receiver;
            }

            public void onOutputFrame(@NotNull Packet packet) {
                Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
                try {
                    this.this$0.getEndpoint().write(packet);
                }
                catch (Exception e) {
                    throw new StreamPackError(e);
                }
            }
        };
        this.audioEncoder = this.audioCapture != null ? new AudioMediaCodecEncoder(this.audioEncoderListener, this.onInternalErrorListener, this.logger) : (AudioMediaCodecEncoder)null;
        this.videoEncoder = this.videoCapture != null ? new VideoMediaCodecEncoder(this.videoEncoderListener, this.onInternalErrorListener, this.context, this.logger) : (VideoMediaCodecEncoder)null;
        this.tsMux = new TSMuxer(this.muxListener, null, null, 6, null);
    }

    @Nullable
    protected final ISurfaceCapture<VideoConfig> getVideoCapture() {
        return this.videoCapture;
    }

    @Nullable
    protected final IFrameCapture<AudioConfig> getAudioCapture() {
        return this.audioCapture;
    }

    @NotNull
    protected final IEndpoint getEndpoint() {
        return this.endpoint;
    }

    @NotNull
    protected final ILogger getLogger() {
        return this.logger;
    }

    @Override
    @Nullable
    public OnErrorListener getOnErrorListener() {
        return this.onErrorListener;
    }

    @Override
    public void setOnErrorListener(@Nullable OnErrorListener onErrorListener) {
        this.onErrorListener = onErrorListener;
    }

    @Nullable
    protected final VideoConfig getVideoConfig() {
        return this.videoConfig;
    }

    protected final void setVideoConfig(@Nullable VideoConfig videoConfig) {
        this.videoConfig = videoConfig;
    }

    @Override
    @NotNull
    protected final OnErrorListener getOnInternalErrorListener() {
        return this.onInternalErrorListener;
    }

    private final void onStreamError(StreamPackError error) {
        try {
            this.stopStream();
            OnErrorListener onErrorListener = this.getOnErrorListener();
            if (onErrorListener != null) {
                onErrorListener.onError(error);
            }
        }
        catch (Exception e) {
            ILogger.DefaultImpls.e$default(this.logger, this, "onStreamError: Can't stop stream", null, 4, null);
        }
    }

    @Nullable
    protected final VideoMediaCodecEncoder getVideoEncoder() {
        return this.videoEncoder;
    }

    protected final void setVideoEncoder(@Nullable VideoMediaCodecEncoder videoMediaCodecEncoder) {
        this.videoEncoder = videoMediaCodecEncoder;
    }

    protected final int getAudioBitrate() {
        Integer n;
        AudioMediaCodecEncoder audioMediaCodecEncoder = this.audioEncoder;
        Integer n2 = n = audioMediaCodecEncoder == null ? null : Integer.valueOf(audioMediaCodecEncoder.getBitrate());
        if (n == null) {
            throw new UnsupportedOperationException("No audio source");
        }
        return n;
    }

    protected final void setAudioBitrate(int value) {
        Unit unit;
        Unit unit2;
        AudioMediaCodecEncoder audioMediaCodecEncoder = this.audioEncoder;
        if (audioMediaCodecEncoder == null) {
            unit2 = null;
        } else {
            AudioMediaCodecEncoder audioMediaCodecEncoder2 = audioMediaCodecEncoder;
            boolean bl = false;
            boolean bl2 = false;
            AudioMediaCodecEncoder it = audioMediaCodecEncoder2;
            boolean bl3 = false;
            it.setBitrate(value);
            unit2 = unit = Unit.INSTANCE;
        }
        if (unit == null) {
            throw new UnsupportedOperationException("No audio source");
        }
    }

    protected final int getVideoBitrate() {
        Integer n;
        VideoMediaCodecEncoder videoMediaCodecEncoder = this.videoEncoder;
        Integer n2 = n = videoMediaCodecEncoder == null ? null : Integer.valueOf(videoMediaCodecEncoder.getBitrate());
        if (n == null) {
            throw new UnsupportedOperationException("No video source");
        }
        return n;
    }

    protected final void setVideoBitrate(int value) {
        Unit unit;
        Unit unit2;
        VideoMediaCodecEncoder videoMediaCodecEncoder = this.videoEncoder;
        if (videoMediaCodecEncoder == null) {
            unit2 = null;
        } else {
            VideoMediaCodecEncoder videoMediaCodecEncoder2 = videoMediaCodecEncoder;
            boolean bl = false;
            boolean bl2 = false;
            VideoMediaCodecEncoder it = videoMediaCodecEncoder2;
            boolean bl3 = false;
            it.setBitrate(value);
            unit2 = unit = Unit.INSTANCE;
        }
        if (unit == null) {
            throw new UnsupportedOperationException("No video source");
        }
    }

    @Override
    @RequiresPermission(value="android.permission.RECORD_AUDIO")
    public void configure(@Nullable AudioConfig audioConfig, @Nullable VideoConfig videoConfig) {
        this.videoConfig = videoConfig;
        this.audioConfig = audioConfig;
        try {
            int n;
            int n2;
            Streamable<Object> streamable;
            Object it;
            boolean bl;
            boolean bl2;
            Object object;
            Object object2 = audioConfig;
            if (object2 != null) {
                object = object2;
                bl2 = false;
                bl = false;
                it = object;
                boolean bl3 = false;
                streamable = this.getAudioCapture();
                if (streamable != null) {
                    streamable.configure((AudioConfig)it);
                }
                streamable = this.audioEncoder;
                if (streamable != null) {
                    ((AudioMediaCodecEncoder)streamable).configure((AudioConfig)it);
                }
            }
            object2 = videoConfig;
            if (object2 != null) {
                object = object2;
                bl2 = false;
                bl = false;
                it = object;
                boolean bl4 = false;
                streamable = this.getVideoCapture();
                if (streamable != null) {
                    streamable.configure((AudioConfig)it);
                }
                streamable = this.getVideoEncoder();
                if (streamable != null) {
                    ((VideoMediaCodecEncoder)streamable).configure((VideoConfig)it);
                }
            }
            object2 = videoConfig;
            int n3 = object2 == null ? 0 : (n2 = ((VideoConfig)object2).getStartBitrate());
            object2 = audioConfig;
            this.endpoint.configure(n3 + (object2 == null ? 0 : (n = ((AudioConfig)object2).getStartBitrate())));
        }
        catch (Exception e) {
            this.release();
            throw new StreamPackError(e);
        }
    }

    @Override
    public void startStream() {
        try {
            String it;
            boolean bl;
            boolean bl2;
            String string;
            String string2;
            this.endpoint.startStream();
            boolean bl3 = false;
            List streams = new ArrayList();
            Streamable<VideoConfig> streamable = this.videoEncoder;
            if (streamable != null && (string2 = ((MediaCodecEncoder)streamable).getMimeType()) != null) {
                string = string2;
                bl2 = false;
                bl = false;
                it = string;
                boolean bl4 = false;
                streams.add(it);
            }
            if ((streamable = this.audioEncoder) != null && (string2 = ((MediaCodecEncoder)streamable).getMimeType()) != null) {
                string = string2;
                bl2 = false;
                bl = false;
                it = string;
                boolean bl5 = false;
                streams.add(it);
            }
            this.tsMux.addService(this.tsServiceInfo);
            this.tsMux.addStreams(this.tsServiceInfo, (List<String>)streams);
            streamable = this.videoEncoder;
            if (streamable != null && (string2 = ((MediaCodecEncoder)streamable).getMimeType()) != null) {
                string = string2;
                bl2 = false;
                bl = false;
                it = string;
                boolean bl6 = false;
                this.videoTsStreamId = this.tsMux.getStreams(it).get(0).getPid();
            }
            if ((streamable = this.audioEncoder) != null && (string2 = ((MediaCodecEncoder)streamable).getMimeType()) != null) {
                string = string2;
                bl2 = false;
                bl = false;
                it = string;
                boolean bl7 = false;
                this.audioTsStreamId = this.tsMux.getStreams(it).get(0).getPid();
            }
            if ((streamable = this.audioCapture) != null) {
                streamable.startStream();
            }
            streamable = this.audioEncoder;
            if (streamable != null) {
                ((MediaCodecEncoder)streamable).startStream();
            }
            streamable = this.videoCapture;
            if (streamable != null) {
                streamable.startStream();
            }
            streamable = this.videoEncoder;
            if (streamable != null) {
                ((MediaCodecEncoder)streamable).startStream();
            }
        }
        catch (Exception e) {
            this.stopStream();
            throw new StreamPackError(e);
        }
    }

    @Override
    public void stopStream() {
        this.stopStreamImpl();
        this.resetAudio();
        this.resetVideo();
    }

    protected final void stopStreamImpl() {
        Streamable<VideoConfig> streamable = this.videoCapture;
        if (streamable != null) {
            streamable.stopStream();
        }
        streamable = this.videoEncoder;
        if (streamable != null) {
            ((MediaCodecEncoder)streamable).stopStream();
        }
        streamable = this.audioEncoder;
        if (streamable != null) {
            ((MediaCodecEncoder)streamable).stopStream();
        }
        streamable = this.audioCapture;
        if (streamable != null) {
            streamable.stopStream();
        }
        this.tsMux.stop();
        this.endpoint.stopStream();
    }

    private final void resetAudio() {
        Object object = this.audioEncoder;
        if (object != null) {
            ((MediaCodecEncoder)object).release();
        }
        object = this.audioConfig;
        if (object != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            AudioMediaCodecEncoder audioMediaCodecEncoder = this.audioEncoder;
            if (audioMediaCodecEncoder != null) {
                audioMediaCodecEncoder.configure((AudioConfig)it);
            }
        }
    }

    protected abstract boolean onResetVideo();

    @Nullable
    protected abstract Object afterResetVideo(@NotNull Continuation<? super Unit> var1);

    private final void resetVideo() {
        boolean callAfterResetVideo = this.onResetVideo();
        VideoMediaCodecEncoder videoMediaCodecEncoder = this.videoEncoder;
        if (videoMediaCodecEncoder != null) {
            videoMediaCodecEncoder.release();
        }
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, callAfterResetVideo, null){
            int label;
            final /* synthetic */ BaseStreamer this$0;
            final /* synthetic */ boolean $callAfterResetVideo;
            {
                this.this$0 = $receiver;
                this.$callAfterResetVideo = $callAfterResetVideo;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Object object3;
                        ResultKt.throwOnFailure((Object)object);
                        Object object4 = this.this$0.getVideoConfig();
                        if (object4 != null) {
                            object3 = object4;
                            BaseStreamer baseStreamer = this.this$0;
                            boolean bl = false;
                            boolean bl2 = false;
                            VideoConfig it = object3;
                            boolean bl3 = false;
                            VideoMediaCodecEncoder videoMediaCodecEncoder = baseStreamer.getVideoEncoder();
                            if (videoMediaCodecEncoder != null) {
                                videoMediaCodecEncoder.configure(it);
                            }
                        }
                        object4 = this.this$0.getVideoCapture();
                        if (object4 != null) {
                            object3 = this.this$0.getVideoEncoder();
                            object4.setEncoderSurface(object3 == null ? null : ((VideoMediaCodecEncoder)object3).getInputSurface());
                        }
                        if (!this.$callAfterResetVideo) return Unit.INSTANCE;
                        this.label = 1;
                        Object object5 = this.this$0.afterResetVideo((Continuation<? super Unit>)((Continuation)this));
                        if (object5 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object5 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    @Override
    public void release() {
        Streamable<AudioConfig> streamable = this.audioEncoder;
        if (streamable != null) {
            ((MediaCodecEncoder)streamable).release();
        }
        streamable = this.videoEncoder;
        if (streamable != null) {
            ((VideoMediaCodecEncoder)streamable).release();
        }
        streamable = this.audioCapture;
        if (streamable != null) {
            streamable.release();
        }
        streamable = this.videoCapture;
        if (streamable != null) {
            streamable.release();
        }
        this.endpoint.release();
    }

    public static final /* synthetic */ void access$onStreamError(BaseStreamer $this, StreamPackError error) {
        $this.onStreamError(error);
    }

    public static final /* synthetic */ Short access$getAudioTsStreamId$p(BaseStreamer $this) {
        return $this.audioTsStreamId;
    }

    public static final /* synthetic */ TSMuxer access$getTsMux$p(BaseStreamer $this) {
        return $this.tsMux;
    }

    public static final /* synthetic */ Short access$getVideoTsStreamId$p(BaseStreamer $this) {
        return $this.videoTsStreamId;
    }
}

