/*
 * Decompiled with CFR 0.152.
 */
package com.github.thibaultbee.streampack.internal.sources.screen;

import android.content.Context;
import android.content.Intent;
import android.hardware.display.VirtualDisplay;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.view.Surface;
import androidx.activity.result.ActivityResult;
import com.github.thibaultbee.streampack.data.VideoConfig;
import com.github.thibaultbee.streampack.error.StreamPackError;
import com.github.thibaultbee.streampack.internal.sources.ISurfaceCapture;
import com.github.thibaultbee.streampack.internal.sources.screen.ScreenCapture;
import com.github.thibaultbee.streampack.listeners.OnErrorListener;
import com.github.thibaultbee.streampack.logger.ILogger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006*\u0002\u0017)\u0018\u0000 52\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00015B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u0002H\u0016J\b\u00102\u001a\u000200H\u0016J\b\u00103\u001a\u000200H\u0016J\b\u00104\u001a\u000200H\u0016R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0010\u0010%\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010*R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/github/thibaultbee/streampack/internal/sources/screen/ScreenCapture;", "Lcom/github/thibaultbee/streampack/internal/sources/ISurfaceCapture;", "Lcom/github/thibaultbee/streampack/data/VideoConfig;", "context", "Landroid/content/Context;", "logger", "Lcom/github/thibaultbee/streampack/logger/ILogger;", "(Landroid/content/Context;Lcom/github/thibaultbee/streampack/logger/ILogger;)V", "activityResult", "Landroidx/activity/result/ActivityResult;", "getActivityResult", "()Landroidx/activity/result/ActivityResult;", "setActivityResult", "(Landroidx/activity/result/ActivityResult;)V", "encoderSurface", "Landroid/view/Surface;", "getEncoderSurface", "()Landroid/view/Surface;", "setEncoderSurface", "(Landroid/view/Surface;)V", "mediaProjection", "Landroid/media/projection/MediaProjection;", "mediaProjectionCallback", "com/github/thibaultbee/streampack/internal/sources/screen/ScreenCapture$mediaProjectionCallback$1", "Lcom/github/thibaultbee/streampack/internal/sources/screen/ScreenCapture$mediaProjectionCallback$1;", "mediaProjectionManager", "Landroid/media/projection/MediaProjectionManager;", "onErrorListener", "Lcom/github/thibaultbee/streampack/listeners/OnErrorListener;", "getOnErrorListener", "()Lcom/github/thibaultbee/streampack/listeners/OnErrorListener;", "setOnErrorListener", "(Lcom/github/thibaultbee/streampack/listeners/OnErrorListener;)V", "timestampOffset", "", "getTimestampOffset", "()J", "videoConfig", "virtualDisplay", "Landroid/hardware/display/VirtualDisplay;", "virtualDisplayCallback", "com/github/thibaultbee/streampack/internal/sources/screen/ScreenCapture$virtualDisplayCallback$1", "Lcom/github/thibaultbee/streampack/internal/sources/screen/ScreenCapture$virtualDisplayCallback$1;", "virtualDisplayHandler", "Landroid/os/Handler;", "virtualDisplayThread", "Landroid/os/HandlerThread;", "configure", "", "config", "release", "startStream", "stopStream", "Companion", "sdk_release"})
public final class ScreenCapture
implements ISurfaceCapture<VideoConfig> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Surface encoderSurface;
    private final long timestampOffset;
    @Nullable
    private MediaProjection mediaProjection;
    @Nullable
    private ActivityResult activityResult;
    @Nullable
    private OnErrorListener onErrorListener;
    @NotNull
    private final MediaProjectionManager mediaProjectionManager;
    @Nullable
    private VirtualDisplay virtualDisplay;
    @Nullable
    private VideoConfig videoConfig;
    @NotNull
    private final HandlerThread virtualDisplayThread;
    @NotNull
    private final Handler virtualDisplayHandler;
    @NotNull
    private final virtualDisplayCallback.1 virtualDisplayCallback;
    @NotNull
    private final mediaProjectionCallback.1 mediaProjectionCallback;
    @NotNull
    private static final String VIRTUAL_DISPLAY_NAME = "StreamPackScreenCapture";

    /*
     * WARNING - void declaration
     */
    public ScreenCapture(@NotNull Context context, @NotNull ILogger logger) {
        void $this$virtualDisplayThread_u24lambda_u2d0;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Object object = context.getSystemService("media_projection");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.media.projection.MediaProjectionManager");
        }
        this.mediaProjectionManager = (MediaProjectionManager)object;
        object = new HandlerThread("VirtualDisplayThread");
        boolean bl = false;
        boolean bl2 = false;
        Object object2 = object;
        ScreenCapture screenCapture = this;
        boolean bl3 = false;
        $this$virtualDisplayThread_u24lambda_u2d0.start();
        Unit unit = Unit.INSTANCE;
        screenCapture.virtualDisplayThread = object;
        this.virtualDisplayHandler = new Handler(this.virtualDisplayThread.getLooper());
        this.virtualDisplayCallback = new VirtualDisplay.Callback(logger, this){
            final /* synthetic */ ILogger $logger;
            final /* synthetic */ ScreenCapture this$0;
            {
                this.$logger = $logger;
                this.this$0 = $receiver;
            }

            public void onPaused() {
                super.onPaused();
                ILogger.DefaultImpls.i$default(this.$logger, this.this$0, "onPaused", null, 4, null);
            }

            public void onStopped() {
                super.onStopped();
                ILogger.DefaultImpls.i$default(this.$logger, this.this$0, "onStopped", null, 4, null);
                OnErrorListener onErrorListener = this.this$0.getOnErrorListener();
                if (onErrorListener != null) {
                    onErrorListener.onError(new StreamPackError("Screen capture has been stopped"));
                }
            }
        };
        this.mediaProjectionCallback = new MediaProjection.Callback(logger, this){
            final /* synthetic */ ILogger $logger;
            final /* synthetic */ ScreenCapture this$0;
            {
                this.$logger = $logger;
                this.this$0 = $receiver;
            }

            public void onStop() {
                super.onStop();
                ILogger.DefaultImpls.i$default(this.$logger, this.this$0, "onStop", null, 4, null);
                OnErrorListener onErrorListener = this.this$0.getOnErrorListener();
                if (onErrorListener != null) {
                    onErrorListener.onError(new StreamPackError("Screen capture has been stopped"));
                }
            }
        };
    }

    @Override
    @Nullable
    public Surface getEncoderSurface() {
        return this.encoderSurface;
    }

    @Override
    public void setEncoderSurface(@Nullable Surface surface) {
        this.encoderSurface = surface;
    }

    @Override
    public long getTimestampOffset() {
        return this.timestampOffset;
    }

    @Nullable
    public final ActivityResult getActivityResult() {
        return this.activityResult;
    }

    public final void setActivityResult(@Nullable ActivityResult activityResult) {
        this.activityResult = activityResult;
    }

    @Nullable
    public final OnErrorListener getOnErrorListener() {
        return this.onErrorListener;
    }

    public final void setOnErrorListener(@Nullable OnErrorListener onErrorListener) {
        this.onErrorListener = onErrorListener;
    }

    @Override
    public void configure(@NotNull VideoConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.videoConfig = config;
    }

    @Override
    public void startStream() {
        Object it;
        boolean bl;
        MediaProjection mediaProjection;
        boolean bl2 = this.videoConfig != null;
        boolean bl3 = false;
        boolean bl4 = false;
        if (!bl2) {
            boolean bl5 = false;
            String string = "Video has not been configured!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl2 = this.activityResult != null;
        bl3 = false;
        bl4 = false;
        if (!bl2) {
            boolean bl6 = false;
            String string = "Activity result must be set!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ScreenCapture screenCapture = this;
        Object object = this.activityResult;
        if (object == null) {
            mediaProjection = null;
        } else {
            ActivityResult activityResult = object;
            bl4 = false;
            bl = false;
            ActivityResult activityResult2 = activityResult;
            ScreenCapture screenCapture2 = screenCapture;
            boolean bl7 = false;
            int n = it.getResultCode();
            Intent intent = it.getData();
            Intrinsics.checkNotNull((Object)intent);
            MediaProjection mediaProjection2 = this.mediaProjectionManager.getMediaProjection(n, intent);
            screenCapture = screenCapture2;
            mediaProjection = mediaProjection2;
        }
        screenCapture.mediaProjection = mediaProjection;
        object = this.videoConfig;
        if (object != null) {
            Object object2 = object;
            bl4 = false;
            bl = false;
            it = object2;
            boolean bl8 = false;
            MediaProjection mediaProjection3 = this.mediaProjection;
            this.virtualDisplay = mediaProjection3 == null ? null : mediaProjection3.createVirtualDisplay(VIRTUAL_DISPLAY_NAME, ((VideoConfig)it).getResolution().getWidth(), ((VideoConfig)it).getResolution().getHeight(), 320, 16, this.getEncoderSurface(), (VirtualDisplay.Callback)this.virtualDisplayCallback, this.virtualDisplayHandler);
            mediaProjection3 = this.mediaProjection;
            if (mediaProjection3 != null) {
                mediaProjection3.registerCallback((MediaProjection.Callback)this.mediaProjectionCallback, this.virtualDisplayHandler);
            }
        }
    }

    @Override
    public void stopStream() {
        VirtualDisplay virtualDisplay = this.virtualDisplay;
        if (virtualDisplay != null) {
            virtualDisplay.release();
        }
        this.virtualDisplay = null;
        virtualDisplay = this.mediaProjection;
        if (virtualDisplay != null) {
            virtualDisplay.stop();
        }
        this.mediaProjection = null;
    }

    @Override
    public void release() {
        this.virtualDisplayThread.quitSafely();
        try {
            this.virtualDisplayThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/github/thibaultbee/streampack/internal/sources/screen/ScreenCapture$Companion;", "", "()V", "VIRTUAL_DISPLAY_NAME", "", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

