/*
 * Decompiled with CFR 0.152.
 */
package com.github.thibaultbee.streampack.internal.sources.camera;

import android.content.Context;
import android.hardware.camera2.CameraDevice;
import android.view.Surface;
import androidx.annotation.RequiresPermission;
import com.github.thibaultbee.streampack.data.VideoConfig;
import com.github.thibaultbee.streampack.internal.sources.ISurfaceCapture;
import com.github.thibaultbee.streampack.internal.sources.camera.CameraCapture;
import com.github.thibaultbee.streampack.internal.sources.camera.CameraController;
import com.github.thibaultbee.streampack.internal.sources.camera.CameraHelper;
import com.github.thibaultbee.streampack.logger.ILogger;
import com.github.thibaultbee.streampack.utils.CameraExtensionsKt;
import com.github.thibaultbee.streampack.utils.CameraSettings;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u00020.2\u0006\u00100\u001a\u00020\u0002H\u0016J\b\u00101\u001a\u00020.H\u0016J%\u00102\u001a\u00020.2\b\b\u0002\u0010\f\u001a\u00020\u000b2\b\b\u0002\u00103\u001a\u00020\u001aH\u0087@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00104J\b\u00105\u001a\u00020.H\u0016J\u0006\u00106\u001a\u00020.J\b\u00107\u001a\u00020.H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8F@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u001aX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010 \u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0014\"\u0004\b\"\u0010\u0016R\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020*X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00068"}, d2={"Lcom/github/thibaultbee/streampack/internal/sources/camera/CameraCapture;", "Lcom/github/thibaultbee/streampack/internal/sources/ISurfaceCapture;", "Lcom/github/thibaultbee/streampack/data/VideoConfig;", "context", "Landroid/content/Context;", "logger", "Lcom/github/thibaultbee/streampack/logger/ILogger;", "(Landroid/content/Context;Lcom/github/thibaultbee/streampack/logger/ILogger;)V", "cameraController", "Lcom/github/thibaultbee/streampack/internal/sources/camera/CameraController;", "value", "", "cameraId", "getCameraId", "()Ljava/lang/String;", "setCameraId", "(Ljava/lang/String;)V", "encoderSurface", "Landroid/view/Surface;", "getEncoderSurface", "()Landroid/view/Surface;", "setEncoderSurface", "(Landroid/view/Surface;)V", "fps", "", "isPreviewing", "", "isPreviewing$sdk_release", "()Z", "setPreviewing$sdk_release", "(Z)V", "isStreaming", "previewSurface", "getPreviewSurface", "setPreviewSurface", "settings", "Lcom/github/thibaultbee/streampack/utils/CameraSettings;", "getSettings", "()Lcom/github/thibaultbee/streampack/utils/CameraSettings;", "setSettings", "(Lcom/github/thibaultbee/streampack/utils/CameraSettings;)V", "timestampOffset", "", "getTimestampOffset", "()J", "checkStream", "", "configure", "config", "release", "startPreview", "restartStream", "(Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "startStream", "stopPreview", "stopStream", "sdk_release"})
public final class CameraCapture
implements ISurfaceCapture<VideoConfig> {
    @NotNull
    private final Context context;
    @Nullable
    private Surface previewSurface;
    @Nullable
    private Surface encoderSurface;
    @NotNull
    private String cameraId;
    @NotNull
    private CameraController cameraController;
    @NotNull
    private CameraSettings settings;
    private final long timestampOffset;
    private int fps;
    private boolean isStreaming;
    private boolean isPreviewing;

    public CameraCapture(@NotNull Context context, @NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.context = context;
        this.cameraId = "0";
        this.cameraController = new CameraController(this.context, null, logger, 2, null);
        this.settings = new CameraSettings(this.cameraController);
        this.timestampOffset = CameraHelper.INSTANCE.getTimeOffsetToMonoClock(this.context, this.getCameraId());
        this.fps = 30;
    }

    @Nullable
    public final Surface getPreviewSurface() {
        return this.previewSurface;
    }

    public final void setPreviewSurface(@Nullable Surface surface) {
        this.previewSurface = surface;
    }

    @Override
    @Nullable
    public Surface getEncoderSurface() {
        return this.encoderSurface;
    }

    @Override
    public void setEncoderSurface(@Nullable Surface surface) {
        this.encoderSurface = surface;
    }

    @NotNull
    public final String getCameraId() {
        CameraDevice cameraDevice = this.cameraController.getCamera();
        String string = cameraDevice == null ? null : cameraDevice.getId();
        return string == null ? this.cameraId : string;
    }

    @RequiresPermission(value="android.permission.CAMERA")
    public final void setCameraId(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!CameraExtensionsKt.isFrameRateSupported(this.context, value, this.fps)) {
            throw new UnsupportedOperationException("Camera " + value + " does not support " + this.fps + " fps");
        }
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, value, null){
            int label;
            final /* synthetic */ CameraCapture this$0;
            final /* synthetic */ String $value;
            {
                this.this$0 = $receiver;
                this.$value = $value;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        boolean restartStream = CameraCapture.access$isStreaming$p(this.this$0);
                        this.this$0.stopPreview();
                        this.label = 1;
                        Object object3 = this.this$0.startPreview(this.$value, restartStream, (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        this.cameraId = value;
    }

    @NotNull
    public final CameraSettings getSettings() {
        return this.settings;
    }

    public final void setSettings(@NotNull CameraSettings cameraSettings) {
        Intrinsics.checkNotNullParameter((Object)cameraSettings, (String)"<set-?>");
        this.settings = cameraSettings;
    }

    @Override
    public long getTimestampOffset() {
        return this.timestampOffset;
    }

    public final boolean isPreviewing$sdk_release() {
        return this.isPreviewing;
    }

    public final void setPreviewing$sdk_release(boolean bl) {
        this.isPreviewing = bl;
    }

    @Override
    public void configure(@NotNull VideoConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.fps = config.getFps();
    }

    /*
     * Unable to fully structure code
     */
    @RequiresPermission(value="android.permission.CAMERA")
    @Nullable
    public final Object startPreview(@NotNull String var1_1, boolean var2_2, @NotNull Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof startPreview.1)) ** GOTO lbl-1000
        var12_4 = var3_3;
        if ((var12_4.label & -2147483648) != 0) {
            var12_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ CameraCapture this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.startPreview(null, false, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var13_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                targets = new Ref.ObjectRef();
                var5_8 = false;
                targets.element = new ArrayList<E>();
                var5_9 = this.getPreviewSurface();
                if (var5_9 != null) {
                    var6_12 = var5_9;
                    var7_13 = false;
                    var8_14 = false;
                    it = var6_12;
                    $i$a$-let-CameraCapture$startPreview$2 = false;
                    Boxing.boxBoolean((boolean)((List)targets.element).add(it));
                }
                var5_9 = this.getEncoderSurface();
                if (var5_9 != null) {
                    var6_12 = var5_9;
                    var7_13 = false;
                    var8_14 = false;
                    it = var6_12;
                    $i$a$-let-CameraCapture$startPreview$3 = false;
                    Boxing.boxBoolean((boolean)((List)targets.element).add(it));
                }
                $continuation.L$0 = this;
                $continuation.L$1 = targets;
                $continuation.Z$0 = restartStream;
                $continuation.label = 1;
                v0 = this.cameraController.startCamera((String)cameraId, (List)targets.element, (Continuation<? super Unit>)$continuation);
                if (v0 == var13_6) {
                    return var13_6;
                }
                ** GOTO lbl49
            }
            case 1: {
                restartStream = $continuation.Z$0;
                targets = (Ref.ObjectRef)$continuation.L$1;
                this = (CameraCapture)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl49:
                // 2 sources

                var5_10 = false;
                targets.element = new ArrayList<E>();
                var5_11 = this.getPreviewSurface();
                if (var5_11 != null) {
                    var6_12 = var5_11;
                    var7_13 = false;
                    var8_14 = false;
                    it = var6_12;
                    $i$a$-let-CameraCapture$startPreview$4 = false;
                    Boxing.boxBoolean((boolean)((List)targets.element).add(it));
                }
                if (restartStream && (var5_11 = this.getEncoderSurface()) != null) {
                    var6_12 = var5_11;
                    var7_13 = false;
                    var8_14 = false;
                    it = var6_12;
                    $i$a$-let-CameraCapture$startPreview$5 = false;
                    Boxing.boxBoolean((boolean)((List)targets.element).add(it));
                }
                this.cameraController.startRequestSession(this.fps, (List)targets.element);
                this.setPreviewing$sdk_release(true);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object startPreview$default(CameraCapture cameraCapture, String string, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            string = cameraCapture.getCameraId();
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return cameraCapture.startPreview(string, bl, (Continuation<? super Unit>)continuation);
    }

    public final void stopPreview() {
        this.isPreviewing = false;
        this.cameraController.stopCamera();
    }

    private final void checkStream() {
        boolean bl = this.getEncoderSurface() != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "encoder surface must not be null";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public void startStream() {
        this.checkStream();
        Surface surface = this.getEncoderSurface();
        Intrinsics.checkNotNull((Object)surface);
        this.cameraController.addTarget(surface);
        this.isStreaming = true;
    }

    @Override
    public void stopStream() {
        if (this.isStreaming) {
            this.checkStream();
            this.isStreaming = false;
            Surface surface = this.getEncoderSurface();
            Intrinsics.checkNotNull((Object)surface);
            this.cameraController.removeTarget(surface);
        }
    }

    @Override
    public void release() {
        this.cameraController.release();
    }

    public static final /* synthetic */ boolean access$isStreaming$p(CameraCapture $this) {
        return $this.isStreaming;
    }
}

