/*
 * Decompiled with CFR 0.152.
 */
package com.github.thibaultbee.streampack.internal.sources;

import android.media.AudioRecord;
import android.media.AudioTimestamp;
import android.media.audiofx.AcousticEchoCanceler;
import android.media.audiofx.NoiseSuppressor;
import android.os.Build;
import androidx.annotation.RequiresPermission;
import com.github.thibaultbee.streampack.data.AudioConfig;
import com.github.thibaultbee.streampack.internal.data.Frame;
import com.github.thibaultbee.streampack.internal.sources.IFrameCapture;
import com.github.thibaultbee.streampack.internal.utils.TimeUtils;
import com.github.thibaultbee.streampack.logger.ILogger;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0017J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u000fH\u0016J\b\u0010\u001a\u001a\u00020\u000fH\u0016J\b\u0010\u001b\u001a\u00020\u000fH\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001c"}, d2={"Lcom/github/thibaultbee/streampack/internal/sources/AudioCapture;", "Lcom/github/thibaultbee/streampack/internal/sources/IFrameCapture;", "Lcom/github/thibaultbee/streampack/data/AudioConfig;", "logger", "Lcom/github/thibaultbee/streampack/logger/ILogger;", "(Lcom/github/thibaultbee/streampack/logger/ILogger;)V", "audioRecord", "Landroid/media/AudioRecord;", "getLogger", "()Lcom/github/thibaultbee/streampack/logger/ILogger;", "audioRecordErrorToString", "", "audioRecordError", "", "configure", "", "config", "getFrame", "Lcom/github/thibaultbee/streampack/internal/data/Frame;", "buffer", "Ljava/nio/ByteBuffer;", "getTimestamp", "", "isRunning", "", "release", "startStream", "stopStream", "sdk_release"})
public final class AudioCapture
implements IFrameCapture<AudioConfig> {
    @NotNull
    private final ILogger logger;
    @Nullable
    private AudioRecord audioRecord;

    public AudioCapture(@NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
    }

    @NotNull
    public final ILogger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @RequiresPermission(value="android.permission.RECORD_AUDIO")
    public void configure(@NotNull AudioConfig config) {
        void it;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        int bufferSize = AudioRecord.getMinBufferSize((int)config.getSampleRate(), (int)config.getChannelConfig(), (int)config.getByteFormat());
        if (bufferSize <= 0) {
            throw new IllegalArgumentException(this.audioRecordErrorToString(bufferSize));
        }
        AudioRecord audioRecord = new AudioRecord(0, config.getSampleRate(), config.getChannelConfig(), config.getByteFormat(), bufferSize);
        boolean bl = false;
        boolean bl2 = false;
        AudioRecord audioRecord2 = audioRecord;
        AudioCapture audioCapture = this;
        boolean bl3 = false;
        if (config.getEnableEchoCanceler()) {
            if (AcousticEchoCanceler.isAvailable()) {
                AcousticEchoCanceler.create((int)it.getAudioSessionId()).setEnabled(true);
            } else {
                ILogger.DefaultImpls.e$default(this.getLogger(), this, "Acoustic echo canceler is not available", null, 4, null);
            }
        }
        if (config.getEnableNoiseSuppressor()) {
            if (NoiseSuppressor.isAvailable()) {
                NoiseSuppressor.create((int)it.getAudioSessionId()).setEnabled(true);
            } else {
                ILogger.DefaultImpls.e$default(this.getLogger(), this, "Noise suppressor is not available", null, 4, null);
            }
        }
        Unit unit = Unit.INSTANCE;
        audioCapture.audioRecord = audioRecord;
        audioRecord = this.audioRecord;
        if (!(audioRecord == null ? false : audioRecord.getState() == 1)) {
            throw new IllegalArgumentException("Failed to initialized AudioRecord");
        }
    }

    @Override
    public void startStream() {
        Unit unit;
        Unit unit2;
        AudioRecord audioRecord = this.audioRecord;
        if (audioRecord == null) {
            unit2 = null;
        } else {
            AudioRecord audioRecord2 = audioRecord;
            boolean bl = false;
            boolean bl2 = false;
            AudioRecord it = audioRecord2;
            boolean bl3 = false;
            it.startRecording();
            if (!this.isRunning()) {
                throw new IllegalStateException("AudioCapture: failed to start recording");
            }
            unit2 = unit = Unit.INSTANCE;
        }
        if (unit == null) {
            throw new IllegalStateException("AudioCapture: run: : No audioRecorder");
        }
    }

    private final boolean isRunning() {
        AudioRecord audioRecord = this.audioRecord;
        return audioRecord == null ? false : audioRecord.getRecordingState() == 3;
    }

    @Override
    public void stopStream() {
        if (!this.isRunning()) {
            ILogger.DefaultImpls.d$default(this.logger, this, "Not running", null, 4, null);
            return;
        }
        AudioRecord audioRecord = this.audioRecord;
        if (audioRecord != null) {
            audioRecord.stop();
        }
    }

    @Override
    public void release() {
        AudioRecord audioRecord = this.audioRecord;
        if (audioRecord != null) {
            audioRecord.release();
        }
        this.audioRecord = null;
    }

    private final long getTimestamp(AudioRecord audioRecord) {
        AudioTimestamp timestampOut = new AudioTimestamp();
        long timestamp = -1L;
        if (Build.VERSION.SDK_INT >= 24 && audioRecord.getTimestamp(timestampOut, 0) == 0) {
            timestamp = timestampOut.nanoTime / (long)1000;
        }
        if (timestamp < 0L) {
            timestamp = TimeUtils.INSTANCE.currentTime();
        }
        return timestamp;
    }

    @Override
    @NotNull
    public Frame getFrame(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        AudioRecord audioRecord = this.audioRecord;
        if (audioRecord != null) {
            AudioRecord audioRecord2 = audioRecord;
            boolean bl = false;
            boolean bl2 = false;
            AudioRecord it = audioRecord2;
            boolean bl3 = false;
            int length = it.read(buffer, buffer.remaining());
            if (length >= 0) {
                return new Frame(buffer, "audio/raw", this.getTimestamp(it), null, false, null, 56, null);
            }
            throw new IllegalArgumentException(this.audioRecordErrorToString(length));
        }
        Object var2_9 = null;
        throw new IllegalStateException("AudioCapture: getFrame: No audioRecorder");
    }

    private final String audioRecordErrorToString(int audioRecordError) {
        String string;
        int n = audioRecordError;
        switch (n) {
            case -3: {
                string = "AudioRecord returns an invalid operation error";
                break;
            }
            case -2: {
                string = "AudioRecord returns a bad value error";
                break;
            }
            case -6: {
                string = "AudioRecord returns a dead object error";
                break;
            }
            default: {
                string = Intrinsics.stringPlus((String)"Unknown audio record error: ", (Object)audioRecordError);
            }
        }
        return string;
    }
}

