/*
 * Decompiled with CFR 0.152.
 */
package com.github.thibaultbee.streampack.internal.muxers.ts.packets;

import com.github.thibaultbee.streampack.internal.bitbuffer.BitBuffer;
import com.github.thibaultbee.streampack.internal.muxers.IMuxerListener;
import com.github.thibaultbee.streampack.internal.muxers.ts.data.ITSElement;
import com.github.thibaultbee.streampack.internal.muxers.ts.data.Service;
import com.github.thibaultbee.streampack.internal.muxers.ts.data.Stream;
import com.github.thibaultbee.streampack.internal.muxers.ts.packets.Psi;
import java.nio.ByteBuffer;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0002\u001d\u001eB5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0006\u0010\u001b\u001a\u00020\u001cR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001f"}, d2={"Lcom/github/thibaultbee/streampack/internal/muxers/ts/packets/Pmt;", "Lcom/github/thibaultbee/streampack/internal/muxers/ts/packets/Psi;", "Lcom/github/thibaultbee/streampack/internal/muxers/ts/data/ITSElement;", "muxerListener", "Lcom/github/thibaultbee/streampack/internal/muxers/IMuxerListener;", "service", "Lcom/github/thibaultbee/streampack/internal/muxers/ts/data/Service;", "streams", "", "Lcom/github/thibaultbee/streampack/internal/muxers/ts/data/Stream;", "pid", "", "versionNumber", "", "(Lcom/github/thibaultbee/streampack/internal/muxers/IMuxerListener;Lcom/github/thibaultbee/streampack/internal/muxers/ts/data/Service;Ljava/util/List;SB)V", "bitSize", "", "getBitSize", "()I", "size", "getSize", "getStreams", "()Ljava/util/List;", "setStreams", "(Ljava/util/List;)V", "toByteBuffer", "Ljava/nio/ByteBuffer;", "write", "", "Companion", "StreamType", "sdk_release"})
public final class Pmt
extends Psi
implements ITSElement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Service service;
    @NotNull
    private List<Stream> streams;
    public static final byte TID = 2;

    public Pmt(@NotNull IMuxerListener muxerListener, @NotNull Service service, @NotNull List<Stream> streams, short pid, byte versionNumber) {
        Intrinsics.checkNotNullParameter((Object)muxerListener, (String)"muxerListener");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter(streams, (String)"streams");
        super(muxerListener, pid, (byte)2, true, false, service.getInfo().getId(), versionNumber, (byte)0, (byte)0, 384, null);
        this.service = service;
        this.streams = streams;
    }

    public /* synthetic */ Pmt(IMuxerListener iMuxerListener, Service service, List list, short s, byte by, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            by = 0;
        }
        this(iMuxerListener, service, list, s, by);
    }

    @NotNull
    public final List<Stream> getStreams() {
        return this.streams;
    }

    public final void setStreams(@NotNull List<Stream> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.streams = list;
    }

    @Override
    public int getBitSize() {
        return 32 + 40 * this.streams.size();
    }

    @Override
    public int getSize() {
        return this.getBitSize() / 8;
    }

    public final void write() {
        if (this.service.getPcrPid() != null) {
            this.write(this.toByteBuffer());
        }
    }

    @Override
    @NotNull
    public ByteBuffer toByteBuffer() {
        BitBuffer buffer = BitBuffer.Companion.allocate((long)this.getBitSize());
        BitBuffer.put$default(buffer, 7, 3, null, 4, null);
        Short s = this.service.getPcrPid();
        Intrinsics.checkNotNull((Object)s);
        BitBuffer.put$default(buffer, s, 13, null, 4, null);
        BitBuffer.put$default(buffer, 15, 4, null, 4, null);
        BitBuffer.put$default(buffer, 0, 2, null, 4, null);
        BitBuffer.put$default(buffer, 0, 10, null, 4, null);
        Iterable $this$forEach$iv = this.streams;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Stream it = (Stream)element$iv;
            boolean bl = false;
            buffer.put(StreamType.Companion.fromMimeType(it.getMimeType()).getValue(), 8);
            BitBuffer.put$default(buffer, 7, 3, null, 4, null);
            BitBuffer.put$default(buffer, it.getPid(), 13, null, 4, null);
            BitBuffer.put$default(buffer, 15, 4, null, 4, null);
            BitBuffer.put$default(buffer, 0, 2, null, 4, null);
            BitBuffer.put$default(buffer, 0, 10, null, 4, null);
        }
        return buffer.toByteBuffer();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/github/thibaultbee/streampack/internal/muxers/ts/packets/Pmt$Companion;", "", "()V", "TID", "", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0018\b\u0086\u0001\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001aB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019\u00a8\u0006\u001b"}, d2={"Lcom/github/thibaultbee/streampack/internal/muxers/ts/packets/Pmt$StreamType;", "", "value", "", "(Ljava/lang/String;IB)V", "getValue", "()B", "VIDEO_MPEG1", "VIDEO_MPEG2", "AUDIO_MPEG1", "AUDIO_MPEG2", "PRIVATE_SECTION", "PRIVATE_DATA", "AUDIO_AAC", "AUDIO_AAC_LATM", "VIDEO_MPEG4", "METADATA", "VIDEO_H264", "VIDEO_HEVC", "VIDEO_CAVS", "VIDEO_VC1", "VIDEO_DIRAC", "AUDIO_AC3", "AUDIO_DTS", "AUDIO_TRUEHD", "AUDIO_EAC3", "Companion", "sdk_release"})
    public static final class StreamType
    extends Enum<StreamType> {
        @NotNull
        public static final Companion Companion;
        private final byte value;
        public static final /* enum */ StreamType VIDEO_MPEG1;
        public static final /* enum */ StreamType VIDEO_MPEG2;
        public static final /* enum */ StreamType AUDIO_MPEG1;
        public static final /* enum */ StreamType AUDIO_MPEG2;
        public static final /* enum */ StreamType PRIVATE_SECTION;
        public static final /* enum */ StreamType PRIVATE_DATA;
        public static final /* enum */ StreamType AUDIO_AAC;
        public static final /* enum */ StreamType AUDIO_AAC_LATM;
        public static final /* enum */ StreamType VIDEO_MPEG4;
        public static final /* enum */ StreamType METADATA;
        public static final /* enum */ StreamType VIDEO_H264;
        public static final /* enum */ StreamType VIDEO_HEVC;
        public static final /* enum */ StreamType VIDEO_CAVS;
        public static final /* enum */ StreamType VIDEO_VC1;
        public static final /* enum */ StreamType VIDEO_DIRAC;
        public static final /* enum */ StreamType AUDIO_AC3;
        public static final /* enum */ StreamType AUDIO_DTS;
        public static final /* enum */ StreamType AUDIO_TRUEHD;
        public static final /* enum */ StreamType AUDIO_EAC3;
        private static final /* synthetic */ StreamType[] $VALUES;

        private StreamType(byte value) {
            this.value = value;
        }

        public final byte getValue() {
            return this.value;
        }

        public static StreamType[] values() {
            return (StreamType[])$VALUES.clone();
        }

        public static StreamType valueOf(String value) {
            return Enum.valueOf(StreamType.class, value);
        }

        static {
            VIDEO_MPEG1 = new StreamType(1);
            VIDEO_MPEG2 = new StreamType(2);
            AUDIO_MPEG1 = new StreamType(3);
            AUDIO_MPEG2 = new StreamType(4);
            PRIVATE_SECTION = new StreamType(5);
            PRIVATE_DATA = new StreamType(6);
            AUDIO_AAC = new StreamType(15);
            AUDIO_AAC_LATM = new StreamType(17);
            VIDEO_MPEG4 = new StreamType(16);
            METADATA = new StreamType(21);
            VIDEO_H264 = new StreamType(27);
            VIDEO_HEVC = new StreamType(36);
            VIDEO_CAVS = new StreamType(66);
            VIDEO_VC1 = new StreamType(-22);
            VIDEO_DIRAC = new StreamType(-47);
            AUDIO_AC3 = new StreamType(-127);
            AUDIO_DTS = new StreamType(-126);
            AUDIO_TRUEHD = new StreamType(-125);
            AUDIO_EAC3 = new StreamType(-121);
            $VALUES = streamTypeArray = new StreamType[]{StreamType.VIDEO_MPEG1, StreamType.VIDEO_MPEG2, StreamType.AUDIO_MPEG1, StreamType.AUDIO_MPEG2, StreamType.PRIVATE_SECTION, StreamType.PRIVATE_DATA, StreamType.AUDIO_AAC, StreamType.AUDIO_AAC_LATM, StreamType.VIDEO_MPEG4, StreamType.METADATA, StreamType.VIDEO_H264, StreamType.VIDEO_HEVC, StreamType.VIDEO_CAVS, StreamType.VIDEO_VC1, StreamType.VIDEO_DIRAC, StreamType.AUDIO_AC3, StreamType.AUDIO_DTS, StreamType.AUDIO_TRUEHD, StreamType.AUDIO_EAC3};
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/github/thibaultbee/streampack/internal/muxers/ts/packets/Pmt$StreamType$Companion;", "", "()V", "fromMimeType", "Lcom/github/thibaultbee/streampack/internal/muxers/ts/packets/Pmt$StreamType;", "mimeType", "", "sdk_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final StreamType fromMimeType(@NotNull String mimeType) {
                StreamType streamType;
                Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
                switch (mimeType) {
                    case "video/mpeg2": {
                        streamType = VIDEO_MPEG2;
                        break;
                    }
                    case "audio/mpeg": {
                        streamType = AUDIO_MPEG1;
                        break;
                    }
                    case "audio/mp4a-latm": {
                        streamType = AUDIO_AAC;
                        break;
                    }
                    case "video/mp4v-es": {
                        streamType = VIDEO_MPEG4;
                        break;
                    }
                    case "video/avc": {
                        streamType = VIDEO_H264;
                        break;
                    }
                    case "video/hevc": {
                        streamType = VIDEO_HEVC;
                        break;
                    }
                    case "audio/ac3": {
                        streamType = AUDIO_AC3;
                        break;
                    }
                    case "audio/eac3": {
                        streamType = AUDIO_EAC3;
                        break;
                    }
                    case "audio/opus": {
                        streamType = PRIVATE_DATA;
                        break;
                    }
                    default: {
                        streamType = PRIVATE_DATA;
                    }
                }
                return streamType;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

