/*
 * Decompiled with CFR 0.152.
 */
package com.github.thibaultbee.streampack.internal.encoders.format.aac;

import android.media.MediaFormat;
import com.github.thibaultbee.streampack.internal.bitbuffer.BitBuffer;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0002J\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/github/thibaultbee/streampack/internal/encoders/format/aac/Adts;", "", "format", "Landroid/media/MediaFormat;", "payloadLength", "", "(Landroid/media/MediaFormat;I)V", "channelConfiguration", "channelCount", "samplingFrequencyIndex", "samplingFrequency", "toByteBuffer", "Ljava/nio/ByteBuffer;", "sdk_release"})
public final class Adts {
    @NotNull
    private final MediaFormat format;
    private final int payloadLength;

    public Adts(@NotNull MediaFormat format, int payloadLength) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.format = format;
        this.payloadLength = payloadLength;
    }

    private final int samplingFrequencyIndex(int samplingFrequency) {
        int n;
        int n2 = samplingFrequency;
        switch (n2) {
            case 96000: {
                n = 0;
                break;
            }
            case 88200: {
                n = 1;
                break;
            }
            case 64000: {
                n = 2;
                break;
            }
            case 48000: {
                n = 3;
                break;
            }
            case 44100: {
                n = 4;
                break;
            }
            case 32000: {
                n = 5;
                break;
            }
            case 24000: {
                n = 6;
                break;
            }
            case 22050: {
                n = 7;
                break;
            }
            case 16000: {
                n = 8;
                break;
            }
            case 12000: {
                n = 9;
                break;
            }
            case 11025: {
                n = 10;
                break;
            }
            case 8000: {
                n = 11;
                break;
            }
            case 7350: {
                n = 12;
                break;
            }
            default: {
                n = 15;
            }
        }
        return n;
    }

    private final int channelConfiguration(int channelCount) {
        int n;
        int n2 = channelCount;
        switch (n2) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 3: {
                n = 3;
                break;
            }
            case 4: {
                n = 4;
                break;
            }
            case 5: {
                n = 5;
                break;
            }
            case 6: {
                n = 6;
                break;
            }
            case 8: {
                n = 7;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    @NotNull
    public final ByteBuffer toByteBuffer() {
        boolean protectionAbsent = true;
        BitBuffer adts = BitBuffer.Companion.allocate(7);
        BitBuffer.put$default(adts, 4095, 12, null, 4, null);
        BitBuffer.put$default(adts, 0, 1, null, 4, null);
        BitBuffer.put$default(adts, 0, 2, null, 4, null);
        adts.put(protectionAbsent);
        BitBuffer.put$default(adts, 1, 2, null, 4, null);
        int samplingFrequencyIndex = this.samplingFrequencyIndex(this.format.getInteger("sample-rate"));
        BitBuffer.put$default(adts, samplingFrequencyIndex, 4, null, 4, null);
        BitBuffer.put$default(adts, 0, 1, null, 4, null);
        int channelConfiguration = this.channelConfiguration(this.format.getInteger("channel-count"));
        BitBuffer.put$default(adts, channelConfiguration, 3, null, 4, null);
        BitBuffer.put$default(adts, 0, 1, null, 4, null);
        BitBuffer.put$default(adts, 0, 1, null, 4, null);
        BitBuffer.put$default(adts, 0, 1, null, 4, null);
        BitBuffer.put$default(adts, 0, 1, null, 4, null);
        int frameLength = this.payloadLength + 7;
        BitBuffer.put$default(adts, frameLength, 13, null, 4, null);
        BitBuffer.put$default(adts, 2047, 11, null, 4, null);
        BitBuffer.put$default(adts, 0, 2, null, 4, null);
        return adts.toByteBuffer();
    }
}

