/*
 * Decompiled with CFR 0.152.
 */
package com.github.thibaultbee.streampack.internal.encoders;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import android.util.Size;
import android.view.Surface;
import com.github.thibaultbee.streampack.data.VideoConfig;
import com.github.thibaultbee.streampack.internal.encoders.IEncoderListener;
import com.github.thibaultbee.streampack.internal.encoders.MediaCodecEncoder;
import com.github.thibaultbee.streampack.internal.gl.EGlSurface;
import com.github.thibaultbee.streampack.internal.gl.FullFrameRect;
import com.github.thibaultbee.streampack.internal.gl.Texture2DProgram;
import com.github.thibaultbee.streampack.internal.utils.AVExtensionsKt;
import com.github.thibaultbee.streampack.listeners.OnErrorListener;
import com.github.thibaultbee.streampack.logger.ILogger;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001&B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0002H\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u0019H\u0016R\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006'"}, d2={"Lcom/github/thibaultbee/streampack/internal/encoders/VideoMediaCodecEncoder;", "Lcom/github/thibaultbee/streampack/internal/encoders/MediaCodecEncoder;", "Lcom/github/thibaultbee/streampack/data/VideoConfig;", "encoderListener", "Lcom/github/thibaultbee/streampack/internal/encoders/IEncoderListener;", "onInternalErrorListener", "Lcom/github/thibaultbee/streampack/listeners/OnErrorListener;", "context", "Landroid/content/Context;", "logger", "Lcom/github/thibaultbee/streampack/logger/ILogger;", "(Lcom/github/thibaultbee/streampack/internal/encoders/IEncoderListener;Lcom/github/thibaultbee/streampack/listeners/OnErrorListener;Landroid/content/Context;Lcom/github/thibaultbee/streampack/logger/ILogger;)V", "codecSurface", "Lcom/github/thibaultbee/streampack/internal/encoders/VideoMediaCodecEncoder$CodecSurface;", "getCodecSurface", "()Lcom/github/thibaultbee/streampack/internal/encoders/VideoMediaCodecEncoder$CodecSurface;", "setCodecSurface", "(Lcom/github/thibaultbee/streampack/internal/encoders/VideoMediaCodecEncoder$CodecSurface;)V", "inputSurface", "Landroid/view/Surface;", "getInputSurface", "()Landroid/view/Surface;", "getOnInternalErrorListener", "()Lcom/github/thibaultbee/streampack/listeners/OnErrorListener;", "configure", "", "config", "createVideoCodec", "Landroid/media/MediaCodec;", "videoConfig", "useConfigProfileLevel", "", "onGenerateExtra", "Ljava/nio/ByteBuffer;", "buffer", "format", "Landroid/media/MediaFormat;", "release", "CodecSurface", "sdk_release"})
public final class VideoMediaCodecEncoder
extends MediaCodecEncoder<VideoConfig> {
    @NotNull
    private final OnErrorListener onInternalErrorListener;
    @NotNull
    private final Context context;
    @Nullable
    private CodecSurface codecSurface;

    public VideoMediaCodecEncoder(@NotNull IEncoderListener encoderListener, @NotNull OnErrorListener onInternalErrorListener2, @NotNull Context context, @NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)encoderListener, (String)"encoderListener");
        Intrinsics.checkNotNullParameter((Object)onInternalErrorListener2, (String)"onInternalErrorListener");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        super(encoderListener, logger);
        this.onInternalErrorListener = onInternalErrorListener2;
        this.context = context;
    }

    @Override
    @NotNull
    protected OnErrorListener getOnInternalErrorListener() {
        return this.onInternalErrorListener;
    }

    @Nullable
    public final CodecSurface getCodecSurface() {
        return this.codecSurface;
    }

    public final void setCodecSurface(@Nullable CodecSurface codecSurface) {
        this.codecSurface = codecSurface;
    }

    @Override
    public void configure(@NotNull VideoConfig config) {
        MediaCodec mediaCodec;
        VideoMediaCodecEncoder videoMediaCodecEncoder;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        VideoMediaCodecEncoder videoMediaCodecEncoder2 = this;
        try {
            videoMediaCodecEncoder = videoMediaCodecEncoder2;
            mediaCodec = this.createVideoCodec(config, true);
        }
        catch (MediaCodec.CodecException codecException) {
            videoMediaCodecEncoder = videoMediaCodecEncoder2;
            mediaCodec = this.createVideoCodec(config, false);
        }
        videoMediaCodecEncoder.setMediaCodec(mediaCodec);
    }

    private final MediaCodec createVideoCodec(VideoConfig videoConfig, boolean useConfigProfileLevel) {
        boolean isPortrait = AVExtensionsKt.isPortrait(this.context);
        MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)videoConfig.getMimeType(), (int)(isPortrait ? videoConfig.getResolution().getHeight() : videoConfig.getResolution().getWidth()), (int)(isPortrait ? videoConfig.getResolution().getWidth() : videoConfig.getResolution().getHeight()));
        Intrinsics.checkNotNullExpressionValue((Object)mediaFormat, (String)"createVideoFormat(\n     \u2026t\n            }\n        )");
        MediaFormat videoFormat = mediaFormat;
        MediaCodec codec = this.createCodec(videoFormat);
        videoFormat.setInteger("bitrate", videoConfig.getStartBitrate());
        this.set_bitrate(videoConfig.getStartBitrate());
        videoFormat.setInteger("frame-rate", videoConfig.getFps());
        videoFormat.setInteger("color-format", 2130708361);
        videoFormat.setInteger("i-frame-interval", 1);
        if (useConfigProfileLevel) {
            videoFormat.setInteger("profile", videoConfig.getProfile());
            if (Build.VERSION.SDK_INT >= 23) {
                videoFormat.setInteger("level", videoConfig.getLevel());
            }
        }
        this.configureCodec(codec, videoFormat, "VMediaCodecThread");
        Surface surface = codec.createInputSurface();
        Intrinsics.checkNotNullExpressionValue((Object)surface, (String)"codec.createInputSurface()");
        this.codecSurface = new CodecSurface(surface, this.context);
        return codec;
    }

    @Override
    public void release() {
        super.release();
        CodecSurface codecSurface = this.codecSurface;
        if (codecSurface != null) {
            codecSurface.release();
        }
        this.codecSurface = null;
    }

    @Override
    @NotNull
    public ByteBuffer onGenerateExtra(@NotNull ByteBuffer buffer, @NotNull MediaFormat format) {
        ByteBuffer it;
        boolean bl;
        boolean bl2;
        ByteBuffer byteBuffer;
        int n;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        ByteBuffer csd0 = format.getByteBuffer("csd-0");
        ByteBuffer csd1 = format.getByteBuffer("csd-1");
        ByteBuffer byteBuffer2 = csd0;
        int byteBufferSize = byteBuffer2 == null ? 0 : (n = byteBuffer2.limit());
        byteBuffer2 = csd1;
        ByteBuffer extra = ByteBuffer.allocate(byteBufferSize += byteBuffer2 == null ? 0 : (n = byteBuffer2.limit()));
        ByteBuffer byteBuffer3 = csd0;
        if (byteBuffer3 != null) {
            byteBuffer = byteBuffer3;
            bl2 = false;
            bl = false;
            it = byteBuffer;
            boolean bl3 = false;
            extra.put(it);
        }
        byteBuffer3 = csd1;
        if (byteBuffer3 != null) {
            byteBuffer = byteBuffer3;
            bl2 = false;
            bl = false;
            it = byteBuffer;
            boolean bl4 = false;
            extra.put(it);
        }
        extra.rewind();
        Intrinsics.checkNotNullExpressionValue((Object)extra, (String)"extra");
        return extra;
    }

    @Nullable
    public final Surface getInputSurface() {
        Surface surface;
        CodecSurface codecSurface = this.codecSurface;
        if (codecSurface == null) {
            surface = null;
        } else {
            CodecSurface codecSurface2 = codecSurface;
            boolean bl = false;
            boolean bl2 = false;
            CodecSurface it = codecSurface2;
            boolean bl3 = false;
            surface = new Surface(it.getSurfaceTexture());
        }
        return surface;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0006\u0010\u0018\u001a\u00020\u0017R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/github/thibaultbee/streampack/internal/encoders/VideoMediaCodecEncoder$CodecSurface;", "Landroid/graphics/SurfaceTexture$OnFrameAvailableListener;", "surface", "Landroid/view/Surface;", "context", "Landroid/content/Context;", "(Landroid/view/Surface;Landroid/content/Context;)V", "eglSurface", "Lcom/github/thibaultbee/streampack/internal/gl/EGlSurface;", "executor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "fullFrameRect", "Lcom/github/thibaultbee/streampack/internal/gl/FullFrameRect;", "isReleased", "", "surfaceTexture", "Landroid/graphics/SurfaceTexture;", "getSurfaceTexture", "()Landroid/graphics/SurfaceTexture;", "textureId", "", "onFrameAvailable", "", "release", "sdk_release"})
    public static final class CodecSurface
    implements SurfaceTexture.OnFrameAvailableListener {
        @NotNull
        private final EGlSurface eglSurface;
        private final int textureId;
        @NotNull
        private final FullFrameRect fullFrameRect;
        private final ExecutorService executor;
        private boolean isReleased;
        @NotNull
        private final SurfaceTexture surfaceTexture;

        public CodecSurface(@NotNull Surface surface, @NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.eglSurface = new EGlSurface(surface);
            this.executor = Executors.newSingleThreadExecutor();
            this.eglSurface.makeCurrent();
            this.fullFrameRect = new FullFrameRect(new Texture2DProgram());
            this.textureId = this.fullFrameRect.createTextureObject();
            this.surfaceTexture = new SurfaceTexture(this.textureId);
            this.surfaceTexture.setDefaultBufferSize(this.eglSurface.getWidth(), this.eglSurface.getHeight());
            this.surfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
            this.eglSurface.makeUnCurrent();
            this.fullFrameRect.setMVPMatrixAndViewPort(AVExtensionsKt.getOrientation(context), new Size(this.eglSurface.getWidth(), this.eglSurface.getHeight()));
        }

        @NotNull
        public final SurfaceTexture getSurfaceTexture() {
            return this.surfaceTexture;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFrameAvailable(@NotNull SurfaceTexture surfaceTexture) {
            Intrinsics.checkNotNullParameter((Object)surfaceTexture, (String)"surfaceTexture");
            boolean bl = false;
            boolean bl2 = false;
            synchronized (this) {
                boolean bl3 = false;
                if (this.isReleased) {
                    return;
                }
                this.executor.execute(() -> CodecSurface.onFrameAvailable$lambda-1$lambda-0(this, surfaceTexture));
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void release() {
            boolean bl = false;
            boolean bl2 = false;
            synchronized (this) {
                boolean bl3 = false;
                this.isReleased = true;
                this.fullFrameRect.release(true);
                this.eglSurface.release();
                this.getSurfaceTexture().release();
                Unit unit = Unit.INSTANCE;
            }
        }

        private static final void onFrameAvailable$lambda-1$lambda-0(CodecSurface this$0, SurfaceTexture $surfaceTexture) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$surfaceTexture, (String)"$surfaceTexture");
            this$0.eglSurface.makeCurrent();
            $surfaceTexture.updateTexImage();
            float[] stMatrix = new float[16];
            $surfaceTexture.getTransformMatrix(stMatrix);
            this$0.fullFrameRect.drawFrame(this$0.textureId, stMatrix);
            this$0.eglSurface.setPresentationTime($surfaceTexture.getTimestamp());
            this$0.eglSurface.swapBuffers();
            $surfaceTexture.releaseTexImage();
        }
    }
}

