/*
 * Decompiled with CFR 0.152.
 */
package com.github.thibaultbee.streampack.internal.encoders;

import android.media.MediaCodec;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import com.github.thibaultbee.streampack.error.StreamPackError;
import com.github.thibaultbee.streampack.internal.data.Frame;
import com.github.thibaultbee.streampack.internal.encoders.IEncoder;
import com.github.thibaultbee.streampack.internal.encoders.IEncoderListener;
import com.github.thibaultbee.streampack.internal.events.EventHandler;
import com.github.thibaultbee.streampack.logger.ILogger;
import java.nio.ByteBuffer;
import java.security.InvalidParameterException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u00102\u001a\u0002032\u0006\u00104\u001a\u00020)2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020/H\u0004J\u0010\u00108\u001a\u00020)2\u0006\u00105\u001a\u000206H\u0004J\u0010\u00109\u001a\u0002032\u0006\u0010:\u001a\u00020/H\u0002J\u0018\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020<2\u0006\u00105\u001a\u000206H&J\b\u0010>\u001a\u000203H\u0016J\b\u0010?\u001a\u000203H\u0016J\b\u0010@\u001a\u000203H\u0016R\u001a\u0010\t\u001a\u00020\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR&\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\f\"\u0004\b\u0012\u0010\u000eR\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u001c\u0010(\u001a\u0004\u0018\u00010)X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u0016\u0010.\u001a\u0004\u0018\u00010/8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101\u00a8\u0006A"}, d2={"Lcom/github/thibaultbee/streampack/internal/encoders/MediaCodecEncoder;", "T", "Lcom/github/thibaultbee/streampack/internal/events/EventHandler;", "Lcom/github/thibaultbee/streampack/internal/encoders/IEncoder;", "encoderListener", "Lcom/github/thibaultbee/streampack/internal/encoders/IEncoderListener;", "logger", "Lcom/github/thibaultbee/streampack/logger/ILogger;", "(Lcom/github/thibaultbee/streampack/internal/encoders/IEncoderListener;Lcom/github/thibaultbee/streampack/logger/ILogger;)V", "_bitrate", "", "get_bitrate", "()I", "set_bitrate", "(I)V", "value", "bitrate", "getBitrate", "setBitrate", "callbackThread", "Landroid/os/HandlerThread;", "encoderCallback", "Landroid/media/MediaCodec$Callback;", "getEncoderCallback", "()Landroid/media/MediaCodec$Callback;", "getEncoderListener", "()Lcom/github/thibaultbee/streampack/internal/encoders/IEncoderListener;", "handler", "Landroid/os/Handler;", "getHandler", "()Landroid/os/Handler;", "setHandler", "(Landroid/os/Handler;)V", "isOnError", "", "isStopped", "lock", "Ljava/lang/Object;", "getLogger", "()Lcom/github/thibaultbee/streampack/logger/ILogger;", "mediaCodec", "Landroid/media/MediaCodec;", "getMediaCodec", "()Landroid/media/MediaCodec;", "setMediaCodec", "(Landroid/media/MediaCodec;)V", "mimeType", "", "getMimeType", "()Ljava/lang/String;", "configureCodec", "", "codec", "format", "Landroid/media/MediaFormat;", "handlerName", "createCodec", "createHandler", "name", "onGenerateExtra", "Ljava/nio/ByteBuffer;", "buffer", "release", "startStream", "stopStream", "sdk_release"})
public abstract class MediaCodecEncoder<T>
extends EventHandler
implements IEncoder<T> {
    @NotNull
    private final IEncoderListener encoderListener;
    @NotNull
    private final ILogger logger;
    @Nullable
    private MediaCodec mediaCodec;
    @Nullable
    private HandlerThread callbackThread;
    @Nullable
    private Handler handler;
    @NotNull
    private final Object lock;
    private boolean isStopped;
    private boolean isOnError;
    private int _bitrate;
    private int bitrate;
    @NotNull
    private final MediaCodec.Callback encoderCallback;

    public MediaCodecEncoder(@NotNull IEncoderListener encoderListener, @NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)encoderListener, (String)"encoderListener");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.encoderListener = encoderListener;
        this.logger = logger;
        this.lock = new Object();
        this.isStopped = true;
        this.encoderCallback = new MediaCodec.Callback(this){
            final /* synthetic */ MediaCodecEncoder<T> this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onOutputBufferAvailable(@NotNull MediaCodec codec, int index, @NotNull MediaCodec.BufferInfo info) {
                Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                Object object = MediaCodecEncoder.access$getLock$p(this.this$0);
                MediaCodecEncoder<T> mediaCodecEncoder = this.this$0;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (object) {
                    boolean bl3 = false;
                    if (MediaCodecEncoder.access$isStopped$p(mediaCodecEncoder)) {
                        return;
                    }
                    if (MediaCodecEncoder.access$isOnError$p(mediaCodecEncoder)) {
                        return;
                    }
                    try {
                        Unit unit;
                        MediaCodec mediaCodec = mediaCodecEncoder.getMediaCodec();
                        if (mediaCodec == null) {
                            unit = null;
                        } else {
                            ByteBuffer byteBuffer = mediaCodec.getOutputBuffer(index);
                            if (byteBuffer == null) {
                                unit = null;
                            } else {
                                ByteBuffer byteBuffer2 = byteBuffer;
                                boolean bl4 = false;
                                boolean bl5 = false;
                                ByteBuffer buffer = byteBuffer2;
                                boolean bl6 = false;
                                Object object2 = codec.getOutputFormat();
                                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"codec.outputFormat");
                                ByteBuffer extra = mediaCodecEncoder.onGenerateExtra(buffer, (MediaFormat)object2);
                                if (info.flags != 2) {
                                    String string = codec.getOutputFormat().getString("mime");
                                    Intrinsics.checkNotNull((Object)string);
                                    object2 = string;
                                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"codec.outputFormat.getSt\u2026g(MediaFormat.KEY_MIME)!!");
                                    object2 = new Frame(buffer, (String)object2, info.presentationTimeUs, null, info.flags == 1, extra);
                                    boolean bl7 = false;
                                    boolean bl8 = false;
                                    Object frame = object2;
                                    boolean bl9 = false;
                                    mediaCodecEncoder.getEncoderListener().onOutputFrame((Frame)frame);
                                }
                                if ((object2 = mediaCodecEncoder.getMediaCodec()) == null) {
                                    unit = null;
                                } else {
                                    object2.releaseOutputBuffer(index, false);
                                    unit = Unit.INSTANCE;
                                }
                            }
                        }
                        Unit unit2 = unit;
                        if (unit2 == null) {
                            mediaCodecEncoder.reportError(new StreamPackError(new UnsupportedOperationException("MediaCodecEncoder: can't get output buffer")));
                        }
                    }
                    catch (StreamPackError e) {
                        MediaCodecEncoder.access$setOnError$p(mediaCodecEncoder, true);
                        mediaCodecEncoder.reportError(e);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onInputBufferAvailable(@NotNull MediaCodec codec, int index) {
                Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
                Object object = MediaCodecEncoder.access$getLock$p(this.this$0);
                MediaCodecEncoder<T> mediaCodecEncoder = this.this$0;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (object) {
                    Unit unit;
                    boolean bl3 = false;
                    if (MediaCodecEncoder.access$isStopped$p(mediaCodecEncoder)) {
                        return;
                    }
                    MediaCodec mediaCodec = mediaCodecEncoder.getMediaCodec();
                    if (mediaCodec == null) {
                        unit = null;
                    } else {
                        ByteBuffer byteBuffer = mediaCodec.getInputBuffer(index);
                        if (byteBuffer == null) {
                            unit = null;
                        } else {
                            ByteBuffer byteBuffer2 = byteBuffer;
                            boolean bl4 = false;
                            boolean bl5 = false;
                            ByteBuffer buffer = byteBuffer2;
                            boolean bl6 = false;
                            Frame frame = mediaCodecEncoder.getEncoderListener().onInputFrame(buffer);
                            boolean bl7 = false;
                            boolean bl8 = false;
                            Frame frame2 = frame;
                            boolean bl9 = false;
                            MediaCodec mediaCodec2 = mediaCodecEncoder.getMediaCodec();
                            if (mediaCodec2 == null) {
                                unit = null;
                            } else {
                                mediaCodec2.queueInputBuffer(index, 0, frame2.getBuffer().remaining(), frame2.getPts(), 0);
                                unit = Unit.INSTANCE;
                            }
                        }
                    }
                    Unit unit2 = unit;
                    if (unit2 == null) {
                        mediaCodecEncoder.reportError(new StreamPackError(new UnsupportedOperationException("MediaCodecEncoder: can't get input buffer")));
                    }
                    Unit unit3 = Unit.INSTANCE;
                }
            }

            public void onOutputFormatChanged(@NotNull MediaCodec codec, @NotNull MediaFormat format) {
                Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
                Intrinsics.checkNotNullParameter((Object)format, (String)"format");
                ILogger.DefaultImpls.i$default(this.this$0.getLogger(), (Object)((Object)this), Intrinsics.stringPlus((String)"Format changed : ", (Object)format), null, 4, null);
            }

            public void onError(@NotNull MediaCodec codec, @NotNull MediaCodec.CodecException e) {
                Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.reportError(new StreamPackError((Throwable)e));
            }
        };
    }

    @Override
    @NotNull
    public IEncoderListener getEncoderListener() {
        return this.encoderListener;
    }

    @NotNull
    public final ILogger getLogger() {
        return this.logger;
    }

    @Nullable
    protected final MediaCodec getMediaCodec() {
        return this.mediaCodec;
    }

    protected final void setMediaCodec(@Nullable MediaCodec mediaCodec) {
        this.mediaCodec = mediaCodec;
    }

    @Nullable
    protected final Handler getHandler() {
        return this.handler;
    }

    protected final void setHandler(@Nullable Handler handler) {
        this.handler = handler;
    }

    protected final int get_bitrate() {
        return this._bitrate;
    }

    protected final void set_bitrate(int n) {
        this._bitrate = n;
    }

    public final int getBitrate() {
        return this._bitrate;
    }

    public final void setBitrate(int value) {
        Bundle bundle = new Bundle();
        bundle.putInt("video-bitrate", value);
        MediaCodec mediaCodec = this.mediaCodec;
        if (mediaCodec != null) {
            mediaCodec.setParameters(bundle);
        }
        this.bitrate = value;
        this._bitrate = value;
    }

    @NotNull
    protected final MediaCodec.Callback getEncoderCallback() {
        return this.encoderCallback;
    }

    /*
     * WARNING - void declaration
     */
    private final void createHandler(String name) {
        Handler handler;
        this.callbackThread = new HandlerThread(name);
        MediaCodecEncoder mediaCodecEncoder = this;
        HandlerThread handlerThread = this.callbackThread;
        if (handlerThread == null) {
            handler = null;
        } else {
            void handlerThread2;
            HandlerThread handlerThread3 = handlerThread;
            boolean bl = false;
            boolean bl2 = false;
            HandlerThread handlerThread4 = handlerThread3;
            MediaCodecEncoder mediaCodecEncoder2 = mediaCodecEncoder;
            boolean bl3 = false;
            handlerThread2.start();
            Handler handler2 = new Handler(handlerThread2.getLooper());
            mediaCodecEncoder = mediaCodecEncoder2;
            handler = handler2;
        }
        mediaCodecEncoder.handler = handler;
    }

    @NotNull
    protected final MediaCodec createCodec(@NotNull MediaFormat format) {
        String encoderName;
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        MediaCodecList mediaCodecList = new MediaCodecList(0);
        String string = encoderName = mediaCodecList.findEncoderForFormat(format);
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            MediaCodec mediaCodec = MediaCodec.createByCodecName((String)encoderName);
            Intrinsics.checkNotNullExpressionValue((Object)mediaCodec, (String)"createByCodecName(encoderName)");
            return mediaCodec;
        }
        Object var4_11 = null;
        throw new InvalidParameterException(Intrinsics.stringPlus((String)"Failed to create codec for ", (Object)this.mediaCodec));
    }

    protected final void configureCodec(@NotNull MediaCodec codec, @NotNull MediaFormat format, @NotNull String handlerName) {
        Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)handlerName, (String)"handlerName");
        if (Build.VERSION.SDK_INT >= 23) {
            this.createHandler(handlerName);
            codec.setCallback(this.encoderCallback, this.handler);
        } else {
            codec.setCallback(this.encoderCallback);
        }
        try {
            codec.configure(format, null, null, 1);
        }
        catch (Exception e) {
            codec.release();
            throw e;
        }
    }

    @Override
    @Nullable
    public String getMimeType() {
        MediaFormat mediaFormat;
        String string;
        MediaCodec mediaCodec = this.mediaCodec;
        String string2 = mediaCodec == null ? null : (string = (mediaFormat = mediaCodec.getOutputFormat()) == null ? null : mediaFormat.getString("mime"));
        if (string == null) {
            throw new IllegalStateException("Can't get MimeType without configuration");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startStream() {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            Unit unit;
            Unit unit2;
            boolean bl3 = false;
            this.isOnError = false;
            this.isStopped = false;
            MediaCodec mediaCodec = this.getMediaCodec();
            if (mediaCodec == null) {
                unit2 = null;
            } else {
                mediaCodec.start();
                unit2 = unit = Unit.INSTANCE;
            }
            if (unit == null) {
                throw new IllegalStateException("Can't start without configuration");
            }
            Unit unit3 = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopStream() {
        try {
            Object object = this.lock;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                Unit unit;
                boolean bl3 = false;
                this.isStopped = true;
                MediaCodec mediaCodec = this.getMediaCodec();
                if (mediaCodec != null) {
                    mediaCodec.setCallback(null);
                }
                mediaCodec = this.getMediaCodec();
                if (mediaCodec != null) {
                    mediaCodec.signalEndOfInputStream();
                }
                mediaCodec = this.getMediaCodec();
                if (mediaCodec != null) {
                    mediaCodec.flush();
                }
                mediaCodec = this.getMediaCodec();
                if (mediaCodec == null) {
                    unit = null;
                } else {
                    mediaCodec.stop();
                    unit = Unit.INSTANCE;
                }
                Unit unit2 = unit;
            }
        }
        catch (IllegalStateException e) {
            ILogger.DefaultImpls.d$default(this.logger, this, "Not running", null, 4, null);
        }
    }

    @Override
    public void release() {
        MediaCodec mediaCodec = this.mediaCodec;
        if (mediaCodec != null) {
            mediaCodec.release();
        }
        this.mediaCodec = null;
    }

    @NotNull
    public abstract ByteBuffer onGenerateExtra(@NotNull ByteBuffer var1, @NotNull MediaFormat var2);

    public static final /* synthetic */ Object access$getLock$p(MediaCodecEncoder $this) {
        return $this.lock;
    }

    public static final /* synthetic */ boolean access$isStopped$p(MediaCodecEncoder $this) {
        return $this.isStopped;
    }

    public static final /* synthetic */ boolean access$isOnError$p(MediaCodecEncoder $this) {
        return $this.isOnError;
    }

    public static final /* synthetic */ void access$setOnError$p(MediaCodecEncoder $this, boolean bl) {
        $this.isOnError = bl;
    }
}

