/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.coverage.gnu.trove;

import java.io.Serializable;
import org.jetbrains.coverage.gnu.trove.HashFunctions;
import org.jetbrains.coverage.gnu.trove.TIntHash;
import org.jetbrains.coverage.gnu.trove.TIntHashingStrategy;
import org.jetbrains.coverage.gnu.trove.TIntObjectIterator;
import org.jetbrains.coverage.gnu.trove.TIntObjectProcedure;
import org.jetbrains.coverage.gnu.trove.TIntProcedure;
import org.jetbrains.coverage.gnu.trove.TObjectFunction;
import org.jetbrains.coverage.gnu.trove.TObjectProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TIntObjectHashMap<V>
extends TIntHash
implements Serializable {
    protected transient V[] _values;

    public TIntObjectHashMap() {
    }

    /*
     * WARNING - void declaration
     */
    public TIntObjectHashMap(int initialCapacity) {
        super((int)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public TIntObjectHashMap(int initialCapacity, float loadFactor) {
        super((int)var1_1, (float)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public TIntObjectHashMap(TIntHashingStrategy strategy) {
        super((TIntHashingStrategy)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public TIntObjectHashMap(int initialCapacity, TIntHashingStrategy strategy) {
        super((int)var1_1, (TIntHashingStrategy)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public TIntObjectHashMap(int initialCapacity, float loadFactor, TIntHashingStrategy strategy) {
        super((int)var1_1, (float)var2_2, (TIntHashingStrategy)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public TIntObjectHashMap<V> clone() {
        void var1_1;
        TIntObjectHashMap m = (TIntObjectHashMap)super.clone();
        ((TIntObjectHashMap)super.clone())._values = (Object[])this._values.clone();
        return var1_1;
    }

    public TIntObjectIterator<V> iterator() {
        return new TIntObjectIterator(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int setUp(int initialCapacity) {
        void var1_1;
        int capacity = super.setUp(initialCapacity);
        this._values = new Object[capacity];
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public V put(int key, V value) {
        void var3_3;
        void var2_2;
        void var1_1;
        Object previous = null;
        int index = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = this._values[index];
            isNewMapping = false;
        }
        byte previousState = this._states[index];
        this._set[index] = var1_1;
        this._states[index] = 1;
        this._values[index] = var2_2;
        if (isNewMapping) {
            this.postInsertHook(previousState == 0);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        int[] oldKeys = this._set;
        V[] oldVals = this._values;
        byte[] oldStates = this._states;
        this._set = new int[newCapacity];
        this._values = new Object[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            void var2_2;
            if (oldStates[i] != 1) continue;
            int o = oldKeys[i];
            int index = this.insertionIndex(o);
            this._set[index] = var2_2;
            this._values[index] = oldVals[i];
            this._states[index] = 1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public V get(int key) {
        void var1_1;
        int index = this.index(key);
        if (index < 0) {
            return null;
        }
        return this._values[var1_1];
    }

    @Override
    public void clear() {
        super.clear();
        int[] keys2 = this._set;
        V[] vals = this._values;
        byte[] states = this._states;
        int i = keys2.length;
        while (i-- > 0) {
            keys2[i] = 0;
            vals[i] = null;
            states[i] = 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    public V remove(int key) {
        void var2_2;
        Object prev = null;
        int index = this.index(key);
        if (index >= 0) {
            void var1_1;
            prev = this._values[index];
            this.removeAt((int)var1_1);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object other) {
        void var1_1;
        if (!(other instanceof TIntObjectHashMap)) {
            return false;
        }
        TIntObjectHashMap that = (TIntObjectHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure((TIntObjectHashMap)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        HashProcedure p = new HashProcedure();
        this.forEachEntry(p);
        return var1_1.getHashCode();
    }

    @Override
    protected void removeAt(int index) {
        super.removeAt(index);
        this._values[var1_1] = null;
    }

    /*
     * WARNING - void declaration
     */
    public Object[] getValues() {
        void var1_1;
        Object[] vals = new Object[this.size()];
        V[] v = this._values;
        byte[] states = this._states;
        int i = v.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            vals[j++] = v[i];
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public int[] keys() {
        void var1_1;
        int[] keys2 = new int[this.size()];
        int[] k = this._set;
        byte[] states = this._states;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            keys2[j++] = k[i];
        }
        return var1_1;
    }

    public boolean containsValue(V val) {
        byte[] states = this._states;
        V[] vals = this._values;
        if (val == null) {
            int i = vals.length;
            while (i-- > 0) {
                if (states[i] != 1 || val != vals[i]) continue;
                return true;
            }
        } else {
            int i = vals.length;
            while (i-- > 0) {
                if (states[i] != 1 || val != vals[i] && !val.equals(vals[i])) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean containsKey(int key) {
        void var1_1;
        return this.contains((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean forEachKey(TIntProcedure procedure) {
        void var1_1;
        return this.forEach((TIntProcedure)var1_1);
    }

    public boolean forEachValue(TObjectProcedure<V> procedure) {
        byte[] states = this._states;
        V[] values2 = this._values;
        int i = this._values.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(values2[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TIntObjectProcedure<V> procedure) {
        byte[] states = this._states;
        int[] keys2 = this._set;
        V[] values2 = this._values;
        int i = keys2.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(keys2[i], values2[i])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean retainEntries(TIntObjectProcedure<V> procedure) {
        void var2_2;
        boolean modified = false;
        byte[] states = this._states;
        int[] keys2 = this._set;
        V[] values2 = this._values;
        int i = keys2.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(keys2[i], values2[i])) continue;
            this.removeAt(i);
            modified = true;
        }
        return (boolean)var2_2;
    }

    public void transformValues(TObjectFunction<V, V> function) {
        byte[] states = this._states;
        V[] values2 = this._values;
        int i = this._values.length;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            values2[i] = function.execute(values2[i]);
        }
    }

    private static final class EqProcedure
    implements TIntObjectProcedure {
        private final TIntObjectHashMap _otherMap;

        /*
         * WARNING - void declaration
         */
        EqProcedure(TIntObjectHashMap otherMap) {
            void var1_1;
            this._otherMap = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean execute(int key, Object value) {
            void var1_1;
            void var2_2;
            int n = this._otherMap.index(key);
            return n >= 0 && this.eq(var2_2, this._otherMap.get((int)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        private final boolean eq(Object o1, Object o2) {
            void var2_2;
            void var1_1;
            return o1 == o2 || o1 != null && var1_1.equals(var2_2);
        }
    }

    private final class HashProcedure
    implements TIntObjectProcedure {
        private int h = 0;

        private HashProcedure() {
        }

        public final int getHashCode() {
            return this.h;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean execute(int key, Object value) {
            void var2_2;
            void var1_1;
            this.h += TIntObjectHashMap.this._hashingStrategy.computeHashCode((int)var1_1) ^ HashFunctions.hash(var2_2);
            return true;
        }
    }
}

