/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.parser;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jgit.annotations.NonNull;

public final class FirstCommand {
    private final String line;
    private final Set<String> capabilities;

    @NonNull
    public static FirstCommand fromLine(String line2) {
        int nul = line2.indexOf(0);
        if (nul < 0) {
            return new FirstCommand(line2, Collections.emptySet());
        }
        Set opts = Arrays.asList(line2.substring(nul + 1).split(" ")).stream().collect(Collectors.toSet());
        return new FirstCommand(line2.substring(0, nul), Collections.unmodifiableSet(opts));
    }

    private FirstCommand(String line2, Set<String> capabilities) {
        this.line = line2;
        this.capabilities = capabilities;
    }

    @NonNull
    public String getLine() {
        return this.line;
    }

    @NonNull
    public Set<String> getCapabilities() {
        return this.capabilities;
    }
}

