/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.DetachedHeadException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefRename;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;

public class RenameBranchCommand
extends GitCommand<Ref> {
    private String oldName;
    private String newName;

    protected RenameBranchCommand(Repository repo) {
        super(repo);
    }

    @Override
    public Ref call() throws GitAPIException, RefNotFoundException, InvalidRefNameException, RefAlreadyExistsException, DetachedHeadException {
        this.checkCallable();
        if (this.newName == null) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().branchNameInvalid, "<null>"));
        }
        try {
            Ref resultRef;
            String fullNewName;
            String fullOldName;
            if (this.oldName != null) {
                Ref ref = this.repo.exactRef(this.oldName);
                if (ref == null) {
                    ref = this.repo.exactRef("refs/heads/" + this.oldName);
                    Ref ref2 = this.repo.exactRef("refs/remotes/" + this.oldName);
                    if (ref != null && ref2 != null) {
                        throw new RefNotFoundException(MessageFormat.format(JGitText.get().renameBranchFailedAmbiguous, this.oldName, ref.getName(), ref2.getName()));
                    }
                    if (ref == null) {
                        if (ref2 != null) {
                            ref = ref2;
                        } else {
                            throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, this.oldName));
                        }
                    }
                }
                fullOldName = ref.getName();
            } else {
                fullOldName = this.repo.getFullBranch();
                if (fullOldName == null) {
                    throw new NoHeadException(JGitText.get().invalidRepositoryStateNoHead);
                }
                if (ObjectId.isId(fullOldName)) {
                    throw new DetachedHeadException();
                }
            }
            if (fullOldName.startsWith("refs/remotes/")) {
                fullNewName = "refs/remotes/" + this.newName;
            } else if (fullOldName.startsWith("refs/heads/")) {
                fullNewName = "refs/heads/" + this.newName;
            } else {
                throw new RefNotFoundException(MessageFormat.format(JGitText.get().renameBranchFailedNotABranch, fullOldName));
            }
            if (!Repository.isValidRefName(fullNewName)) {
                throw new InvalidRefNameException(MessageFormat.format(JGitText.get().branchNameInvalid, fullNewName));
            }
            if (this.repo.exactRef(fullNewName) != null) {
                throw new RefAlreadyExistsException(MessageFormat.format(JGitText.get().refAlreadyExists1, fullNewName));
            }
            RefRename rename = this.repo.renameRef(fullOldName, fullNewName);
            RefUpdate.Result renameResult = rename.rename();
            this.setCallable(false);
            if (RefUpdate.Result.RENAMED != renameResult) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().renameBranchUnexpectedResult, renameResult.name()));
            }
            if (fullNewName.startsWith("refs/heads/")) {
                String shortOldName = fullOldName.substring("refs/heads/".length());
                StoredConfig repoConfig = this.repo.getConfig();
                for (String name : repoConfig.getNames("branch", shortOldName)) {
                    String[] values2 = repoConfig.getStringList("branch", shortOldName, name);
                    if (values2.length == 0) continue;
                    String[] existing = repoConfig.getStringList("branch", this.newName, name);
                    if (existing.length > 0) {
                        String[] newValues = new String[values2.length + existing.length];
                        System.arraycopy(existing, 0, newValues, 0, existing.length);
                        System.arraycopy(values2, 0, newValues, existing.length, values2.length);
                        values2 = newValues;
                    }
                    repoConfig.setStringList("branch", this.newName, name, Arrays.asList(values2));
                }
                repoConfig.unsetSection("branch", shortOldName);
                repoConfig.save();
            }
            if ((resultRef = this.repo.exactRef(fullNewName)) == null) {
                throw new JGitInternalException(JGitText.get().renameBranchFailedUnknownReason);
            }
            return resultRef;
        }
        catch (IOException ioe) {
            throw new JGitInternalException(ioe.getMessage(), ioe);
        }
    }

    public RenameBranchCommand setNewName(String newName) {
        this.checkCallable();
        this.newName = newName;
        return this;
    }

    public RenameBranchCommand setOldName(String oldName) {
        this.checkCallable();
        this.oldName = oldName;
        return this;
    }
}

