/*
 * Decompiled with CFR 0.152.
 */
package io.github.surpsg.deltacoverage.report.jacoco.analyzable;

import io.github.surpsg.deltacoverage.diff.parse.ClassFile;
import io.github.surpsg.deltacoverage.lib.jvm.JvmClassUtilKt;
import java.io.IOException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.data.ExecutionData;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.internal.analysis.ClassCoverageImpl;
import org.jacoco.core.internal.analysis.FilteringClassAnalyzer;
import org.jacoco.core.internal.analysis.StringPool;
import org.jacoco.core.internal.analysis.filter.IFilter;
import org.jacoco.core.internal.data.CRC64;
import org.jacoco.core.internal.flow.ClassProbesAdapter;
import org.jacoco.core.internal.instr.InstrSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001%B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0007\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001c\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019H\u0002J\u001a\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0014H\u0002R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lio/github/surpsg/deltacoverage/report/jacoco/analyzable/FilteringAnalyzer;", "Lorg/jacoco/core/analysis/Analyzer;", "executionData", "Lorg/jacoco/core/data/ExecutionDataStore;", "coverageVisitor", "Lorg/jacoco/core/analysis/ICoverageVisitor;", "classFilter", "Lkotlin/Function1;", "Lio/github/surpsg/deltacoverage/diff/parse/ClassFile;", "", "customFilterProvider", "Lorg/jacoco/core/analysis/IClassCoverage;", "Lorg/jacoco/core/internal/analysis/filter/IFilter;", "(Lorg/jacoco/core/data/ExecutionDataStore;Lorg/jacoco/core/analysis/ICoverageVisitor;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "analyzeClass", "", "source", "", "buffer", "location", "", "analyzerError", "Ljava/io/IOException;", "cause", "Ljava/lang/Exception;", "Lkotlin/Exception;", "buildClassAnalyzer", "Lorg/jacoco/core/internal/analysis/FilteringClassAnalyzer;", "coverage", "Lorg/jacoco/core/internal/analysis/ClassCoverageImpl;", "probes", "", "createAnalyzingVisitor", "Lorg/objectweb/asm/ClassVisitor;", "classid", "", "className", "ExecutionInfo", "delta-coverage-core"})
@SourceDebugExtension(value={"SMAP\nFilteringAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilteringAnalyzer.kt\nio/github/surpsg/deltacoverage/report/jacoco/analyzable/FilteringAnalyzer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n1#2:103\n*E\n"})
public final class FilteringAnalyzer
extends Analyzer {
    @NotNull
    private final ExecutionDataStore executionData;
    @NotNull
    private final ICoverageVisitor coverageVisitor;
    @NotNull
    private final Function1<ClassFile, Boolean> classFilter;
    @NotNull
    private final Function1<IClassCoverage, IFilter> customFilterProvider;

    public FilteringAnalyzer(@NotNull ExecutionDataStore executionData, @NotNull ICoverageVisitor coverageVisitor, @NotNull Function1<? super ClassFile, Boolean> classFilter, @NotNull Function1<? super IClassCoverage, ? extends IFilter> customFilterProvider) {
        Intrinsics.checkNotNullParameter(executionData, "executionData");
        Intrinsics.checkNotNullParameter(coverageVisitor, "coverageVisitor");
        Intrinsics.checkNotNullParameter(classFilter, "classFilter");
        Intrinsics.checkNotNullParameter(customFilterProvider, "customFilterProvider");
        super(executionData, coverageVisitor);
        this.executionData = executionData;
        this.coverageVisitor = coverageVisitor;
        this.classFilter = classFilter;
        this.customFilterProvider = customFilterProvider;
    }

    @Override
    public void analyzeClass(@NotNull byte[] buffer, @NotNull String location) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        Intrinsics.checkNotNullParameter(location, "location");
        try {
            this.analyzeClass(buffer);
        }
        catch (RuntimeException cause) {
            throw this.analyzerError(location, cause);
        }
    }

    private final void analyzeClass(byte[] source) {
        boolean shouldComputeClassCoverage;
        boolean bl;
        long classId = CRC64.classId(source);
        ClassReader reader = InstrSupport.classReaderFor(source);
        if ((reader.getAccess() & 0x8000) != 0) {
            return;
        }
        if ((reader.getAccess() & 0x1000) != 0) {
            return;
        }
        String string = JvmClassUtilKt.readClassFileName(source);
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            String string2 = reader.getClassName();
            Intrinsics.checkNotNullExpressionValue(string2, "getClassName(...)");
            ClassFile it2 = new ClassFile(it, string2);
            boolean bl3 = false;
            bl = this.classFilter.invoke(it2);
        } else {
            bl = shouldComputeClassCoverage = false;
        }
        if (shouldComputeClassCoverage) {
            String string3 = reader.getClassName();
            Intrinsics.checkNotNullExpressionValue(string3, "getClassName(...)");
            reader.accept(this.createAnalyzingVisitor(classId, string3), 0);
        }
    }

    private final ClassVisitor createAnalyzingVisitor(long classid, String className) {
        ExecutionData data = this.executionData.get(classid);
        ExecutionInfo executionInfo = data == null ? new ExecutionInfo(null, this.executionData.contains(className)) : new ExecutionInfo(data.getProbes(), false);
        boolean[] probes = executionInfo.component1();
        boolean noMatch = executionInfo.component2();
        return new ClassProbesAdapter(this.buildClassAnalyzer(new ClassCoverageImpl(className, classid, noMatch), probes), false);
    }

    private final FilteringClassAnalyzer buildClassAnalyzer(ClassCoverageImpl coverage, boolean[] probes) {
        StringPool stringPool = new StringPool();
        IFilter iFilter = this.customFilterProvider.invoke(coverage);
        return new FilteringClassAnalyzer(coverage, probes, this, stringPool, iFilter){
            final /* synthetic */ ClassCoverageImpl $coverage;
            final /* synthetic */ FilteringAnalyzer this$0;
            {
                this.$coverage = $coverage;
                this.this$0 = $receiver;
                super($coverage, $probes, $super_call_param$1, $super_call_param$2);
            }

            public void visitEnd() {
                super.visitEnd();
                FilteringAnalyzer.access$getCoverageVisitor$p(this.this$0).visitCoverage(this.$coverage);
            }
        };
    }

    private final IOException analyzerError(String location, Exception cause) {
        IOException iOException;
        IOException $this$analyzerError_u24lambda_u242 = iOException = new IOException("Error while analyzing " + location + '.');
        boolean bl = false;
        $this$analyzerError_u24lambda_u242.initCause(cause);
        return iOException;
    }

    public static final /* synthetic */ ICoverageVisitor access$getCoverageVisitor$p(FilteringAnalyzer $this) {
        return $this.coverageVisitor;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lio/github/surpsg/deltacoverage/report/jacoco/analyzable/FilteringAnalyzer$ExecutionInfo;", "", "probes", "", "noMatch", "", "([ZZ)V", "getNoMatch", "()Z", "getProbes", "()[Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "delta-coverage-core"})
    private static final class ExecutionInfo {
        @Nullable
        private final boolean[] probes;
        private final boolean noMatch;

        public ExecutionInfo(@Nullable boolean[] probes, boolean noMatch) {
            this.probes = probes;
            this.noMatch = noMatch;
        }

        @Nullable
        public final boolean[] getProbes() {
            return this.probes;
        }

        public final boolean getNoMatch() {
            return this.noMatch;
        }

        @Nullable
        public final boolean[] component1() {
            return this.probes;
        }

        public final boolean component2() {
            return this.noMatch;
        }

        @NotNull
        public final ExecutionInfo copy(@Nullable boolean[] probes, boolean noMatch) {
            return new ExecutionInfo(probes, noMatch);
        }

        public static /* synthetic */ ExecutionInfo copy$default(ExecutionInfo executionInfo, boolean[] blArray, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                blArray = executionInfo.probes;
            }
            if ((n & 2) != 0) {
                bl = executionInfo.noMatch;
            }
            return executionInfo.copy(blArray, bl);
        }

        @NotNull
        public String toString() {
            return "ExecutionInfo(probes=" + Arrays.toString(this.probes) + ", noMatch=" + this.noMatch + ')';
        }

        public int hashCode() {
            int result = this.probes == null ? 0 : Arrays.hashCode(this.probes);
            result = result * 31 + Boolean.hashCode(this.noMatch);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExecutionInfo)) {
                return false;
            }
            ExecutionInfo executionInfo = (ExecutionInfo)other;
            if (!Intrinsics.areEqual(this.probes, executionInfo.probes)) {
                return false;
            }
            return this.noMatch == executionInfo.noMatch;
        }
    }
}

