/*
 * Decompiled with CFR 0.152.
 */
package io.github.surpsg.deltacoverage.report.jacoco;

import io.github.surpsg.deltacoverage.config.CoverageEntity;
import io.github.surpsg.deltacoverage.config.CoverageRulesConfig;
import io.github.surpsg.deltacoverage.config.ViolationRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.report.check.IViolationsOutput;
import org.jacoco.report.check.Limit;
import org.jacoco.report.check.Rule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 !2\u00020\u0001:\u0002!\"B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0017J(\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0007H\u0016J\u000e\u0010 \u001a\u0004\u0018\u00010\n*\u00020\u0013H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006#"}, d2={"Lio/github/surpsg/deltacoverage/report/jacoco/ViolationsOutputResolver;", "Lorg/jacoco/report/check/IViolationsOutput;", "violationRuleConfig", "Lio/github/surpsg/deltacoverage/config/CoverageRulesConfig;", "(Lio/github/surpsg/deltacoverage/config/CoverageRulesConfig;)V", "foundViolations", "", "", "violationRules", "", "Lio/github/surpsg/deltacoverage/config/CoverageEntity;", "Lio/github/surpsg/deltacoverage/config/ViolationRule;", "getViolationRules", "()Ljava/util/Map;", "violationRules$delegate", "Lkotlin/Lazy;", "buildViolationResolveContext", "Lio/github/surpsg/deltacoverage/report/jacoco/ViolationsOutputResolver$ViolationResolveContext;", "counterEntity", "Lorg/jacoco/core/analysis/ICoverageNode$CounterEntity;", "coverage", "Lorg/jacoco/core/analysis/ICoverageNode;", "getViolations", "", "onViolation", "", "node", "rule", "Lorg/jacoco/report/check/Rule;", "limit", "Lorg/jacoco/report/check/Limit;", "message", "mapToCoverageEntity", "Companion", "ViolationResolveContext", "delta-coverage-core"})
@SourceDebugExtension(value={"SMAP\nViolationsOutputResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ViolationsOutputResolver.kt\nio/github/surpsg/deltacoverage/report/jacoco/ViolationsOutputResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n1#2:78\n*E\n"})
public final class ViolationsOutputResolver
implements IViolationsOutput {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy violationRules$delegate;
    @NotNull
    private final List<String> foundViolations;
    @NotNull
    private static final Logger log;
    @NotNull
    private static final ViolationResolveContext NO_IGNORE_VIOLATION_CONTEXT;

    public ViolationsOutputResolver(@NotNull CoverageRulesConfig violationRuleConfig) {
        Intrinsics.checkNotNullParameter(violationRuleConfig, "violationRuleConfig");
        this.violationRules$delegate = LazyKt.lazy((Function0)new Function0<Map<CoverageEntity, ? extends ViolationRule>>(violationRuleConfig){
            final /* synthetic */ CoverageRulesConfig $violationRuleConfig;
            {
                this.$violationRuleConfig = $violationRuleConfig;
                super(0);
            }

            @NotNull
            public final Map<CoverageEntity, ViolationRule> invoke() {
                return this.$violationRuleConfig.getEntitiesRules();
            }
        });
        this.foundViolations = new ArrayList();
    }

    private final Map<CoverageEntity, ViolationRule> getViolationRules() {
        Lazy lazy = this.violationRules$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public final List<String> getViolations() {
        return this.foundViolations;
    }

    @Override
    public void onViolation(@NotNull ICoverageNode node, @NotNull Rule rule, @NotNull Limit limit, @NotNull String message) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(rule, "rule");
        Intrinsics.checkNotNullParameter(limit, "limit");
        Intrinsics.checkNotNullParameter(message, "message");
        log.debug("New violation: " + message);
        ICoverageNode.CounterEntity counterEntity = limit.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)counterEntity, "getEntity(...)");
        ViolationResolveContext violationResolveContext = this.buildViolationResolveContext(counterEntity, node);
        if (violationResolveContext.isIgnoredByThreshold()) {
            Object[] objectArray = new Object[]{violationResolveContext.getCoverageEntity(), violationResolveContext.getThresholdCount(), violationResolveContext.getTotalCount()};
            log.info("Coverage violation of {} was ignored because threshold={} but total={}", objectArray);
        } else {
            ((Collection)this.foundViolations).add(message);
        }
    }

    private final ViolationResolveContext buildViolationResolveContext(ICoverageNode.CounterEntity counterEntity, ICoverageNode coverage) {
        ViolationResolveContext violationResolveContext;
        Integer n;
        int totalEntityCount = coverage.getCounter(counterEntity).getTotalCount();
        CoverageEntity coverageEntity = this.mapToCoverageEntity(counterEntity);
        if (coverageEntity == null) {
            return NO_IGNORE_VIOLATION_CONTEXT;
        }
        CoverageEntity coverageEntity2 = coverageEntity;
        ViolationRule violationRule = this.getViolationRules().get((Object)coverageEntity2);
        if (violationRule != null && (n = violationRule.getEntityCountThreshold()) != null) {
            int threshold = ((Number)n).intValue();
            boolean bl = false;
            violationResolveContext = new ViolationResolveContext(coverageEntity2, threshold, totalEntityCount);
        } else {
            violationResolveContext = NO_IGNORE_VIOLATION_CONTEXT;
        }
        return violationResolveContext;
    }

    private final CoverageEntity mapToCoverageEntity(ICoverageNode.CounterEntity $this$mapToCoverageEntity) {
        CoverageEntity coverageEntity;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$mapToCoverageEntity.ordinal()]) {
            case 1: {
                coverageEntity = CoverageEntity.INSTRUCTION;
                break;
            }
            case 2: {
                coverageEntity = CoverageEntity.BRANCH;
                break;
            }
            case 3: {
                coverageEntity = CoverageEntity.LINE;
                break;
            }
            default: {
                coverageEntity = null;
            }
        }
        return coverageEntity;
    }

    static {
        Logger logger = LoggerFactory.getLogger(ViolationsOutputResolver.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        log = logger;
        NO_IGNORE_VIOLATION_CONTEXT = new ViolationResolveContext(){

            public boolean isIgnoredByThreshold() {
                return false;
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lio/github/surpsg/deltacoverage/report/jacoco/ViolationsOutputResolver$Companion;", "", "()V", "NO_IGNORE_VIOLATION_CONTEXT", "Lio/github/surpsg/deltacoverage/report/jacoco/ViolationsOutputResolver$ViolationResolveContext;", "getNO_IGNORE_VIOLATION_CONTEXT", "()Lio/github/surpsg/deltacoverage/report/jacoco/ViolationsOutputResolver$ViolationResolveContext;", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "delta-coverage-core"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        @NotNull
        public final ViolationResolveContext getNO_IGNORE_VIOLATION_CONTEXT() {
            return NO_IGNORE_VIOLATION_CONTEXT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\b\u0012\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lio/github/surpsg/deltacoverage/report/jacoco/ViolationsOutputResolver$ViolationResolveContext;", "", "coverageEntity", "Lio/github/surpsg/deltacoverage/config/CoverageEntity;", "thresholdCount", "", "totalCount", "(Lio/github/surpsg/deltacoverage/config/CoverageEntity;II)V", "getCoverageEntity", "()Lio/github/surpsg/deltacoverage/config/CoverageEntity;", "getThresholdCount", "()I", "getTotalCount", "isIgnoredByThreshold", "", "delta-coverage-core"})
    private static class ViolationResolveContext {
        @Nullable
        private final CoverageEntity coverageEntity;
        private final int thresholdCount;
        private final int totalCount;

        public ViolationResolveContext(@Nullable CoverageEntity coverageEntity, int thresholdCount, int totalCount) {
            this.coverageEntity = coverageEntity;
            this.thresholdCount = thresholdCount;
            this.totalCount = totalCount;
        }

        @Nullable
        public final CoverageEntity getCoverageEntity() {
            return this.coverageEntity;
        }

        public final int getThresholdCount() {
            return this.thresholdCount;
        }

        public final int getTotalCount() {
            return this.totalCount;
        }

        public boolean isIgnoredByThreshold() {
            return this.totalCount < this.thresholdCount;
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ICoverageNode.CounterEntity.values().length];
            try {
                nArray[ICoverageNode.CounterEntity.INSTRUCTION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ICoverageNode.CounterEntity.BRANCH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ICoverageNode.CounterEntity.LINE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

