/*
 * Decompiled with CFR 0.152.
 */
package io.github.surpsg.deltacoverage.report.intellij.verifier;

import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.verify.api.Target;
import io.github.surpsg.deltacoverage.report.intellij.verifier.CoverageRuleWithThreshold;
import io.github.surpsg.deltacoverage.report.intellij.verifier.CoverageViolationsCollector;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lio/github/surpsg/deltacoverage/report/intellij/verifier/CoverageVerifier;", "", "projectData", "Lcom/intellij/rt/coverage/data/ProjectData;", "rule", "Lio/github/surpsg/deltacoverage/report/intellij/verifier/CoverageRuleWithThreshold;", "(Lcom/intellij/rt/coverage/data/ProjectData;Lio/github/surpsg/deltacoverage/report/intellij/verifier/CoverageRuleWithThreshold;)V", "getRule$delta_coverage_core", "()Lio/github/surpsg/deltacoverage/report/intellij/verifier/CoverageRuleWithThreshold;", "verify", "", "Lio/github/surpsg/deltacoverage/report/intellij/verifier/CoverageVerifier$Violation;", "Violation", "delta-coverage-core"})
public final class CoverageVerifier {
    @NotNull
    private final ProjectData projectData;
    @NotNull
    private final CoverageRuleWithThreshold rule;

    public CoverageVerifier(@NotNull ProjectData projectData, @NotNull CoverageRuleWithThreshold rule) {
        Intrinsics.checkNotNullParameter(projectData, "projectData");
        Intrinsics.checkNotNullParameter(rule, "rule");
        this.projectData = projectData;
        this.rule = rule;
    }

    @NotNull
    public final CoverageRuleWithThreshold getRule$delta_coverage_core() {
        return this.rule;
    }

    @NotNull
    public final Iterable<Violation> verify() {
        CoverageViolationsCollector violationsCollector = new CoverageViolationsCollector(this.rule);
        Target.ALL.createTargetProcessor().process(this.projectData, violationsCollector);
        return violationsCollector.getViolations();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0017"}, d2={"Lio/github/surpsg/deltacoverage/report/intellij/verifier/CoverageVerifier$Violation;", "", "coverageTrackType", "", "expectedMinValue", "", "actualValue", "(Ljava/lang/String;DD)V", "getActualValue", "()D", "getCoverageTrackType", "()Ljava/lang/String;", "getExpectedMinValue", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "delta-coverage-core"})
    public static final class Violation {
        @NotNull
        private final String coverageTrackType;
        private final double expectedMinValue;
        private final double actualValue;

        public Violation(@NotNull String coverageTrackType, double expectedMinValue, double actualValue) {
            Intrinsics.checkNotNullParameter(coverageTrackType, "coverageTrackType");
            this.coverageTrackType = coverageTrackType;
            this.expectedMinValue = expectedMinValue;
            this.actualValue = actualValue;
        }

        @NotNull
        public final String getCoverageTrackType() {
            return this.coverageTrackType;
        }

        public final double getExpectedMinValue() {
            return this.expectedMinValue;
        }

        public final double getActualValue() {
            return this.actualValue;
        }

        @NotNull
        public final String component1() {
            return this.coverageTrackType;
        }

        public final double component2() {
            return this.expectedMinValue;
        }

        public final double component3() {
            return this.actualValue;
        }

        @NotNull
        public final Violation copy(@NotNull String coverageTrackType, double expectedMinValue, double actualValue) {
            Intrinsics.checkNotNullParameter(coverageTrackType, "coverageTrackType");
            return new Violation(coverageTrackType, expectedMinValue, actualValue);
        }

        public static /* synthetic */ Violation copy$default(Violation violation, String string, double d, double d2, int n, Object object) {
            if ((n & 1) != 0) {
                string = violation.coverageTrackType;
            }
            if ((n & 2) != 0) {
                d = violation.expectedMinValue;
            }
            if ((n & 4) != 0) {
                d2 = violation.actualValue;
            }
            return violation.copy(string, d, d2);
        }

        @NotNull
        public String toString() {
            return "Violation(coverageTrackType=" + this.coverageTrackType + ", expectedMinValue=" + this.expectedMinValue + ", actualValue=" + this.actualValue + ')';
        }

        public int hashCode() {
            int result = this.coverageTrackType.hashCode();
            result = result * 31 + Double.hashCode(this.expectedMinValue);
            result = result * 31 + Double.hashCode(this.actualValue);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Violation)) {
                return false;
            }
            Violation violation = (Violation)other;
            if (!Intrinsics.areEqual(this.coverageTrackType, violation.coverageTrackType)) {
                return false;
            }
            if (Double.compare(this.expectedMinValue, violation.expectedMinValue) != 0) {
                return false;
            }
            return Double.compare(this.actualValue, violation.actualValue) == 0;
        }
    }
}

