/*
 * Decompiled with CFR 0.152.
 */
package io.github.surpsg.deltacoverage.gradle.sources.lookup;

import io.github.surpsg.deltacoverage.gradle.sources.lookup.CacheableLookupSources;
import io.github.surpsg.deltacoverage.gradle.sources.lookup.KoverPluginSourcesLookup;
import io.github.surpsg.deltacoverage.gradle.sources.lookup.SourcesAutoLookup;
import java.io.File;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0014\u0010\t\u001a\u00020\n*\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012*\b\u0012\u0004\u0012\u00020\u00130\u00142\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J,\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016*\b\u0012\u0004\u0012\u00020\u00130\u00142\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\f\u0010\u001a\u001a\u00020\u000f*\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/github/surpsg/deltacoverage/gradle/sources/lookup/KoverPluginSourcesLookup;", "Lio/github/surpsg/deltacoverage/gradle/sources/lookup/CacheableLookupSources;", "fileSystem", "Ljava/nio/file/FileSystem;", "lookupContext", "Lio/github/surpsg/deltacoverage/gradle/sources/lookup/SourcesAutoLookup$Context;", "(Ljava/nio/file/FileSystem;Lio/github/surpsg/deltacoverage/gradle/sources/lookup/SourcesAutoLookup$Context;)V", "lookupSources", "Lio/github/surpsg/deltacoverage/gradle/sources/lookup/SourcesAutoLookup$AutoDetectedSources;", "applyKoverOutputs", "", "koverGenerateArtifactsTask", "Lorg/gradle/api/Task;", "parseArtifactFile", "Lio/github/surpsg/deltacoverage/gradle/sources/lookup/KoverPluginSourcesLookup$KoverArtifacts;", "Ljava/nio/file/Path;", "rootProjectPath", "readArtifactsSection", "", "", "", "readUntil", "Lkotlin/sequences/Sequence;", "interruptCondition", "Lkotlin/Function1;", "", "resolveRootProjectDirPath", "Companion", "KoverArtifacts", "delta-coverage-gradle"})
@SourceDebugExtension(value={"SMAP\nKoverPluginSourcesLookup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KoverPluginSourcesLookup.kt\nio/github/surpsg/deltacoverage/gradle/sources/lookup/KoverPluginSourcesLookup\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,102:1\n1284#2,3:103\n1313#2,2:106\n*S KotlinDebug\n*F\n+ 1 KoverPluginSourcesLookup.kt\nio/github/surpsg/deltacoverage/gradle/sources/lookup/KoverPluginSourcesLookup\n*L\n23#1:103,3\n43#1:106,2\n*E\n"})
public final class KoverPluginSourcesLookup
extends CacheableLookupSources {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    public static final String KOVER_GENERATE_ARTIFACTS_TASK_NAME = "koverGenerateArtifact";
    @NotNull
    public static final String KOVER_ARTIFACTS_FILE_NAME = "default.artifact";
    @NotNull
    private static final Logger log;

    public KoverPluginSourcesLookup(@NotNull FileSystem fileSystem, @NotNull SourcesAutoLookup.Context lookupContext) {
        Intrinsics.checkNotNullParameter(fileSystem, "fileSystem");
        Intrinsics.checkNotNullParameter(lookupContext, "lookupContext");
        super(lookupContext);
        this.fileSystem = fileSystem;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SourcesAutoLookup.AutoDetectedSources lookupSources(@NotNull SourcesAutoLookup.Context lookupContext) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(lookupContext, "lookupContext");
        Set set = lookupContext.getProject().getAllprojects();
        Intrinsics.checkNotNullExpressionValue(set, "getAllprojects(...)");
        Sequence sequence = SequencesKt.filterNotNull(SequencesKt.map(CollectionsKt.asSequence(set), lookupSources.1.INSTANCE));
        SourcesAutoLookup.AutoDetectedSources initial$iv = SourcesAutoLookup.Companion.newAutoDetectedSources(lookupContext.getObjectFactory());
        boolean $i$f$fold = false;
        SourcesAutoLookup.AutoDetectedSources accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            SourcesAutoLookup.AutoDetectedSources autoDetectedSources;
            void koverGenerateArtifactsTask;
            Task task = (Task)element$iv;
            SourcesAutoLookup.AutoDetectedSources koverInputs = accumulator$iv;
            boolean bl = false;
            log.debug("Found Kover configuration in gradle project '{}'", (Object)koverGenerateArtifactsTask.getProject().getName());
            SourcesAutoLookup.AutoDetectedSources $this$lookupSources_u24lambda_u241_u24lambda_u240 = autoDetectedSources = koverInputs;
            boolean bl2 = false;
            Intrinsics.checkNotNull(koverGenerateArtifactsTask);
            this.applyKoverOutputs($this$lookupSources_u24lambda_u241_u24lambda_u240, (Task)koverGenerateArtifactsTask);
            accumulator$iv = autoDetectedSources;
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final void applyKoverOutputs(SourcesAutoLookup.AutoDetectedSources $this$applyKoverOutputs, Task koverGenerateArtifactsTask) {
        void $this$forEach$iv;
        Path rootProjectPath = this.resolveRootProjectDirPath(koverGenerateArtifactsTask);
        FileCollection fileCollection = koverGenerateArtifactsTask.getOutputs().getFiles();
        Intrinsics.checkNotNullExpressionValue(fileCollection, "getFiles(...)");
        Sequence sequence = SequencesKt.mapNotNull(SequencesKt.take(SequencesKt.filter(SequencesKt.map(CollectionsKt.asSequence((Iterable)fileCollection), (Function1)new Function1<File, Path>(this){
            final /* synthetic */ KoverPluginSourcesLookup this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Path invoke(File it) {
                return KoverPluginSourcesLookup.access$getFileSystem$p(this.this$0).getPath(it.getAbsolutePath(), new String[0]);
            }
        }), applyKoverOutputs.2.INSTANCE), 1), (Function1)new Function1<Path, KoverArtifacts>(this, rootProjectPath){
            final /* synthetic */ KoverPluginSourcesLookup this$0;
            final /* synthetic */ Path $rootProjectPath;
            {
                this.this$0 = $receiver;
                this.$rootProjectPath = $rootProjectPath;
                super(1);
            }

            @Nullable
            public final KoverArtifacts invoke(Path it) {
                Intrinsics.checkNotNull(it);
                return KoverPluginSourcesLookup.access$parseArtifactFile(this.this$0, it, this.$rootProjectPath);
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KoverArtifacts it = (KoverArtifacts)element$iv;
            boolean bl = false;
            Object[] objectArray = new Object[]{it.getCoverageBinaries()};
            $this$applyKoverOutputs.getAllBinaryCoverageFiles().from(objectArray);
            objectArray = new Object[]{it.getClassFiles()};
            $this$applyKoverOutputs.getAllClasses().from(objectArray);
            objectArray = new Object[]{it.getSources()};
            $this$applyKoverOutputs.getAllSources().from(objectArray);
        }
    }

    private final Path resolveRootProjectDirPath(Task $this$resolveRootProjectDirPath) {
        Path path2 = this.fileSystem.getPath($this$resolveRootProjectDirPath.getProject().getRootProject().getLayout().getProjectDirectory().getAsFile().getAbsolutePath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue(path2, "getPath(...)");
        return path2;
    }

    private final KoverArtifacts parseArtifactFile(Path $this$parseArtifactFile, Path rootProjectPath) {
        KoverArtifacts koverArtifacts;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists($this$parseArtifactFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Path path2 = $this$parseArtifactFile;
            List<String> list = Files.readAllLines(path2, Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue(list, "readAllLines(...)");
            Iterator<String> iterator2 = list.iterator();
            Set<String> sources2 = this.readArtifactsSection(iterator2, rootProjectPath);
            Set<String> outputs2 = this.readArtifactsSection(iterator2, rootProjectPath);
            Set<String> coverageBinaries = this.readArtifactsSection(iterator2, rootProjectPath);
            koverArtifacts = new KoverArtifacts(coverageBinaries, outputs2, sources2);
        } else {
            koverArtifacts = null;
        }
        return koverArtifacts;
    }

    private final Set<String> readArtifactsSection(Iterator<String> $this$readArtifactsSection, Path rootProjectPath) {
        return SequencesKt.toSet(SequencesKt.map(SequencesKt.filter(SequencesKt.map(this.readUntil($this$readArtifactsSection, readArtifactsSection.1.INSTANCE), (Function1)new Function1<String, Path>(rootProjectPath){
            final /* synthetic */ Path $rootProjectPath;
            {
                this.$rootProjectPath = $rootProjectPath;
                super(1);
            }

            public final Path invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.$rootProjectPath.resolve(it);
            }
        }), readArtifactsSection.3.INSTANCE), readArtifactsSection.4.INSTANCE));
    }

    private final Sequence<String> readUntil(Iterator<String> $this$readUntil, Function1<? super String, Boolean> interruptCondition) {
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object>($this$readUntil, interruptCondition, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Iterator<String> $this_readUntil;
            final /* synthetic */ Function1<String, Boolean> $interruptCondition;
            {
                this.$this_readUntil = $receiver;
                this.$interruptCondition = $interruptCondition;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
lbl6:
                        // 3 sources

                        while (this.$this_readUntil.hasNext() && !this.$interruptCondition.invoke(next = this.$this_readUntil.next()).booleanValue()) {
                            this.L$0 = $this$sequence;
                            this.label = 1;
                            v0 = $this$sequence.yield(next, this);
                            if (v0 != var4_2) continue;
                            return var4_2;
                        }
                        break;
                    }
                    case 1: {
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
                        ** GOTO lbl6
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            @Nullable
            public final Object invoke(@NotNull SequenceScope<? super String> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    public static final /* synthetic */ FileSystem access$getFileSystem$p(KoverPluginSourcesLookup $this) {
        return $this.fileSystem;
    }

    public static final /* synthetic */ KoverArtifacts access$parseArtifactFile(KoverPluginSourcesLookup $this, Path $receiver, Path rootProjectPath) {
        return $this.parseArtifactFile($receiver, rootProjectPath);
    }

    static {
        Logger logger = LoggerFactory.getLogger(KoverPluginSourcesLookup.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        log = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lio/github/surpsg/deltacoverage/gradle/sources/lookup/KoverPluginSourcesLookup$Companion;", "", "()V", "KOVER_ARTIFACTS_FILE_NAME", "", "KOVER_GENERATE_ARTIFACTS_TASK_NAME", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "delta-coverage-gradle"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J9\u0010\u000f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lio/github/surpsg/deltacoverage/gradle/sources/lookup/KoverPluginSourcesLookup$KoverArtifacts;", "", "coverageBinaries", "", "", "classFiles", "sources", "(Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;)V", "getClassFiles", "()Ljava/util/Set;", "getCoverageBinaries", "getSources", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "delta-coverage-gradle"})
    private static final class KoverArtifacts {
        @NotNull
        private final Set<String> coverageBinaries;
        @NotNull
        private final Set<String> classFiles;
        @NotNull
        private final Set<String> sources;

        public KoverArtifacts(@NotNull Set<String> coverageBinaries, @NotNull Set<String> classFiles, @NotNull Set<String> sources2) {
            Intrinsics.checkNotNullParameter(coverageBinaries, "coverageBinaries");
            Intrinsics.checkNotNullParameter(classFiles, "classFiles");
            Intrinsics.checkNotNullParameter(sources2, "sources");
            this.coverageBinaries = coverageBinaries;
            this.classFiles = classFiles;
            this.sources = sources2;
        }

        @NotNull
        public final Set<String> getCoverageBinaries() {
            return this.coverageBinaries;
        }

        @NotNull
        public final Set<String> getClassFiles() {
            return this.classFiles;
        }

        @NotNull
        public final Set<String> getSources() {
            return this.sources;
        }

        @NotNull
        public final Set<String> component1() {
            return this.coverageBinaries;
        }

        @NotNull
        public final Set<String> component2() {
            return this.classFiles;
        }

        @NotNull
        public final Set<String> component3() {
            return this.sources;
        }

        @NotNull
        public final KoverArtifacts copy(@NotNull Set<String> coverageBinaries, @NotNull Set<String> classFiles, @NotNull Set<String> sources2) {
            Intrinsics.checkNotNullParameter(coverageBinaries, "coverageBinaries");
            Intrinsics.checkNotNullParameter(classFiles, "classFiles");
            Intrinsics.checkNotNullParameter(sources2, "sources");
            return new KoverArtifacts(coverageBinaries, classFiles, sources2);
        }

        public static /* synthetic */ KoverArtifacts copy$default(KoverArtifacts koverArtifacts, Set set, Set set2, Set set3, int n, Object object) {
            if ((n & 1) != 0) {
                set = koverArtifacts.coverageBinaries;
            }
            if ((n & 2) != 0) {
                set2 = koverArtifacts.classFiles;
            }
            if ((n & 4) != 0) {
                set3 = koverArtifacts.sources;
            }
            return koverArtifacts.copy(set, set2, set3);
        }

        @NotNull
        public String toString() {
            return "KoverArtifacts(coverageBinaries=" + this.coverageBinaries + ", classFiles=" + this.classFiles + ", sources=" + this.sources + ')';
        }

        public int hashCode() {
            int result = ((Object)this.coverageBinaries).hashCode();
            result = result * 31 + ((Object)this.classFiles).hashCode();
            result = result * 31 + ((Object)this.sources).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof KoverArtifacts)) {
                return false;
            }
            KoverArtifacts koverArtifacts = (KoverArtifacts)other;
            if (!Intrinsics.areEqual(this.coverageBinaries, koverArtifacts.coverageBinaries)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.classFiles, koverArtifacts.classFiles)) {
                return false;
            }
            return Intrinsics.areEqual(this.sources, koverArtifacts.sources);
        }
    }
}

