/*
 * Decompiled with CFR 0.152.
 */
package io.github.surpsg.deltacoverage.diff.parse;

import io.github.surpsg.deltacoverage.diff.parse.ModifiedLinesDiffParser;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.eclipse.jgit.util.QuotedString;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\b\n\u0000\n\u0002\u0010*\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J&\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fJ\u0018\u0010\r\u001a\u0004\u0018\u00010\b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J$\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\bH\u0002J0\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\b2\u0014\b\u0002\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\bH\u0002J\f\u0010\u0019\u001a\u00020\u001a*\u00020\bH\u0002J\f\u0010\u001b\u001a\u00020\u001a*\u00020\bH\u0002J\f\u0010\u001c\u001a\u00020\u001a*\u00020\bH\u0002J\f\u0010\u001d\u001a\u00020\u001a*\u00020\bH\u0002\u00a8\u0006\u001f"}, d2={"Lio/github/surpsg/deltacoverage/diff/parse/ModifiedLinesDiffParser;", "", "()V", "collectFilesChangedLines", "", "", "iterator", "", "", "collectModifiedLines", "", "lines", "", "moveToNextFile", "obtainFilesAddedOrUpdatedLines", "fileOffset", "parseFileDiffBlockOffset", "line", "parseFilePath", "pattern", "Ljava/util/regex/Pattern;", "diffFilePath", "pathMapper", "Lkotlin/Function1;", "parseFileRelativePath", "isLineAdded", "", "isLineDeleted", "isNoModLine", "isNoNewLineAtEndOfFile", "Companion", "delta-coverage-core"})
@SourceDebugExtension(value={"SMAP\nModifiedLinesDiffParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModifiedLinesDiffParser.kt\nio/github/surpsg/deltacoverage/diff/parse/ModifiedLinesDiffParser\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,135:1\n215#2,2:136\n*S KotlinDebug\n*F\n+ 1 ModifiedLinesDiffParser.kt\nio/github/surpsg/deltacoverage/diff/parse/ModifiedLinesDiffParser\n*L\n25#1:136,2\n*E\n"})
public final class ModifiedLinesDiffParser {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final Pattern FILE_OFFSET_PATTERN;
    @NotNull
    private static final Pattern FILE_RELATIVE_PATH_PATTERN;
    @NotNull
    private static final Pattern FILE_RELATIVE_PATH_QUOTED_PATTERN;
    private static final Logger log;
    @Deprecated
    public static final char ADDED_LINE_SIGN = '+';
    @Deprecated
    public static final char DELETED_LINE_SIGN = '-';
    @Deprecated
    public static final char NO_MOD_LINE_SIGN = ' ';
    @Deprecated
    @NotNull
    public static final String NO_NEW_LINE_AT_END_OF_FILE = "\\ No newline at end of file";
    @Deprecated
    @NotNull
    public static final String FILE_NAME_FROM_SIGNS = "--- ";
    @Deprecated
    @NotNull
    public static final String FILE_NAME_TO_SIGNS = "+++ ";
    @Deprecated
    @NotNull
    public static final String HUNK_RANGE_INFO_SIGNS = "@@";

    @NotNull
    public final Map<String, Set<Integer>> collectModifiedLines(@NotNull List<String> lines) {
        Intrinsics.checkNotNullParameter(lines, "lines");
        ListIterator<String> iterator2 = lines.listIterator();
        HashMap fileNameToChangedLines = new HashMap();
        while (iterator2.hasNext()) {
            String patchedFileRow;
            if (this.moveToNextFile(iterator2) == null) {
                return fileNameToChangedLines;
            }
            String patchedFileRelativePath = this.parseFileRelativePath(patchedFileRow);
            log.debug("Found modified file: " + patchedFileRelativePath);
            Set<Integer> fileChangedLines = this.collectFilesChangedLines(iterator2);
            if (!(!((Collection)fileChangedLines).isEmpty())) continue;
            ((Map)fileNameToChangedLines).put(patchedFileRelativePath, fileChangedLines);
        }
        Map $this$forEach$iv = fileNameToChangedLines;
        boolean $i$f$forEach = false;
        Iterator iterator3 = $this$forEach$iv.entrySet().iterator();
        while (iterator3.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator3.next();
            boolean bl = false;
            String file = (String)entry.getKey();
            Set rows = (Set)entry.getValue();
            log.debug("File " + file + " has " + rows.size() + " modified lines");
        }
        return fileNameToChangedLines;
    }

    private final String parseFileRelativePath(String diffFilePath) {
        String parsedPath2;
        String string = ModifiedLinesDiffParser.parseFilePath$default(this, FILE_RELATIVE_PATH_PATTERN, diffFilePath, null, 4, null);
        if (string == null) {
            QuotedString.GitPathStyle gitPathStyle = QuotedString.GIT_PATH;
            Intrinsics.checkNotNullExpressionValue(gitPathStyle, "GIT_PATH");
            string = this.parseFilePath(FILE_RELATIVE_PATH_QUOTED_PATTERN, diffFilePath, (Function1<? super String, String>)new Function1<String, String>((Object)gitPathStyle){

                public final String invoke(String p0) {
                    return ((QuotedString.GitPathStyle)this.receiver).dequote(p0);
                }
            });
        }
        String string2 = parsedPath2 = string;
        if (string2 == null) {
            throw new IllegalArgumentException("Couldn't parse file relative path: " + diffFilePath);
        }
        return string2;
    }

    private final String parseFilePath(Pattern pattern, String diffFilePath, Function1<? super String, String> pathMapper) {
        String string;
        Matcher matcher = pattern.matcher(diffFilePath);
        if (matcher.find()) {
            String string2 = matcher.group(1);
            Intrinsics.checkNotNullExpressionValue(string2, "group(...)");
            string = pathMapper.invoke(string2);
        } else {
            string = null;
        }
        return string;
    }

    static /* synthetic */ String parseFilePath$default(ModifiedLinesDiffParser modifiedLinesDiffParser, Pattern pattern, String string, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = parseFilePath.1.INSTANCE;
        }
        return modifiedLinesDiffParser.parseFilePath(pattern, string, function1);
    }

    private final String moveToNextFile(ListIterator<String> iterator2) {
        while (iterator2.hasNext()) {
            String next = iterator2.next();
            if (!StringsKt.startsWith$default(next, FILE_NAME_TO_SIGNS, false, 2, null)) continue;
            return next;
        }
        return null;
    }

    private final Set<Integer> collectFilesChangedLines(ListIterator<String> iterator2) {
        String nextLine;
        HashSet fileChangedLines = new HashSet();
        while (iterator2.hasNext() && StringsKt.startsWith$default(nextLine = iterator2.next(), HUNK_RANGE_INFO_SIGNS, false, 2, null)) {
            int fileOffset = this.parseFileDiffBlockOffset(nextLine);
            CollectionsKt.addAll((Collection)fileChangedLines, (Iterable)this.obtainFilesAddedOrUpdatedLines(iterator2, fileOffset));
        }
        return fileChangedLines;
    }

    private final int parseFileDiffBlockOffset(String line2) {
        Matcher matcher = FILE_OFFSET_PATTERN.matcher(line2);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Couldn't parse file's range information: " + line2);
        }
        String string = matcher.group(1);
        Intrinsics.checkNotNullExpressionValue(string, "group(...)");
        return Integer.parseInt(string);
    }

    private final Set<Integer> obtainFilesAddedOrUpdatedLines(ListIterator<String> iterator2, int fileOffset) {
        HashSet modifiedOrAddedLinesNumbers = new HashSet();
        int lineNumber = fileOffset;
        while (iterator2.hasNext()) {
            String line2 = iterator2.next();
            if (this.isLineAdded(line2)) {
                Integer n = lineNumber;
                ((Collection)modifiedOrAddedLinesNumbers).add(n);
            } else if (this.isLineDeleted(line2)) {
                --lineNumber;
            } else if (!this.isNoNewLineAtEndOfFile(line2) && ((CharSequence)line2).length() > 0 && !this.isNoModLine(line2)) {
                iterator2.previous();
                return modifiedOrAddedLinesNumbers;
            }
            ++lineNumber;
        }
        return modifiedOrAddedLinesNumbers;
    }

    private final boolean isLineAdded(String $this$isLineAdded) {
        return StringsKt.startsWith$default((CharSequence)$this$isLineAdded, '+', false, 2, null);
    }

    private final boolean isLineDeleted(String $this$isLineDeleted) {
        return StringsKt.startsWith$default((CharSequence)$this$isLineDeleted, '-', false, 2, null) && !StringsKt.startsWith$default($this$isLineDeleted, FILE_NAME_FROM_SIGNS, false, 2, null);
    }

    private final boolean isNoModLine(String $this$isNoModLine) {
        return StringsKt.startsWith$default((CharSequence)$this$isNoModLine, ' ', false, 2, null);
    }

    private final boolean isNoNewLineAtEndOfFile(String $this$isNoNewLineAtEndOfFile) {
        return StringsKt.startsWith$default($this$isNoNewLineAtEndOfFile, NO_NEW_LINE_AT_END_OF_FILE, false, 2, null);
    }

    static {
        Pattern pattern = Pattern.compile("^@@.*\\+(\\d+)(,\\d+)? @@");
        Intrinsics.checkNotNull(pattern);
        FILE_OFFSET_PATTERN = pattern;
        Pattern pattern2 = Pattern.compile("^\\+\\+\\+\\s([^\"][^\\t]*)([\\t]+.*)?$");
        Intrinsics.checkNotNull(pattern2);
        FILE_RELATIVE_PATH_PATTERN = pattern2;
        Pattern pattern3 = Pattern.compile("^\\+\\+\\+\\s(\".+?\")\\s*\\t*.*$");
        Intrinsics.checkNotNull(pattern3);
        FILE_RELATIVE_PATH_QUOTED_PATTERN = pattern3;
        log = LoggerFactory.getLogger(ModifiedLinesDiffParser.class);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u000e\u0010\u0011\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lio/github/surpsg/deltacoverage/diff/parse/ModifiedLinesDiffParser$Companion;", "", "()V", "ADDED_LINE_SIGN", "", "DELETED_LINE_SIGN", "FILE_NAME_FROM_SIGNS", "", "FILE_NAME_TO_SIGNS", "FILE_OFFSET_PATTERN", "Ljava/util/regex/Pattern;", "getFILE_OFFSET_PATTERN", "()Ljava/util/regex/Pattern;", "FILE_RELATIVE_PATH_PATTERN", "getFILE_RELATIVE_PATH_PATTERN", "FILE_RELATIVE_PATH_QUOTED_PATTERN", "getFILE_RELATIVE_PATH_QUOTED_PATTERN", "HUNK_RANGE_INFO_SIGNS", "NO_MOD_LINE_SIGN", "NO_NEW_LINE_AT_END_OF_FILE", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "delta-coverage-core"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pattern getFILE_OFFSET_PATTERN() {
            return FILE_OFFSET_PATTERN;
        }

        @NotNull
        public final Pattern getFILE_RELATIVE_PATH_PATTERN() {
            return FILE_RELATIVE_PATH_PATTERN;
        }

        @NotNull
        public final Pattern getFILE_RELATIVE_PATH_QUOTED_PATTERN() {
            return FILE_RELATIVE_PATH_QUOTED_PATTERN;
        }

        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

