/*
 * Decompiled with CFR 0.152.
 */
package io.github.surpsg.deltacoverage.diff;

import io.github.surpsg.deltacoverage.diff.DiffSource;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lio/github/surpsg/deltacoverage/diff/FileDiffSource;", "Lio/github/surpsg/deltacoverage/diff/DiffSource;", "filePath", "", "(Ljava/lang/String;)V", "sourceDescription", "getSourceDescription", "()Ljava/lang/String;", "pullDiff", "", "saveDiffTo", "Ljava/io/File;", "dir", "delta-coverage-core"})
public final class FileDiffSource
implements DiffSource {
    @NotNull
    private final String filePath;
    @NotNull
    private final String sourceDescription;

    public FileDiffSource(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter(filePath, "filePath");
        this.filePath = filePath;
        this.sourceDescription = "File: " + this.filePath;
    }

    @Override
    @NotNull
    public String getSourceDescription() {
        return this.sourceDescription;
    }

    @Override
    @NotNull
    public List<String> pullDiff() {
        File file = new File(this.filePath);
        if (!file.exists() || !file.isFile()) {
            throw new RuntimeException('\'' + this.filePath + "' not a file or doesn't exist");
        }
        return FilesKt.readLines$default(file, null, 1, null);
    }

    @Override
    @NotNull
    public File saveDiffTo(@NotNull File dir) {
        Intrinsics.checkNotNullParameter(dir, "dir");
        return FilesKt.copyTo$default(new File(this.filePath), FilesKt.resolve(dir, "diff.patch"), true, 0, 4, null);
    }
}

