/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.verify;

import com.intellij.rt.coverage.data.BranchData;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.data.instructions.ClassInstructions;
import com.intellij.rt.coverage.data.instructions.LineInstructions;
import com.intellij.rt.coverage.verify.TargetProcessor;
import com.intellij.rt.coverage.verify.Verifier;

public class ProjectTargetProcessor
implements TargetProcessor {
    @Override
    public void process(ProjectData projectData, TargetProcessor.Consumer consumer) {
        Verifier.CollectedCoverage coverage = new Verifier.CollectedCoverage();
        for (ClassData classData : projectData.getClassesCollection()) {
            coverage.add(ProjectTargetProcessor.collectClassCoverage(projectData, classData));
        }
        consumer.consume("all", coverage);
    }

    public static Verifier.CollectedCoverage collectClassCoverage(ProjectData projectData, ClassData classData) {
        ClassInstructions classInstructions = projectData.isInstructionsCoverageEnabled() ? projectData.getInstructions().get(classData.getName()) : null;
        LineInstructions[] instructions = classInstructions == null ? null : classInstructions.getlines();
        Verifier.CollectedCoverage coverage = new Verifier.CollectedCoverage();
        Object[] lines = classData.getLines();
        if (lines == null) {
            return coverage;
        }
        for (LineData lineData : (LineData[])lines) {
            LineInstructions lineInstructions;
            if (lineData == null) continue;
            if (lineData.getHits() > 0) {
                ++coverage.lineCounter.covered;
            } else {
                ++coverage.lineCounter.missed;
            }
            BranchData branchData = lineData.getBranchData();
            if (branchData != null) {
                coverage.branchCounter.covered += (long)branchData.getCoveredBranches();
                coverage.branchCounter.missed += (long)(branchData.getTotalBranches() - branchData.getCoveredBranches());
            }
            LineInstructions lineInstructions2 = lineInstructions = instructions == null || lineData.getLineNumber() >= instructions.length ? null : instructions[lineData.getLineNumber()];
            if (lineInstructions == null) continue;
            BranchData instructionsData = lineInstructions.getInstructionsData(lineData);
            coverage.instructionCounter.covered += (long)instructionsData.getCoveredBranches();
            coverage.instructionCounter.missed += (long)(instructionsData.getTotalBranches() - instructionsData.getCoveredBranches());
        }
        return coverage;
    }
}

