/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.classes;

import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.InstrumentationUtils;
import com.intellij.rt.coverage.instrumentation.filters.classes.ClassSignatureFilter;
import com.intellij.rt.coverage.util.ClassNameUtil;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassIgnoredByAnnotationFilter
implements ClassSignatureFilter {
    private static final String COMPANION_SUFFIX = "$Companion";

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean shouldFilter(ClassReader cr, ProjectData projectData) {
        void var1_2;
        void var3_4;
        boolean ignoredAnonymous = this.isAnonymousClassInIgnoredMethod(cr, projectData);
        List<Pattern> annotations = projectData.getAnnotationsToIgnore();
        if ((annotations == null || annotations.isEmpty()) && !ignoredAnonymous) {
            return false;
        }
        String className = ClassNameUtil.convertToFQName(cr.getClassName());
        boolean ignored = var3_4 != false || this.isIgnoredCompanionObject(className, projectData) || ClassIgnoredByAnnotationFilter.isClassIgnoredByAnnotation(projectData, InstrumentationUtils.getClassAnnotations(cr));
        if (ignored) {
            void var2_3;
            var2_3.getIgnoredStorage().addIgnoredClass(className);
        }
        return (boolean)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isIgnoredCompanionObject(String className, ProjectData projectData) {
        void var1_1;
        void var2_2;
        if (!className.endsWith(COMPANION_SUFFIX)) {
            return false;
        }
        String subjectName = className.substring(0, className.indexOf(COMPANION_SUFFIX));
        return var2_2.getIgnoredStorage().isClassIgnored((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private boolean isAnonymousClassInIgnoredMethod(ClassReader cr, ProjectData projectData) {
        void var1_1;
        void var3_3;
        void var2_2;
        InstrumentationUtils.MethodDescriptor outerMethod = InstrumentationUtils.getOuterClass(cr);
        if (outerMethod == null) {
            return false;
        }
        String ownerName = ClassNameUtil.convertToFQName(outerMethod.owner);
        return var2_2.getIgnoredStorage().isMethodIgnored((String)var3_3, outerMethod.name, var1_1.descriptor);
    }

    public static boolean isClassIgnoredByAnnotation(ProjectData projectData, List<String> classAnnotations) {
        Iterator iterator2;
        List<Pattern> ignoreAnnotations = projectData.getAnnotationsToIgnore();
        if (ignoreAnnotations == null || ignoreAnnotations.isEmpty()) {
            return false;
        }
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            String string = (String)iterator2.next();
            if (!ClassNameUtil.matchesPatterns(string = ClassNameUtil.convertVMNameToFQN(string), ignoreAnnotations)) continue;
            return true;
        }
        return false;
    }
}

