/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.branches;

import com.intellij.rt.coverage.instrumentation.InstrumentationUtils;
import com.intellij.rt.coverage.instrumentation.data.InstrumentationData;
import com.intellij.rt.coverage.instrumentation.data.Key;
import com.intellij.rt.coverage.instrumentation.data.SwitchLabels;
import com.intellij.rt.coverage.instrumentation.filters.KotlinUtils;
import com.intellij.rt.coverage.instrumentation.filters.lines.CoverageFilter;
import org.jetbrains.coverage.org.objectweb.asm.Handle;
import org.jetbrains.coverage.org.objectweb.asm.Label;

public class JavaStringSwitchFilter
extends CoverageFilter {
    private int myState = 0;
    private int mySlot = -1;
    private SwitchLabels mySwitch;

    /*
     * WARNING - void declaration
     */
    public boolean isApplicable(InstrumentationData context) {
        void var1_1;
        int n = InstrumentationUtils.getBytecodeVersion(context.get(Key.CLASS_READER));
        return n >= 51 && !KotlinUtils.isKotlinClass((InstrumentationData)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void visitInsn(int opcode) {
        void var1_1;
        super.visitInsn(opcode);
        if (opcode == 2) {
            this.myState = 1;
            return;
        }
        if (this.myState == 9 && 3 <= opcode && var1_1 <= 8) {
            ++this.myState;
            return;
        }
        this.myState = 0;
    }

    /*
     * WARNING - void declaration
     */
    public void visitIntInsn(int opcode, int operand) {
        void var2_2;
        void var1_1;
        super.visitIntInsn(opcode, operand);
        if (this.myState == 9 && var1_1 == 16 && var2_2 >= 0) {
            ++this.myState;
            return;
        }
        this.myState = 0;
    }

    /*
     * WARNING - void declaration
     */
    public void visitVarInsn(int opcode, int varIndex) {
        void var2_2;
        void var1_1;
        super.visitVarInsn(opcode, varIndex);
        if (this.myState == 1 && opcode == 54) {
            ++this.myState;
            this.mySlot = varIndex;
            return;
        }
        if (this.myState == 10 && opcode == 54 && varIndex == this.mySlot) {
            ++this.myState;
            return;
        }
        if ((this.myState == 2 || this.myState == 5) && opcode == 25) {
            ++this.myState;
            return;
        }
        if (this.myState == 12 && var1_1 == 21 && var2_2 == this.mySlot) {
            ++this.myState;
            return;
        }
        this.myState = 0;
    }

    /*
     * WARNING - void declaration
     */
    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        void var3_3;
        void var2_2;
        void var1_1;
        super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        if (this.myState == 3 && opcode == 182 && "java/lang/String".equals(owner) && "hashCode".equals(name) && "()I".equals(descriptor)) {
            ++this.myState;
            return;
        }
        if (this.myState == 7 && var1_1 == 182 && "java/lang/String".equals(var2_2) && "equals".equals(var3_3) && "(Ljava/lang/Object;)Z".equals(descriptor)) {
            ++this.myState;
            return;
        }
        this.myState = 0;
    }

    /*
     * WARNING - void declaration
     */
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.visitSwitch(dflt, labels);
        super.visitTableSwitchInsn((int)var1_1, (int)var2_2, (Label)var3_3, labels);
    }

    /*
     * WARNING - void declaration
     */
    public void visitLookupSwitchInsn(Label dflt, int[] keys2, Label[] labels) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.visitSwitch(dflt, labels);
        super.visitLookupSwitchInsn((Label)var1_1, (int[])var2_2, (Label[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void visitSwitch(Label dflt, Label[] labels) {
        if (this.myState == 4) {
            void var2_2;
            void var1_1;
            ++this.myState;
            this.mySwitch = new SwitchLabels((Label)var1_1, (Label[])var2_2);
            return;
        }
        if (this.myState == 13 && this.mySwitch != null) {
            this.myState = 0;
            this.myContext.removeLastSwitch();
            return;
        }
        this.myState = 0;
    }

    /*
     * WARNING - void declaration
     */
    public void visitLdcInsn(Object value) {
        void var1_1;
        super.visitLdcInsn(value);
        if (this.myState == 6 && var1_1 instanceof String) {
            ++this.myState;
            return;
        }
        this.myState = 0;
    }

    /*
     * WARNING - void declaration
     */
    public void visitJumpInsn(int opcode, Label label) {
        void var2_2;
        void var1_1;
        super.visitJumpInsn(opcode, label);
        if (this.myState == 8 && opcode == 153 && this.mySwitch != null) {
            ++this.myState;
            this.myContext.removeLastJump();
            return;
        }
        if (this.myState == 11 && var1_1 == 167 && this.mySwitch != null && var2_2 == this.mySwitch.getDefault()) {
            this.myState = 5;
            return;
        }
        this.myState = 0;
    }

    /*
     * WARNING - void declaration
     */
    public void visitLabel(Label label) {
        void var1_1;
        super.visitLabel(label);
        if (this.myState == 11 && this.mySwitch != null && var1_1 == this.mySwitch.getDefault()) {
            ++this.myState;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        void var3_3;
        void var2_2;
        void var1_1;
        super.visitInvokeDynamicInsn((String)var1_1, (String)var2_2, (Handle)var3_3, bootstrapMethodArguments);
        this.myState = 0;
    }

    /*
     * WARNING - void declaration
     */
    public void visitIincInsn(int varIndex, int increment) {
        void var2_2;
        void var1_1;
        super.visitIincInsn((int)var1_1, (int)var2_2);
        this.myState = 0;
    }

    /*
     * WARNING - void declaration
     */
    public void visitTypeInsn(int opcode, String type) {
        void var2_2;
        void var1_1;
        super.visitTypeInsn((int)var1_1, (String)var2_2);
        this.myState = 0;
    }

    /*
     * WARNING - void declaration
     */
    public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
        void var2_2;
        void var1_1;
        super.visitMultiANewArrayInsn((String)var1_1, (int)var2_2);
        this.myState = 0;
    }

    /*
     * WARNING - void declaration
     */
    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        void var3_3;
        void var2_2;
        void var1_1;
        super.visitFieldInsn((int)var1_1, (String)var2_2, (String)var3_3, descriptor);
        this.myState = 0;
    }

    /*
     * WARNING - void declaration
     */
    public void visitLineNumber(int line2, Label start) {
        void var2_2;
        void var1_1;
        super.visitLineNumber((int)var1_1, (Label)var2_2);
        this.myState = 0;
    }
}

