/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrument;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.offline.RawClassData;
import com.intellij.rt.coverage.offline.RawHitsReport;
import com.intellij.rt.coverage.offline.RawProjectData;
import com.intellij.rt.coverage.util.ArrayUtil;
import com.intellij.rt.coverage.util.CommonArrayUtil;
import com.intellij.rt.coverage.util.ErrorReporter;
import java.io.File;
import java.io.IOException;

public class RawReportLoader {
    public static void load(File file, ProjectData projectData) throws IOException {
        RawProjectData rawProjectData = RawHitsReport.load(file);
        RawReportLoader.apply(projectData, rawProjectData);
    }

    public static void apply(ProjectData projectData, RawProjectData rawProjectData) {
        for (RawClassData rawClassData : rawProjectData.getClasses()) {
            ClassData classData = projectData.getClassData(rawClassData.name);
            if (classData == null) {
                ErrorReporter.warn("Tried to apply coverage for class " + rawClassData.name + " but there is no such class in ProjectData");
                continue;
            }
            int[] hits = ArrayUtil.copy(CommonArrayUtil.getIntArray(rawClassData.hits));
            classData.setHitsMask(hits);
            classData.applyHits();
        }
    }
}

