/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrument;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class DirectoryVisitor {
    private final File myRoot;
    private final List<PackageDirectory> stack = new ArrayList<PackageDirectory>();

    public DirectoryVisitor(File root) {
        this.myRoot = root;
        if (!this.myRoot.isDirectory()) {
            throw new IllegalArgumentException("Directory expected: " + this.myRoot.getAbsolutePath());
        }
    }

    public void visitFiles() {
        this.stack.clear();
        this.stack.add(new PackageDirectory(this.myRoot, ""));
        while (!this.stack.isEmpty()) {
            PackageDirectory top = this.stack.remove(this.stack.size() - 1);
            File[] children = top.file.listFiles();
            if (children == null) continue;
            for (File child : children) {
                if (child.isDirectory()) {
                    String packageName = ("".equals(top.packageName) ? "" : top.packageName + ".") + child.getName();
                    this.stack.add(new PackageDirectory(child, packageName));
                    continue;
                }
                this.visitFile(top.packageName, child);
            }
        }
    }

    protected void visitFile(String packageName, File file) {
    }

    private static class PackageDirectory {
        public final File file;
        public final String packageName;

        private PackageDirectory(File file, String packageName) {
            this.file = file;
            this.packageName = packageName;
        }
    }
}

