/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.aggregate;

import com.intellij.rt.coverage.aggregate.GroupPatternFilter;
import com.intellij.rt.coverage.aggregate.api.Request;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.FileMapData;
import com.intellij.rt.coverage.data.JumpData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.data.SwitchData;
import com.intellij.rt.coverage.data.instructions.InstructionsUtil;
import com.intellij.rt.coverage.instrument.RawReportLoader;
import com.intellij.rt.coverage.instrumentation.UnloadedUtil;
import com.intellij.rt.coverage.report.data.BinaryReport;
import com.intellij.rt.coverage.util.CoverageReport;
import com.intellij.rt.coverage.util.ProjectDataLoader;
import com.intellij.rt.coverage.util.classFinder.ClassFilter;
import com.intellij.rt.coverage.util.classFinder.OutputClassFinder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class Aggregator {
    private final List<BinaryReport> myReports;
    private final List<File> myOutputs;
    private final List<Request> myRequests;
    private ProjectData myProjectData;

    public Aggregator(List<BinaryReport> reports2, List<File> outputRoots, List<Request> requests) {
        this.myReports = reports2;
        this.myOutputs = outputRoots;
        this.myRequests = requests;
    }

    public Aggregator(List<BinaryReport> reports2, List<File> outputRoots, Request request) {
        this(reports2, outputRoots, Collections.singletonList(request));
    }

    public ProjectData getProjectData() {
        if (this.myProjectData != null) {
            return this.myProjectData;
        }
        boolean hasRawHitsReport = false;
        for (BinaryReport report : this.myReports) {
            hasRawHitsReport |= report.isRawHitsReport();
        }
        ProjectData projectData = this.collectCoverageInformationFromOutputs();
        ProjectData projectDataCopy = hasRawHitsReport ? Aggregator.copyProjectData(projectData) : null;
        projectData.dropLineMappings();
        for (BinaryReport report : this.myReports) {
            if (report.isRawHitsReport()) {
                try {
                    RawReportLoader.load(report.getDataFile(), projectDataCopy);
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            ProjectData data = ProjectDataLoader.load(report.getDataFile());
            Aggregator.mergeHits(projectData, data);
        }
        if (projectDataCopy != null) {
            projectDataCopy.applyLineMappings();
            Aggregator.mergeHits(projectData, projectDataCopy);
        }
        this.myProjectData = projectData;
        return projectData;
    }

    private static ProjectData copyProjectData(ProjectData projectData) {
        ProjectData projectDataCopy = new ProjectData();
        for (ClassData classData : projectData.getClassesCollection()) {
            ClassData classCopy = projectDataCopy.getOrCreateClassData(classData.getName());
            LineData[] lines = (LineData[])classData.getLines();
            if (lines == null) continue;
            LineData[] linesCopy = new LineData[lines.length];
            classCopy.setLines(linesCopy);
            for (LineData lineData : lines) {
                SwitchData[] switches;
                if (lineData == null) continue;
                LineData lineCopy = new LineData(lineData.getLineNumber(), lineData.getMethodSignature());
                lineCopy.setId(lineData.getId());
                linesCopy[lineCopy.getLineNumber()] = lineCopy;
                JumpData[] jumps = lineData.getJumps();
                if (jumps != null) {
                    for (int i = 0; i < jumps.length; ++i) {
                        JumpData jump = jumps[i];
                        JumpData jumpCopy = lineCopy.addJump(i);
                        jumpCopy.setId(jump.getId(true), true);
                        jumpCopy.setId(jump.getId(false), false);
                    }
                }
                if ((switches = lineData.getSwitches()) != null) {
                    for (int i = 0; i < switches.length; ++i) {
                        SwitchData aSwitch = switches[i];
                        SwitchData switchCopy = lineCopy.addSwitch(i, aSwitch.getKeys());
                        for (int key = -1; key < aSwitch.getKeys().length; ++key) {
                            switchCopy.setId(aSwitch.getId(key), key);
                        }
                    }
                }
                lineCopy.fillArrays();
            }
        }
        Map<String, FileMapData[]> mappings = projectData.getLinesMap();
        if (mappings != null) {
            for (Map.Entry<String, FileMapData[]> entry : mappings.entrySet()) {
                projectDataCopy.addLineMaps(entry.getKey(), entry.getValue());
            }
        }
        return projectDataCopy;
    }

    private static void mergeHits(ProjectData dst, ProjectData src) {
        for (ClassData srcClass : src.getClassesCollection()) {
            ClassData dstClass = dst.getClassData(srcClass.getName());
            if (dstClass == null) continue;
            dstClass.merge(srcClass);
        }
    }

    public void processRequests() {
        ProjectData projectData = this.getProjectData();
        for (Request request : this.myRequests) {
            if (request.outputFile == null) continue;
            ProjectData requestProjectData = new ProjectData();
            requestProjectData.setInstructionsCoverage(true);
            for (ClassData classData : projectData.getClassesCollection()) {
                if (!request.classFilter.shouldInclude(classData.getName())) continue;
                ClassData newClassData = requestProjectData.getOrCreateClassData(classData.getName());
                newClassData.merge(classData);
            }
            InstructionsUtil.merge(projectData, requestProjectData, request.classFilter);
            CoverageReport.save(requestProjectData, request.outputFile, request.smapFile);
        }
    }

    private ProjectData collectCoverageInformationFromOutputs() {
        ProjectData projectData = new ProjectData();
        ArrayList<Pattern> excludeAnnotations = new ArrayList<Pattern>();
        for (Request request : this.myRequests) {
            excludeAnnotations.addAll(request.excludeAnnotations);
        }
        projectData.setInstructionsCoverage(true);
        projectData.setAnnotationsToIgnore(excludeAnnotations);
        UnloadedUtil.appendUnloaded(projectData, this.createClassFinder(), true, true);
        return projectData;
    }

    private OutputClassFinder createClassFinder() {
        ArrayList<ClassFilter.PatternFilter> filters = new ArrayList<ClassFilter.PatternFilter>();
        for (Request request : this.myRequests) {
            filters.add(request.classFilter);
        }
        return new OutputClassFinder(new GroupPatternFilter(filters), this.myOutputs);
    }
}

