/*
 * Decompiled with CFR 0.152.
 */
package io.github.sskorol.data;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.github.sskorol.data.DataReader;
import java.util.Collection;
import one.util.streamex.StreamEx;

public class YamlReader<T>
implements DataReader<T> {
    private final Class<T> entityClass;
    private final String path;

    public YamlReader(Class<T> entityClass) {
        this(entityClass, "");
    }

    @Override
    public StreamEx<T> read() {
        try {
            YAMLFactory yamlFactory = new YAMLFactory();
            return StreamEx.of((Collection)new ObjectMapper((JsonFactory)yamlFactory).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValues((JsonParser)yamlFactory.createParser(this.getUrl()), this.entityClass).readAll());
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(String.format("Unable to read YAML data to %s.", this.entityClass), ex);
        }
    }

    @Override
    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public YamlReader(Class<T> entityClass, String path) {
        this.entityClass = entityClass;
        this.path = path;
    }
}

