/*
 * Decompiled with CFR 0.152.
 */
package io.github.sskorol.data;

import io.github.sskorol.data.DataReader;
import io.github.sskorol.utils.ReflectionUtils;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.joor.Reflect;

public class CsvReader<T>
implements DataReader<T> {
    private final Class<T> entityClass;
    private final String path;

    public CsvReader(Class<T> entityClass) {
        this(entityClass, "");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public StreamEx<T> read() {
        try (CSVParser csvParser = CSVParser.parse((URL)this.getUrl(), (Charset)StandardCharsets.UTF_8, (CSVFormat)CSVFormat.DEFAULT.withFirstRecordAsHeader().withIgnoreHeaderCase().withTrim());){
            List entityFields = StreamEx.of((Object[])this.entityClass.getDeclaredFields()).map(ReflectionUtils::getFieldName).toList();
            StreamEx streamEx = StreamEx.of((Collection)csvParser.getRecords()).map(record -> StreamEx.of((Collection)entityFields).map(arg_0 -> ((CSVRecord)record).get(arg_0)).toArray()).map(args -> Reflect.on(this.entityClass).create(args).get());
            return streamEx;
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(String.format("Unable to read JSON data to %s. Check provided path.", this.entityClass), ex);
        }
    }

    @Override
    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public CsvReader(Class<T> entityClass, String path) {
        this.entityClass = entityClass;
        this.path = path;
    }
}

