/*
 * Decompiled with CFR 0.152.
 */
package io.github.sskorol.core;

import io.github.sskorol.core.DataSupplierInterceptor;
import io.github.sskorol.core.IAnnotationTransformerInterceptor;
import io.github.sskorol.model.DataSupplierMetaData;
import io.github.sskorol.utils.ServiceLoaderUtils;
import io.vavr.API;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Consumer;
import one.util.streamex.StreamEx;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.annotations.IConfigurationAnnotation;
import org.testng.annotations.IDataProviderAnnotation;
import org.testng.annotations.IFactoryAnnotation;
import org.testng.annotations.IListenersAnnotation;
import org.testng.annotations.ITestAnnotation;

@Aspect
public class DataSupplierAspect {
    private static final Logger log = LoggerFactory.getLogger(DataSupplierAspect.class);
    private static final List<DataSupplierInterceptor> DATA_SUPPLIERS = ServiceLoaderUtils.load(DataSupplierInterceptor.class, DataSupplierAspect.class.getClassLoader());
    private static final List<IAnnotationTransformerInterceptor> ANNOTATION_TRANSFORMERS = ServiceLoaderUtils.load(IAnnotationTransformerInterceptor.class, DataSupplierAspect.class.getClassLoader());

    @Before(value="execution(@org.testng.annotations.DataProvider * io.github.sskorol.core.DataProviderTransformer.*(..))")
    public void beforeDataProviderCall(JoinPoint joinPoint) {
        DATA_SUPPLIERS.forEach(ds -> ds.beforeDataPreparation((ITestContext)joinPoint.getArgs()[0], (ITestNGMethod)joinPoint.getArgs()[1]));
    }

    @After(value="execution(@org.testng.annotations.DataProvider * io.github.sskorol.core.DataProviderTransformer.*(..))")
    public void afterDataProviderCall(JoinPoint joinPoint) {
        DATA_SUPPLIERS.forEach(ds -> ds.afterDataPreparation((ITestContext)joinPoint.getArgs()[0], (ITestNGMethod)joinPoint.getArgs()[1]));
    }

    @Around(value="execution(* io.github.sskorol.core.DataProviderTransformer.getMetaData(..))")
    public DataSupplierMetaData onDataPreparation(ProceedingJoinPoint joinPoint) throws Throwable {
        DataSupplierMetaData metaData = (DataSupplierMetaData)joinPoint.proceed(joinPoint.getArgs());
        DATA_SUPPLIERS.forEach(ds -> ds.onDataPreparation(metaData));
        return metaData;
    }

    @Before(value="execution(* io.github.sskorol.core.DataProviderTransformer.transform(..))")
    public void beforeTransformationCall(JoinPoint joinPoint) {
        Object[] args = joinPoint.getArgs();
        API.Match((Object)args[0]).of(new API.Match.Case[]{API.Case((API.Match.Pattern0)API.$(val -> val instanceof ITestAnnotation), arg -> API.run(() -> DataSupplierAspect.callTransformer(at -> at.transform((ITestAnnotation)arg, (Class)args[1], (Constructor)args[2], (Method)args[3])))), API.Case((API.Match.Pattern0)API.$(val -> val instanceof IFactoryAnnotation), arg -> API.run(() -> DataSupplierAspect.callTransformer(at -> at.transform((IFactoryAnnotation)arg, (Method)args[1])))), API.Case((API.Match.Pattern0)API.$(val -> val instanceof IConfigurationAnnotation), arg -> API.run(() -> DataSupplierAspect.callTransformer(at -> at.transform((IConfigurationAnnotation)arg, (Class)args[1], (Constructor)args[2], (Method)args[3])))), API.Case((API.Match.Pattern0)API.$(val -> val instanceof IDataProviderAnnotation), arg -> API.run(() -> DataSupplierAspect.callTransformer(at -> at.transform((IDataProviderAnnotation)arg, (Method)args[1])))), API.Case((API.Match.Pattern0)API.$(val -> val instanceof IListenersAnnotation), arg -> API.run(() -> DataSupplierAspect.callTransformer(at -> at.transform((IListenersAnnotation)arg, (Class)args[1]))))});
    }

    public static List<DataSupplierInterceptor> getInterceptors() {
        return DATA_SUPPLIERS;
    }

    public static List<IAnnotationTransformerInterceptor> getTransformers() {
        return ANNOTATION_TRANSFORMERS;
    }

    private static void callTransformer(Consumer<IAnnotationTransformerInterceptor> condition) {
        StreamEx.of(ANNOTATION_TRANSFORMERS).forEach(condition);
    }
}

