/*
 * Decompiled with CFR 0.152.
 */
package io.github.springboot.httpclient5.core.interceptors;

import io.github.springboot.httpclient5.core.config.HttpClient5Config;
import io.github.springboot.httpclient5.core.config.model.RequestConfigProperties;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import lombok.Generated;
import org.apache.hc.client5.http.async.AsyncExecCallback;
import org.apache.hc.client5.http.async.AsyncExecChain;
import org.apache.hc.client5.http.async.AsyncExecChainHandler;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.nio.AsyncEntityProducer;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=-2147483648)
@Component
public class RequestConfigExecChainHandler
implements ExecChainHandler,
AsyncExecChainHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RequestConfigExecChainHandler.class);
    private final HttpClient5Config config;

    public ClassicHttpResponse execute(ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        try {
            this.configure((HttpRequest)request, scope.clientContext);
        }
        catch (HttpException e) {
            log.warn("Unable to configure httpclient request, no uri available : using defaut configuration", (Throwable)e);
            throw e;
        }
        return chain.proceed(request, scope);
    }

    public void execute(HttpRequest request, AsyncEntityProducer entityProducer, AsyncExecChain.Scope scope, AsyncExecChain chain, AsyncExecCallback asyncExecCallback) throws HttpException, IOException {
        this.configure(request, scope.clientContext);
        chain.proceed(request, entityProducer, scope, asyncExecCallback);
    }

    public void configure(HttpRequest request, HttpClientContext context) throws HttpException {
        try {
            URI uri = request.getUri();
            String method = request.getMethod();
            log.debug("Configuring httpclient for {} {}", (Object)method, (Object)uri);
            RequestConfigProperties requestConfigProperties = this.config.getRequestConfigProperties(method, uri.toString());
            RequestConfig requestConfig = requestConfigProperties.build();
            HttpClientContext.castOrCreate((HttpContext)context).setRequestConfig(requestConfig);
        }
        catch (URISyntaxException e) {
            throw new HttpException(e.getMessage());
        }
    }

    @Generated
    public RequestConfigExecChainHandler(HttpClient5Config config) {
        this.config = config;
    }
}

