/*
 * Decompiled with CFR 0.152.
 */
package io.github.springboot.httpclient5.core.config.model;

import io.github.springboot.httpclient5.core.config.ConfigProvider;
import io.github.springboot.httpclient5.core.config.model.ErrorManagementProperties;
import io.github.springboot.httpclient5.core.config.model.HeadersPropagationProperties;
import io.github.springboot.httpclient5.core.config.model.RetryConfig;
import io.github.springboot.httpclient5.core.config.model.SimplePredefinedCredentialsProvider;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.commons.text.WordUtils;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

public class RequestConfigProperties
implements ConfigProvider<RequestConfig> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RequestConfigProperties.class);
    private static Map<String, Object> DEFAULT_PROPS;
    private RequestConfig.Builder builder = RequestConfig.custom();
    @NestedConfigurationProperty
    private ErrorManagementProperties errorManagement = new ErrorManagementProperties();
    @NestedConfigurationProperty
    private HeadersPropagationProperties headersPropagation = new HeadersPropagationProperties();
    @NestedConfigurationProperty
    private Map<String, Boolean> interceptors = new HashMap<String, Boolean>();
    @NestedConfigurationProperty
    private SimplePredefinedCredentialsProvider credentials;
    @NestedConfigurationProperty
    private RetryConfig retryConfig = new RetryConfig();
    @NestedConfigurationProperty
    private Map<String, String> customRequestContext = new HashMap<String, String>();

    public RequestConfigProperties(RequestConfigProperties origin) {
        if (origin != null) {
            this.builder = RequestConfig.copy((RequestConfig)origin.build());
            this.errorManagement = origin.getErrorManagement().toBuilder().build();
            this.headersPropagation = origin.getHeadersPropagation().toBuilder().build();
            this.retryConfig = origin.getRetryConfig().toBuilder().build();
            this.customRequestContext = new HashMap<String, String>(origin.getCustomRequestContext());
            this.interceptors = new HashMap<String, Boolean>(origin.getInterceptors());
            if (origin.getCredentials() != null) {
                this.credentials = origin.getCredentials().toBuilder().build();
            }
        } else {
            this.builder = RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT);
        }
    }

    @Override
    public RequestConfig get() {
        return this.builder.build();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.JSON_STYLE);
    }

    public RequestConfigProperties apply(RequestConfigProperties other) {
        PropertyUtils.describe((Object)other).entrySet().stream().filter(e -> !Objects.equals(DEFAULT_PROPS.get(e.getKey()), e.getValue())).filter(e -> e.getValue() != null).forEach(e -> {
            log.debug("Applying request config : {} -> {}", e.getKey(), e.getValue());
            if (e.getValue() instanceof Map) {
                Map mapValue = (Map)e.getValue();
                try {
                    Map m = (Map)MethodUtils.invokeMethod((Object)this, (String)("get" + WordUtils.capitalize((String)((String)e.getKey()))));
                    m.putAll(mapValue);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                    log.error("Error applying {}", e.getKey(), (Object)ex);
                }
            } else {
                try {
                    MethodUtils.invokeMethod((Object)this, (String)("set" + WordUtils.capitalize((String)((String)e.getKey()))), (Object[])new Object[]{e.getValue()});
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                    log.error("Error applying {}", e.getKey(), (Object)ex);
                }
            }
        });
        return this;
    }

    @Generated
    public RequestConfigProperties() {
    }

    @Generated
    public ErrorManagementProperties getErrorManagement() {
        return this.errorManagement;
    }

    @Generated
    public void setErrorManagement(ErrorManagementProperties errorManagement) {
        this.errorManagement = errorManagement;
    }

    @Generated
    public HeadersPropagationProperties getHeadersPropagation() {
        return this.headersPropagation;
    }

    @Generated
    public void setHeadersPropagation(HeadersPropagationProperties headersPropagation) {
        this.headersPropagation = headersPropagation;
    }

    @Generated
    public Map<String, Boolean> getInterceptors() {
        return this.interceptors;
    }

    @Generated
    public void setInterceptors(Map<String, Boolean> interceptors) {
        this.interceptors = interceptors;
    }

    @Generated
    public SimplePredefinedCredentialsProvider getCredentials() {
        return this.credentials;
    }

    @Generated
    public void setCredentials(SimplePredefinedCredentialsProvider credentials) {
        this.credentials = credentials;
    }

    @Generated
    public RetryConfig getRetryConfig() {
        return this.retryConfig;
    }

    @Generated
    public void setRetryConfig(RetryConfig retryConfig) {
        this.retryConfig = retryConfig;
    }

    @Generated
    public Map<String, String> getCustomRequestContext() {
        return this.customRequestContext;
    }

    @Generated
    public void setCustomRequestContext(Map<String, String> customRequestContext) {
        this.customRequestContext = customRequestContext;
    }

    @Generated
    public RequestConfig.Builder setExpectContinueEnabled(boolean expectContinueEnabled) {
        return this.builder.setExpectContinueEnabled(expectContinueEnabled);
    }

    @Deprecated
    @Generated
    public RequestConfig.Builder setProxy(HttpHost proxy) {
        return this.builder.setProxy(proxy);
    }

    @Generated
    public RequestConfig.Builder setCookieSpec(String cookieSpec) {
        return this.builder.setCookieSpec(cookieSpec);
    }

    @Generated
    public RequestConfig.Builder setRedirectsEnabled(boolean redirectsEnabled) {
        return this.builder.setRedirectsEnabled(redirectsEnabled);
    }

    @Generated
    public RequestConfig.Builder setCircularRedirectsAllowed(boolean circularRedirectsAllowed) {
        return this.builder.setCircularRedirectsAllowed(circularRedirectsAllowed);
    }

    @Generated
    public RequestConfig.Builder setMaxRedirects(int maxRedirects) {
        return this.builder.setMaxRedirects(maxRedirects);
    }

    @Generated
    public RequestConfig.Builder setAuthenticationEnabled(boolean authenticationEnabled) {
        return this.builder.setAuthenticationEnabled(authenticationEnabled);
    }

    @Generated
    public RequestConfig.Builder setTargetPreferredAuthSchemes(Collection<String> targetPreferredAuthSchemes) {
        return this.builder.setTargetPreferredAuthSchemes(targetPreferredAuthSchemes);
    }

    @Generated
    public RequestConfig.Builder setProxyPreferredAuthSchemes(Collection<String> proxyPreferredAuthSchemes) {
        return this.builder.setProxyPreferredAuthSchemes(proxyPreferredAuthSchemes);
    }

    @Generated
    public RequestConfig.Builder setConnectionRequestTimeout(Timeout connectionRequestTimeout) {
        return this.builder.setConnectionRequestTimeout(connectionRequestTimeout);
    }

    @Generated
    public RequestConfig.Builder setConnectionRequestTimeout(long connectionRequestTimeout, TimeUnit timeUnit) {
        return this.builder.setConnectionRequestTimeout(connectionRequestTimeout, timeUnit);
    }

    @Deprecated
    @Generated
    public RequestConfig.Builder setConnectTimeout(Timeout connectTimeout) {
        return this.builder.setConnectTimeout(connectTimeout);
    }

    @Deprecated
    @Generated
    public RequestConfig.Builder setConnectTimeout(long connectTimeout, TimeUnit timeUnit) {
        return this.builder.setConnectTimeout(connectTimeout, timeUnit);
    }

    @Generated
    public RequestConfig.Builder setResponseTimeout(Timeout responseTimeout) {
        return this.builder.setResponseTimeout(responseTimeout);
    }

    @Generated
    public RequestConfig.Builder setResponseTimeout(long responseTimeout, TimeUnit timeUnit) {
        return this.builder.setResponseTimeout(responseTimeout, timeUnit);
    }

    @Generated
    public RequestConfig.Builder setConnectionKeepAlive(TimeValue connectionKeepAlive) {
        return this.builder.setConnectionKeepAlive(connectionKeepAlive);
    }

    @Generated
    public RequestConfig.Builder setDefaultKeepAlive(long defaultKeepAlive, TimeUnit timeUnit) {
        return this.builder.setDefaultKeepAlive(defaultKeepAlive, timeUnit);
    }

    @Generated
    public RequestConfig.Builder setContentCompressionEnabled(boolean contentCompressionEnabled) {
        return this.builder.setContentCompressionEnabled(contentCompressionEnabled);
    }

    @Generated
    public RequestConfig.Builder setHardCancellationEnabled(boolean hardCancellationEnabled) {
        return this.builder.setHardCancellationEnabled(hardCancellationEnabled);
    }

    @Generated
    public RequestConfig.Builder setProtocolUpgradeEnabled(boolean protocolUpgradeEnabled) {
        return this.builder.setProtocolUpgradeEnabled(protocolUpgradeEnabled);
    }

    @Generated
    public RequestConfig build() {
        return this.builder.build();
    }

    @Generated
    public boolean isExpectContinueEnabled() {
        return this.get().isExpectContinueEnabled();
    }

    @Deprecated
    @Generated
    public HttpHost getProxy() {
        return this.get().getProxy();
    }

    @Generated
    public String getCookieSpec() {
        return this.get().getCookieSpec();
    }

    @Generated
    public boolean isRedirectsEnabled() {
        return this.get().isRedirectsEnabled();
    }

    @Generated
    public boolean isCircularRedirectsAllowed() {
        return this.get().isCircularRedirectsAllowed();
    }

    @Generated
    public int getMaxRedirects() {
        return this.get().getMaxRedirects();
    }

    @Generated
    public boolean isAuthenticationEnabled() {
        return this.get().isAuthenticationEnabled();
    }

    @Generated
    public Collection<String> getTargetPreferredAuthSchemes() {
        return this.get().getTargetPreferredAuthSchemes();
    }

    @Generated
    public Collection<String> getProxyPreferredAuthSchemes() {
        return this.get().getProxyPreferredAuthSchemes();
    }

    @Generated
    public Timeout getConnectionRequestTimeout() {
        return this.get().getConnectionRequestTimeout();
    }

    @Deprecated
    @Generated
    public Timeout getConnectTimeout() {
        return this.get().getConnectTimeout();
    }

    @Generated
    public Timeout getResponseTimeout() {
        return this.get().getResponseTimeout();
    }

    @Generated
    public TimeValue getConnectionKeepAlive() {
        return this.get().getConnectionKeepAlive();
    }

    @Generated
    public boolean isContentCompressionEnabled() {
        return this.get().isContentCompressionEnabled();
    }

    @Generated
    public boolean isHardCancellationEnabled() {
        return this.get().isHardCancellationEnabled();
    }

    @Generated
    public boolean isProtocolUpgradeEnabled() {
        return this.get().isProtocolUpgradeEnabled();
    }

    static {
        try {
            DEFAULT_PROPS = PropertyUtils.describe((Object)new RequestConfigProperties());
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }
}

