/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.Type;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserExprMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.helpers.LambdaExprHelpers;
import eu.solven.cleanthat.engine.java.refactorer.helpers.MethodCallExprHelpers;
import eu.solven.cleanthat.engine.java.refactorer.meta.ApplyAfterMe;
import eu.solven.cleanthat.engine.java.refactorer.meta.IReApplyUntilNoop;
import eu.solven.cleanthat.engine.java.refactorer.mutators.LambdaReturnsSingleStatement;
import java.util.Optional;
import java.util.Set;

@ApplyAfterMe(value={LambdaReturnsSingleStatement.class})
public class OptionalWrappedVariableToMap
extends AJavaparserExprMutator
implements IReApplyUntilNoop {
    private static final String METHOD_MAP = "map";

    public String minimalJavaVersion() {
        return "1.8";
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"Optional", (Object)"Primitive");
    }

    protected Set<String> getEligibleForUnwrappedMap() {
        return Set.of("ifPresent", "ifPresentOrElse", METHOD_MAP);
    }

    protected Class<?> getExpectedScope() {
        return Optional.class;
    }

    @Override
    protected boolean processExpression(NodeAndSymbolSolver<Expression> expr) {
        if (!expr.getNode().isMethodCallExpr()) {
            return false;
        }
        MethodCallExpr methodCallExpr = expr.getNode().asMethodCallExpr();
        if (!this.getEligibleForUnwrappedMap().contains(methodCallExpr.getNameAsString())) {
            return false;
        }
        if (!MethodCallExprHelpers.scopeHasRequiredType(expr.editNode(methodCallExpr.getScope()), this.getExpectedScope())) {
            return false;
        }
        if (methodCallExpr.getArguments().size() < 1) {
            return false;
        }
        Expression optLambdaExpr = (Expression)methodCallExpr.getArguments().get(0);
        if (!optLambdaExpr.isLambdaExpr()) {
            return false;
        }
        LambdaExpr mapLambdaExpr = optLambdaExpr.asLambdaExpr();
        if (!mapLambdaExpr.getBody().isBlockStmt()) {
            return false;
        }
        if (mapLambdaExpr.getParameters().size() != 1) {
            return false;
        }
        BlockStmt lambdaBlock = mapLambdaExpr.getBody().asBlockStmt();
        if (lambdaBlock.getStatements().size() <= 1) {
            return false;
        }
        Statement firstStatement = lambdaBlock.getStatement(0);
        if (!firstStatement.isExpressionStmt() || !firstStatement.asExpressionStmt().getExpression().isVariableDeclarationExpr()) {
            return false;
        }
        VariableDeclarationExpr variableDeclaratorExpr = firstStatement.asExpressionStmt().getExpression().asVariableDeclarationExpr();
        if (variableDeclaratorExpr.getVariables().size() != 1 || variableDeclaratorExpr.getVariable(0).getInitializer().isEmpty()) {
            return false;
        }
        VariableDeclarator firstVariable = variableDeclaratorExpr.getVariable(0);
        if (((Expression)firstVariable.getInitializer().get()).isNameExpr()) {
            return false;
        }
        Expression mapScope = (Expression)methodCallExpr.getScope().get();
        Optional<String> optMapMethodName = this.computeMapMethodName(expr.editNode(mapScope), variableDeclaratorExpr.getElementType());
        if (optMapMethodName.isEmpty()) {
            return false;
        }
        SimpleName lambdaVariableName = ((Parameter)mapLambdaExpr.getParameters().get(0)).getName();
        String lambdaVariableNameAsString = lambdaVariableName.asString();
        if (variableDeclaratorExpr.findFirst(NameExpr.class, nameExpr -> nameExpr.getNameAsString().equals(lambdaVariableNameAsString)).isEmpty()) {
            return false;
        }
        if (!lambdaBlock.findAll(NameExpr.class, nameExpr -> nameExpr.getNameAsString().equals(lambdaVariableNameAsString) && !this.isAncestor((Node)variableDeclaratorExpr, (Node)nameExpr)).isEmpty()) {
            return false;
        }
        if (!this.tryRemove((Node)firstStatement)) {
            return false;
        }
        if (!LambdaExprHelpers.changeName(mapLambdaExpr, variableDeclaratorExpr.getVariable(0).getName())) {
            return false;
        }
        Optional<LambdaExpr> unwrappedMapLambdaExpr = LambdaExprHelpers.makeLambdaExpr(lambdaVariableName, (Expression)variableDeclaratorExpr.getVariable(0).getInitializer().get());
        if (unwrappedMapLambdaExpr.isEmpty()) {
            return false;
        }
        MethodCallExpr callMap = new MethodCallExpr(mapScope, optMapMethodName.get(), new NodeList((Node[])new Expression[]{(Expression)unwrappedMapLambdaExpr.get()}));
        methodCallExpr.setScope((Expression)callMap);
        mapScope.setParentNode((Node)callMap);
        this.adjustMethodName(methodCallExpr);
        return true;
    }

    private boolean isAncestor(Node ancestor, Node descendant) {
        return descendant.findAncestor(n -> n == ancestor, new Class[]{Node.class}).isPresent();
    }

    protected Optional<String> computeMapMethodName(NodeAndSymbolSolver<? extends Expression> expression, Type type) {
        return Optional.of(METHOD_MAP);
    }

    protected void adjustMethodName(MethodCallExpr methodCallExpr) {
    }
}

