/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.IntegerLiteralExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.UnaryExpr;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserExprMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.helpers.MethodCallExprHelpers;
import java.util.Optional;
import java.util.Set;

public class StringIndexOfToContains
extends AJavaparserExprMutator {
    final IntegerLiteralExpr zeroLiteral = new IntegerLiteralExpr("0");

    public String minimalJavaVersion() {
        return "1.4";
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"String");
    }

    public Optional<String> getJSparrowId() {
        return Optional.of("IndexOfToContains");
    }

    public String jSparrowUrl() {
        return "https://jsparrow.github.io/rules/index-of-to-contains.html";
    }

    public boolean isDraft() {
        return false;
    }

    protected Class<?> expectedArgumentClass() {
        return String.class;
    }

    protected Class<?> expectedScopeClass() {
        return String.class;
    }

    @Override
    protected boolean processExpression(NodeAndSymbolSolver<Expression> expr) {
        MethodCallExpr containsCall;
        boolean negateContains;
        if (!expr.getNode().isBinaryExpr()) {
            return false;
        }
        BinaryExpr binaryExpr = expr.getNode().asBinaryExpr();
        Expression right = binaryExpr.getRight();
        Expression left = binaryExpr.getLeft();
        BinaryExpr.Operator operator = binaryExpr.getOperator();
        if (operator == BinaryExpr.Operator.GREATER_EQUALS && right.equals((Object)this.zeroLiteral) || left.equals((Object)this.zeroLiteral) && operator == BinaryExpr.Operator.LESS_EQUALS) {
            negateContains = false;
        } else if (operator == BinaryExpr.Operator.LESS && right.equals((Object)this.zeroLiteral) || left.equals((Object)this.zeroLiteral) && operator == BinaryExpr.Operator.GREATER) {
            negateContains = true;
        } else {
            return false;
        }
        if (this.isIndexOf(expr.editNode(left))) {
            MethodCallExpr indexOfCall = left.asMethodCallExpr();
            containsCall = new MethodCallExpr((Expression)indexOfCall.getScope().get(), "contains", indexOfCall.getArguments());
        } else if (this.isIndexOf(expr.editNode(right))) {
            MethodCallExpr indexOfCall = right.asMethodCallExpr();
            containsCall = new MethodCallExpr((Expression)indexOfCall.getScope().get(), "contains", indexOfCall.getArguments());
        } else {
            return false;
        }
        if (negateContains) {
            containsCall = new UnaryExpr((Expression)containsCall, UnaryExpr.Operator.LOGICAL_COMPLEMENT);
        }
        return this.tryReplace(expr, (Node)containsCall);
    }

    private boolean isIndexOf(NodeAndSymbolSolver<Expression> left) {
        if (!left.getNode().isMethodCallExpr()) {
            return false;
        }
        MethodCallExpr methodCallExpr = left.getNode().asMethodCallExpr();
        if (!"indexOf".equals(methodCallExpr.getNameAsString())) {
            return false;
        }
        if (methodCallExpr.getArguments().size() != 1) {
            return false;
        }
        if (!MethodCallExprHelpers.scopeHasRequiredType(left.editNode(methodCallExpr.getScope()), this.expectedScopeClass())) {
            return false;
        }
        return MethodCallExprHelpers.scopeHasRequiredType(left.editNode(methodCallExpr.getArgument(0)), this.expectedArgumentClass());
    }
}

