/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ForEachStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.util.Optional;

public class StreamMutatorHelpers {
    protected StreamMutatorHelpers() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Optional<Statement> findSingleStatement(Statement maybeBlockorSingleStatement) {
        Statement singleStatement;
        if (maybeBlockorSingleStatement.isBlockStmt()) {
            BlockStmt asBlockStmt = maybeBlockorSingleStatement.asBlockStmt();
            if (asBlockStmt.getStatements().size() != 1) return Optional.empty();
            singleStatement = asBlockStmt.getStatement(0);
            return Optional.of(singleStatement);
        } else {
            singleStatement = maybeBlockorSingleStatement;
        }
        return Optional.of(singleStatement);
    }

    public static Optional<IfStmt> findSingleIfThenStmt(ForEachStmt forEachStmt) {
        Optional<Statement> optSingleStatement = StreamMutatorHelpers.findSingleStatement(forEachStmt.getBody());
        if (optSingleStatement.isEmpty()) {
            return Optional.empty();
        }
        Statement singleStatement = optSingleStatement.get();
        return StreamMutatorHelpers.findSingleIfThenStmt(singleStatement);
    }

    public static Optional<IfStmt> findSingleIfThenStmt(Statement singleStatement) {
        if (!singleStatement.isIfStmt()) {
            return Optional.empty();
        }
        IfStmt ifStmt = singleStatement.asIfStmt();
        if (ifStmt.getElseStmt().isPresent()) {
            return Optional.empty();
        }
        return Optional.of(ifStmt);
    }

    public static Optional<MethodCallExpr> findSingleMethodCallExpr(Statement maybeExpressionStmtOrStatement) {
        if (maybeExpressionStmtOrStatement.isExpressionStmt()) {
            Expression expr = maybeExpressionStmtOrStatement.asExpressionStmt().getExpression();
            if (expr.isMethodCallExpr()) {
                return Optional.of(expr.asMethodCallExpr());
            }
            return Optional.empty();
        }
        if (maybeExpressionStmtOrStatement.isBlockStmt()) {
            BlockStmt blockStmt = maybeExpressionStmtOrStatement.asBlockStmt();
            if (blockStmt.getStatements().size() != 1) {
                return Optional.empty();
            }
            return StreamMutatorHelpers.findSingleMethodCallExpr(blockStmt.getStatement(0));
        }
        return Optional.empty();
    }
}

