/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.UnaryExpr;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserExprMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class SimplifyBooleanExpression
extends AJavaparserExprMutator {
    final Map<BinaryExpr.Operator, BinaryExpr.Operator> operatorToOpposite = ImmutableMap.builder().put((Object)BinaryExpr.Operator.EQUALS, (Object)BinaryExpr.Operator.NOT_EQUALS).put((Object)BinaryExpr.Operator.LESS, (Object)BinaryExpr.Operator.GREATER_EQUALS).put((Object)BinaryExpr.Operator.LESS_EQUALS, (Object)BinaryExpr.Operator.GREATER).put((Object)BinaryExpr.Operator.GREATER, (Object)BinaryExpr.Operator.LESS_EQUALS).put((Object)BinaryExpr.Operator.GREATER_EQUALS, (Object)BinaryExpr.Operator.LESS).build();

    public String minimalJavaVersion() {
        return "1";
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"PitFall");
    }

    public Optional<String> getSonarId() {
        return Optional.of("RSPEC-1940");
    }

    public boolean isDraft() {
        return false;
    }

    @Override
    protected boolean processExpression(NodeAndSymbolSolver<Expression> expr) {
        if (!expr.getNode().isUnaryExpr()) {
            return false;
        }
        UnaryExpr unaryExpr = expr.getNode().asUnaryExpr();
        if (this.isLogicalComplement(unaryExpr)) {
            return false;
        }
        Expression underlyingExpression = unaryExpr.getExpression();
        while (underlyingExpression.isEnclosedExpr()) {
            underlyingExpression = underlyingExpression.asEnclosedExpr().getInner();
        }
        if (!underlyingExpression.isBinaryExpr()) {
            return false;
        }
        BinaryExpr underlyingBinaryExpr = underlyingExpression.asBinaryExpr();
        BinaryExpr.Operator initialOperator = underlyingBinaryExpr.getOperator();
        if (!this.operatorToOpposite.containsKey(initialOperator)) {
            return false;
        }
        boolean replaced = this.tryReplace((Node)expr.getNode(), (Node)underlyingBinaryExpr);
        if (replaced) {
            underlyingBinaryExpr.setOperator(this.operatorToOpposite.get(initialOperator));
        }
        return replaced;
    }

    private boolean isLogicalComplement(UnaryExpr unaryExpr) {
        return unaryExpr.getOperator() != UnaryExpr.Operator.LOGICAL_COMPLEMENT;
    }
}

