/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.resolution.types.ResolvedPrimitiveType;
import com.github.javaparser.resolution.types.ResolvedType;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserExprMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.helpers.ResolvedTypeHelpers;
import java.util.Optional;
import java.util.Set;

public class PrimitiveWrapperInstantiation
extends AJavaparserExprMutator {
    public String minimalJavaVersion() {
        return "1.5";
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"Primitive");
    }

    public Set<String> getLegacyIds() {
        return Set.of("BoxedPrimitiveConstructor");
    }

    public Optional<String> getPmdId() {
        return Optional.of("PrimitiveWrapperInstantiation");
    }

    public String pmdUrl() {
        return "https://pmd.github.io/latest/pmd_rules_java_bestpractices.html#primitivewrapperinstantiation";
    }

    @Override
    protected boolean processExpression(NodeAndSymbolSolver<Expression> expr) {
        if (!expr.getNode().isObjectCreationExpr()) {
            return false;
        }
        ObjectCreationExpr objectCreationExpr = expr.getNode().asObjectCreationExpr();
        if (objectCreationExpr.getArguments().size() != 1) {
            return false;
        }
        ClassOrInterfaceType type = objectCreationExpr.getType();
        if (!this.isBoxType(type)) {
            return false;
        }
        MethodCallExpr newMethodCall = new MethodCallExpr((Expression)new NameExpr(type.getName()), "valueOf", objectCreationExpr.getArguments());
        return this.tryReplace((Node)objectCreationExpr, (Node)newMethodCall);
    }

    private boolean isBoxType(ClassOrInterfaceType type) {
        if (type.isBoxedType()) {
            Optional<ResolvedType> optResolvedType = ResolvedTypeHelpers.optResolvedType((Type)type);
            if (optResolvedType.isEmpty()) {
                return false;
            }
            return ResolvedPrimitiveType.isBoxType((ResolvedType)optResolvedType.get());
        }
        return false;
    }
}

